/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trace.Instrumentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class CountingFilter
extends ProxyReceiver {
    private static int nextid = 0;
    private int id = nextid++;

    public CountingFilter(Receiver nextReceiver) {
        super(nextReceiver);
    }

    public int getId() {
        return this.id;
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        Instrumentation.count("append");
        if (this.nextReceiver instanceof SequenceReceiver) {
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        } else {
            super.append(item, locationId, copyNamespaces);
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        Instrumentation.count("attribute");
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        Instrumentation.count("characters");
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void close() throws XPathException {
        Instrumentation.count("close");
        this.nextReceiver.close();
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        Instrumentation.count("comment");
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void endDocument() throws XPathException {
        Instrumentation.count("endDocument");
        this.nextReceiver.endDocument();
    }

    public void endElement() throws XPathException {
        Instrumentation.count("endElement");
        this.nextReceiver.endElement();
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding ns : namespaceBindings) {
            Instrumentation.count("namespace");
        }
        this.nextReceiver.namespace(namespaceBindings, properties);
    }

    public void open() throws XPathException {
        Instrumentation.count("open");
        this.nextReceiver.open();
    }

    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        Instrumentation.count("processingInstruction");
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    public void startContent() throws XPathException {
        Instrumentation.count("startContent");
        this.nextReceiver.startContent();
    }

    public void startDocument(int properties) throws XPathException {
        Instrumentation.count("startDocument");
        this.nextReceiver.startDocument(properties);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        Instrumentation.count("startElement");
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
    }
}

