/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.XPathException;

public class PackageVersion
implements Comparable {
    public List<Integer> parts;
    public String suffix;
    public static PackageVersion ZERO = new PackageVersion(new int[]{0});
    public static PackageVersion ONE = new PackageVersion(new int[]{1});
    public static PackageVersion MAX_VALUE = new PackageVersion(new int[]{Integer.MAX_VALUE});

    public PackageVersion(int[] values2) {
        this.parts = new ArrayList<Integer>(values2.length);
        for (int value : values2) {
            this.parts.add(value);
        }
        this.trimTrailingZeroes();
    }

    private void trimTrailingZeroes() {
        for (int i2 = this.parts.size() - 1; i2 > 0; --i2) {
            if (this.parts.get(i2) != 0) {
                return;
            }
            this.parts.remove(i2);
        }
    }

    public PackageVersion(String s2) throws XPathException {
        this.parts = new ArrayList<Integer>();
        String original = s2;
        if (s2.contains("-")) {
            int i2 = s2.indexOf(45);
            this.suffix = s2.substring(i2 + 1);
            if (!NameChecker.isValidNCName(this.suffix)) {
                throw new XPathException("Illegal NCName as package-version NamePart: " + original, "XTSE0020");
            }
            s2 = s2.substring(0, i2);
        }
        if (s2.equals("")) {
            throw new XPathException("No numeric component of package-version: " + original, "XTSE0020");
        }
        if (s2.startsWith(".")) {
            throw new XPathException("The package-version cannot start with '.'", "XTSE0020");
        }
        if (s2.endsWith(".")) {
            throw new XPathException("The package-version cannot end with '.'", "XTSE0020");
        }
        for (String p : s2.trim().split("\\.")) {
            try {
                this.parts.add(new Integer(p));
            }
            catch (NumberFormatException e) {
                throw new XPathException("Error in package-version: " + e.getMessage(), "XTSE0020");
            }
        }
        this.trimTrailingZeroes();
    }

    public boolean equals(Object o) {
        if (o instanceof PackageVersion) {
            PackageVersion p = (PackageVersion)o;
            if (this.parts.equals(p.parts)) {
                if (this.suffix != null) {
                    return this.suffix.equals(p.suffix);
                }
                return p.suffix == null;
            }
        }
        return false;
    }

    public boolean equalsIgnoringSuffix(PackageVersion other) {
        return this.parts.equals(other.parts);
    }

    public int compareTo(Object o) {
        if (o instanceof PackageVersion) {
            PackageVersion pv = (PackageVersion)o;
            List<Integer> p = pv.parts;
            int extent = this.parts.size() - p.size();
            int len = Math.min(this.parts.size(), p.size());
            for (int i2 = 0; i2 < len; ++i2) {
                int comp = this.parts.get(i2).compareTo(p.get(i2));
                if (comp == 0) continue;
                return comp;
            }
            if (extent == 0) {
                if (this.suffix != null) {
                    if (pv.suffix == null) {
                        return -1;
                    }
                    return this.suffix.compareTo(pv.suffix);
                }
                if (pv.suffix != null) {
                    return 1;
                }
            }
            return extent;
        }
        throw new ClassCastException("Cannot compare a PackageVersion against " + o.getClass().toString());
    }

    public String toString() {
        String result = "";
        for (Integer i2 : this.parts) {
            result = result + "." + i2;
        }
        if (this.parts.size() > 0) {
            result = result.substring(1);
        }
        if (this.suffix != null) {
            result = result + "-" + this.suffix;
        }
        return result;
    }

    public boolean isPrefix(PackageVersion v) {
        if (v.parts.size() >= this.parts.size()) {
            for (int i2 = 0; i2 < this.parts.size(); ++i2) {
                if (this.parts.get(i2).equals(v.parts.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

