/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;

public class CaseFirstCollator
implements StringCollator {
    private StringCollator baseCollator;
    private boolean upperFirst;
    private String uri;

    public CaseFirstCollator(StringCollator base, boolean upperFirst, String collationURI) {
        this.baseCollator = base;
        this.upperFirst = upperFirst;
        this.uri = collationURI;
    }

    public String getCollationURI() {
        return this.uri;
    }

    public int compareStrings(CharSequence a, CharSequence b) {
        int diff = this.baseCollator.compareStrings(a, b);
        if (diff != 0) {
            return diff;
        }
        int i2 = 0;
        int j = 0;
        while (true) {
            boolean bFirst;
            if (i2 < a.length() && j < b.length() && a.charAt(i2) == b.charAt(j)) {
                ++i2;
                ++j;
                continue;
            }
            while (i2 < a.length() && !Character.isLetter(a.charAt(i2))) {
                ++i2;
            }
            while (j < b.length() && !Character.isLetter(b.charAt(j))) {
                ++j;
            }
            if (i2 >= a.length()) {
                return 0;
            }
            if (j >= b.length()) {
                return 0;
            }
            boolean aFirst = this.upperFirst ? Character.isUpperCase(a.charAt(i2++)) : Character.isLowerCase(a.charAt(i2++));
            boolean bl = bFirst = this.upperFirst ? Character.isUpperCase(b.charAt(j++)) : Character.isLowerCase(b.charAt(j++));
            if (aFirst && !bFirst) {
                return -1;
            }
            if (bFirst && !aFirst) break;
        }
        return 1;
    }

    public boolean comparesEqual(CharSequence s1, CharSequence s2) {
        return this.compareStrings(s1, s2) == 0;
    }

    public AtomicMatchKey getCollationKey(CharSequence s2) {
        return this.baseCollator.getCollationKey(s2);
    }
}

