/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.InstructionWithComplexContent;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.ReconfigurableSerializer;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDocument
extends Instruction
implements ValidatingInstruction,
InstructionWithComplexContent {
    private Operand hrefOp;
    private Operand formatOp;
    private Operand contentOp;
    private boolean async = false;
    protected Properties globalProperties;
    protected Properties localProperties;
    protected ParseOptions validationOptions;
    protected Map<StructuredQName, Operand> serializationAttributes;
    protected boolean resolveAgainstStaticBase = false;
    protected CharacterMapIndex characterMapIndex;

    public ResultDocument(Properties globalProperties, Properties localProperties, Expression href, Expression formatExpression, int validationAction, SchemaType schemaType, Map<StructuredQName, Expression> serializationAttributes, CharacterMapIndex characterMapIndex) {
        this.globalProperties = globalProperties;
        this.localProperties = localProperties;
        if (href != null) {
            this.hrefOp = new Operand(this, href, OperandRole.SINGLE_ATOMIC);
        }
        if (formatExpression != null) {
            this.formatOp = new Operand(this, formatExpression, OperandRole.SINGLE_ATOMIC);
        }
        this.setValidationAction(validationAction, schemaType);
        this.serializationAttributes = new HashMap<StructuredQName, Operand>(serializationAttributes.size());
        for (Map.Entry<StructuredQName, Expression> entry : serializationAttributes.entrySet()) {
            this.serializationAttributes.put(entry.getKey(), new Operand(this, entry.getValue(), OperandRole.SINGLE_ATOMIC));
        }
        this.characterMapIndex = characterMapIndex;
        for (Expression e : serializationAttributes.values()) {
            this.adoptChildExpression(e);
        }
    }

    public void setContentExpression(Expression content) {
        this.contentOp = new Operand(this, content, OperandRole.SINGLE_ATOMIC);
    }

    public void setSchemaType(SchemaType type) {
        if (this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
        }
        this.validationOptions.setSchemaValidationMode(8);
        this.validationOptions.setTopLevelType(type);
    }

    @Override
    public SchemaType getSchemaType() {
        return this.validationOptions == null ? null : this.validationOptions.getTopLevelType();
    }

    public boolean isResolveAgainstStaticBase() {
        return this.resolveAgainstStaticBase;
    }

    public ParseOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationAction(int mode, SchemaType schemaType) {
        boolean preservingTypes;
        boolean bl = preservingTypes = mode == 3 && schemaType == null;
        if (!preservingTypes && this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
            this.validationOptions.setSchemaValidationMode(mode);
            this.validationOptions.setTopLevelType(schemaType);
        }
    }

    @Override
    public int getValidationAction() {
        return this.validationOptions == null ? 3 : this.validationOptions.getSchemaValidationMode();
    }

    public Expression getFormatExpression() {
        return this.formatOp == null ? null : this.formatOp.getChildExpression();
    }

    public void setUseStaticBaseUri(boolean staticBase) {
        this.resolveAgainstStaticBase = staticBase;
    }

    public void setAsynchronous(boolean async) {
        this.async = async;
    }

    public boolean isAsynchronous() {
        return this.async;
    }

    @Override
    public boolean isMultiThreaded(Configuration config) {
        return this.isAsynchronous() && config.isLicensedFeature(1) && config.getBooleanProperty("http://saxon.sf.net/feature/allow-multithreading");
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        String method = this.getStaticSerializationProperty(XSLResultDocument.METHOD);
        boolean contentDependentMethod = method == null && this.formatOp == null && !this.serializationAttributes.containsKey(XSLResultDocument.METHOD);
        boolean buildTree = "yes".equals(this.getStaticSerializationProperty(XSLResultDocument.BUILD_TREE));
        if (buildTree || contentDependentMethod || "xml".equals(method) || "html".equals(method) || "xhtml".equals(method) || "text".equals(method)) {
            try {
                DocumentInstr.checkContentSequence(visitor.getStaticContext(), this.contentOp, this.validationOptions);
            }
            catch (XPathException err) {
                err.maybeSetLocation(this.getLocation());
                throw err;
            }
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        if (this.isAsynchronous()) {
            for (Expression e = this.getParentExpression(); e != null; e = e.getParentExpression()) {
                if (!(e instanceof LetExpression) || !ExpressionTool.dependsOnVariable(this.getContentExpression(), new Binding[]{(LetExpression)e})) continue;
                ((LetExpression)e).setNeedsEagerEvaluation(true);
            }
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        HashMap<StructuredQName, Expression> map = new HashMap<StructuredQName, Expression>();
        for (Map.Entry<StructuredQName, Operand> entry : this.serializationAttributes.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getChildExpression());
        }
        ResultDocument r = new ResultDocument(this.globalProperties, this.localProperties, this.getHref() == null ? null : this.getHref().copy(rebindings), this.getFormatExpression() == null ? null : this.getFormatExpression().copy(rebindings), this.getValidationAction(), this.getSchemaType(), map, this.characterMapIndex);
        ExpressionTool.copyLocationInfo(this, r);
        r.setContentExpression(this.getContentExpression().copy(rebindings));
        r.resolveAgainstStaticBase = this.resolveAgainstStaticBase;
        r.async = this.async;
        return r;
    }

    @Override
    public int getInstructionNameCode() {
        return 193;
    }

    @Override
    public ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(6);
        list.add(this.contentOp);
        if (this.hrefOp != null) {
            list.add(this.hrefOp);
        }
        if (this.formatOp != null) {
            list.add(this.formatOp);
        }
        for (Operand e : this.serializationAttributes.values()) {
            list.add(e);
        }
        return list;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        this.process(this.getContentExpression(), context);
        return null;
    }

    public void process(Expression content, XPathContext context) throws XPathException {
        if (context.getTemporaryOutputState() != 0) {
            XPathException err = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + context.getNamePool().getLocalName(context.getTemporaryOutputState()));
            err.setErrorCode("XTDE1480");
            err.setLocation(this.getLocation());
            throw err;
        }
        context.getConfiguration().processResultDocument(this, content, context);
    }

    public void processInstruction(Expression content, XPathContext context) throws XPathException {
        Receiver out;
        Controller controller = context.getController();
        assert (controller != null);
        SequenceReceiver saved = context.getReceiver();
        String savedOutputUri = context.getCurrentOutputUri();
        if (context.getTemporaryOutputState() != 0) {
            XPathException err = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + context.getNamePool().getLocalName(context.getTemporaryOutputState()));
            err.setErrorCode("XTDE1480");
            err.setLocation(this.getLocation());
            throw err;
        }
        Properties computedLocalProps = this.gatherOutputProperties(context);
        if (this.getStaticBaseURIString() != null) {
            computedLocalProps.setProperty("{http://saxon.sf.net/}parameter-document-base-uri", this.getStaticBaseURIString());
        }
        String nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        OutputURIResolver resolver = null;
        CloseableResult closeableResult = null;
        Result result = null;
        boolean buildTree = SaxonOutputKeys.isBuildTree(computedLocalProps);
        if (this.getHref() == null) {
            if (!computedLocalProps.propertyNames().hasMoreElements()) {
                out = controller.getPrincipalResult();
            } else if (controller.getPrincipalResult() instanceof ReconfigurableSerializer) {
                ReconfigurableSerializer rs = (ReconfigurableSerializer)controller.getPrincipalResult();
                rs.reconfigure(computedLocalProps, this.characterMapIndex);
                out = rs;
            } else {
                out = controller.getPrincipalResult();
            }
            String resultURI = controller.getBaseOutputURI();
            if (resultURI == null) {
                resultURI = "dummy:/anonymous/principal/result";
            }
            ResultDocument.checkAcceptableUri(context, resultURI);
            if (buildTree) {
                out = ComplexContentOutputter.makeComplexContentReceiver(out, this.getValidationOptions());
            }
            context.setReceiver((SequenceReceiver)out);
            context.setCurrentOutputUri(resultURI);
        } else {
            resolver = controller.getOutputURIResolver().newInstance();
            try {
                closeableResult = ResultDocument.getResult(this.getHref(), this.getStaticBaseURIString(), context, resolver, this.resolveAgainstStaticBase);
                result = closeableResult.result;
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
            SerializerFactory sf = context.getConfiguration().getSerializerFactory();
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setLocationIsCodeLocation(true);
            pipe.setHostLanguage(50);
            out = sf.getReceiver(result, pipe, computedLocalProps, this.characterMapIndex);
            if (buildTree) {
                out = ComplexContentOutputter.makeComplexContentReceiver(out, this.getValidationOptions());
            }
            out.getPipelineConfiguration().setLocationIsCodeLocation(true);
            out.setSystemId(result.getSystemId());
            context.setReceiver((SequenceReceiver)out);
            context.setCurrentOutputUri(result.getSystemId());
        }
        out.open();
        try {
            if (buildTree) {
                out.startDocument(0);
                content.process(context);
                out.endDocument();
            } else {
                content.process(context);
            }
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.maybeSetLocation(this.getLocation());
            throw err;
        }
        finally {
            out.close();
        }
        context.setReceiver(saved);
        context.setCurrentOutputUri(savedOutputUri);
        if (closeableResult != null) {
            try {
                closeableResult.close();
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
    }

    public static CloseableResult getResult(Expression href, String baseURI, XPathContext context, OutputURIResolver resolver, boolean resolveAgainstStaticBase) throws XPathException {
        CloseableResult closeable;
        String resultURI;
        Result result;
        block14: {
            boolean resultFromResolver = false;
            Controller controller = context.getController();
            if (href == null) {
                result = controller.getPrincipalResult();
                resultURI = controller.getBaseOutputURI();
                if (resultURI == null) {
                    resultURI = "dummy:/anonymous/principal/result";
                }
                closeable = new CloseableResult();
                closeable.result = result;
            } else {
                try {
                    String base = resolveAgainstStaticBase ? baseURI : controller.getCookedBaseOutputURI();
                    String hrefValue = IriToUri.iriToUri(href.evaluateAsString(context)).toString();
                    if (hrefValue.equals("")) {
                        result = controller.getPrincipalResult();
                        resultURI = controller.getBaseOutputURI();
                        if (resultURI == null) {
                            resultURI = "dummy:/anonymous/principal/result";
                        }
                        closeable = new CloseableResult();
                        closeable.result = result;
                        break block14;
                    }
                    try {
                        result = resolver == null ? null : resolver.resolve(hrefValue, base);
                    }
                    catch (TransformerException err) {
                        throw XPathException.makeXPathException(err);
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                        throw new XPathException("Exception thrown by OutputURIResolver", err);
                    }
                    if (result == null) {
                        resolver = StandardOutputResolver.getInstance();
                        result = resolver.resolve(hrefValue, base);
                    }
                    final OutputURIResolver finalResolver = resolver;
                    closeable = new CloseableResult(){

                        public void close() throws TransformerException {
                            finalResolver.close(this.result);
                        }
                    };
                    closeable.result = result;
                    resultURI = result.getSystemId();
                    if (resultURI == null) {
                        try {
                            resultURI = new URI(base).resolve(hrefValue).toString();
                            result.setSystemId(resultURI);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (TransformerException e) {
                    throw XPathException.makeXPathException(e);
                }
            }
        }
        ResultDocument.checkAcceptableUri(context, resultURI);
        ResultDocument.traceDestination(context, result);
        return closeable;
    }

    public static void traceDestination(XPathContext context, Result result) {
        Configuration config = context.getConfiguration();
        boolean timing = config.isTiming();
        if (timing) {
            String dest = result.getSystemId();
            if (dest == null) {
                dest = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            config.getStandardErrorOutput().println("Writing to " + dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAcceptableUri(XPathContext context, String uri) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (uri != null) {
            if (controller.getDocumentPool().find(uri) != null) {
                XPathException err = new XPathException("Cannot write to a URI that has already been read: " + (uri.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : uri));
                err.setXPathContext(context);
                err.setErrorCode("XTDE1500");
                throw err;
            }
            DocumentURI documentKey = new DocumentURI(uri);
            Controller controller2 = controller;
            synchronized (controller2) {
                if (!controller.checkUniqueOutputDestination(documentKey)) {
                    XPathException err = new XPathException("Cannot write more than one result document to the same URI: " + (uri.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : uri));
                    err.setXPathContext(context);
                    err.setErrorCode("XTDE1490");
                    throw err;
                }
                controller.addUnavailableOutputDestination(documentKey);
            }
        }
        controller.setThereHasBeenAnExplicitResultDocument();
    }

    public Properties gatherOutputProperties(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Configuration config = context.getConfiguration();
        Properties computedGlobalProps = this.globalProperties;
        RetainedStaticContext nsResolver = this.getRetainedStaticContext();
        if (this.getFormatExpression() != null) {
            String[] parts;
            CharSequence format = this.getFormatExpression().evaluateAsString(context);
            try {
                parts = NameChecker.getQNameParts(format);
            }
            catch (QNameException qNameException) {
                XPathException err = new XPathException("The requested output format " + Err.wrap(format) + " is not a valid QName");
                err.maybeSetLocation(this.getFormatExpression().getLocation());
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            String string = nsResolver.getURIForPrefix(parts[0], false);
            if (string == null) {
                XPathException err = new XPathException("The namespace prefix in the format name " + format + " is undeclared");
                err.maybeSetLocation(this.getFormatExpression().getLocation());
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            StructuredQName qName = new StructuredQName(parts[0], string, parts[1]);
            computedGlobalProps = ((StylesheetPackage)this.getRetainedStaticContext().getPackageData()).getNamedOutputProperties(qName);
            if (computedGlobalProps == null) {
                XPathException err = new XPathException("There is no xsl:output format named " + format);
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
        }
        Properties computedLocalProps = new Properties(computedGlobalProps);
        for (Object object : this.localProperties.keySet()) {
            String key = (String)object;
            StructuredQName qName = StructuredQName.fromClarkName(key);
            try {
                ResultDocument.setSerializationProperty(computedLocalProps, qName.getURI(), qName.getLocalPart(), this.localProperties.getProperty(key), nsResolver, true, config);
            }
            catch (XPathException e) {
                e.setErrorCode("XTDE0030");
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            for (Map.Entry entry : this.serializationAttributes.entrySet()) {
                String value = ((Operand)entry.getValue()).getChildExpression().evaluateAsString(context).toString();
                String lname = ((StructuredQName)entry.getKey()).getLocalPart();
                String uri = ((StructuredQName)entry.getKey()).getURI();
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, uri, lname, value, nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.setErrorCode("XTDE0030");
                    e.maybeSetLocation(this.getLocation());
                    e.maybeSetContext(context);
                    if ("http://saxon.sf.net/".equals(e.getErrorCodeNamespace()) && "SXWN".equals(e.getErrorCodeLocalPart().substring(0, 4))) {
                        controller.getErrorListener().warning(e);
                        continue;
                    }
                    throw e;
                }
            }
        }
        return computedLocalProps;
    }

    public String getStaticSerializationProperty(StructuredQName name) {
        String clarkName = name.getClarkName();
        String local = this.localProperties.getProperty(clarkName);
        if (local != null) {
            return local;
        }
        if (this.serializationAttributes.containsKey(name)) {
            return null;
        }
        return this.globalProperties.getProperty(clarkName);
    }

    public static void setSerializationProperty(Properties details, String uri, String lname, String value, NamespaceResolver nsResolver, boolean prevalidated, Configuration config) throws XPathException {
        SerializerFactory sf = config.getSerializerFactory();
        String clarkName = lname;
        if (!uri.isEmpty()) {
            clarkName = '{' + uri + '}' + lname;
        }
        if (uri.isEmpty() || "http://saxon.sf.net/".equals(uri)) {
            if (clarkName.equals("method")) {
                if ((value = Whitespace.trim(value)).startsWith("Q{}") && value.length() > 3) {
                    value = value.substring(3);
                }
                if (value.equals("xml") || value.equals("html") || value.equals("text") || value.equals("xhtml") || value.equals("json") || value.equals("adaptive") || prevalidated || value.startsWith("{")) {
                    details.setProperty("method", value);
                } else if (value.startsWith("Q{")) {
                    details.setProperty("method", value.substring(1));
                } else {
                    try {
                        String[] parts = NameChecker.getQNameParts(value);
                        String prefix = parts[0];
                        if (prefix.isEmpty()) {
                            XPathException err = new XPathException("method must be xml, html, xhtml, text, json, adaptive, or a prefixed name");
                            err.setErrorCode("SEPM0016");
                            err.setIsStaticError(true);
                            throw err;
                        }
                        if (nsResolver != null) {
                            String muri = nsResolver.getURIForPrefix(prefix, false);
                            if (muri == null) {
                                XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
                                err.setErrorCode("SEPM0016");
                                err.setIsStaticError(true);
                                throw err;
                            }
                            details.setProperty("method", '{' + muri + '}' + parts[1]);
                        }
                        details.setProperty("method", value);
                    }
                    catch (QNameException e) {
                        XPathException err = new XPathException("Invalid method name. " + e.getMessage());
                        err.setErrorCode("SEPM0016");
                        err.setIsStaticError(true);
                        throw err;
                    }
                }
            } else if (clarkName.equals("use-character-maps")) {
                String existing = details.getProperty("use-character-maps");
                if (existing == null) {
                    existing = "";
                }
                details.setProperty("use-character-maps", existing + value);
            } else if (clarkName.equals("cdata-section-elements")) {
                ResultDocument.processListOfNodeNames(details, "cdata-section-elements", value, nsResolver, true, prevalidated);
            } else if (clarkName.equals("suppress-indentation")) {
                ResultDocument.processListOfNodeNames(details, "suppress-indentation", value, nsResolver, true, prevalidated);
            } else if (clarkName.equals("{http://saxon.sf.net/}double-space")) {
                ResultDocument.processListOfNodeNames(details, "{http://saxon.sf.net/}double-space", value, nsResolver, true, prevalidated);
            } else if (clarkName.equals("{http://saxon.sf.net/}attribute-order")) {
                ResultDocument.processListOfNodeNames(details, "{http://saxon.sf.net/}attribute-order", value, nsResolver, false, prevalidated);
            } else if (!clarkName.equals("{http://saxon.sf.net/}next-in-chain")) {
                if (clarkName.equals("output-version")) {
                    clarkName = "version";
                }
                if (!prevalidated) {
                    try {
                        if (!"item-separator".equals(clarkName) && !"{http://saxon.sf.net/}newline".equals(clarkName)) {
                            value = Whitespace.trim(value);
                        }
                        value = sf.checkOutputProperty(clarkName, value);
                    }
                    catch (XPathException err) {
                        err.maybeSetErrorCode("SEPM0016");
                        throw err;
                    }
                }
                details.setProperty(clarkName, value);
            }
        } else {
            details.setProperty('{' + uri + '}' + lname, value);
        }
    }

    private static void processListOfNodeNames(Properties details, String key, String value, NamespaceResolver nsResolver, boolean useDefaultNS, boolean prevalidated) throws XPathException {
        String existing = details.getProperty(key);
        if (existing == null) {
            existing = "";
        }
        String s2 = SaxonOutputKeys.parseListOfNodeNames(value, nsResolver, useDefaultNS, prevalidated, "SEPM0016");
        details.setProperty(key, existing + s2);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        SchemaType schemaType;
        out.startElement("resultDoc", this);
        out.emitAttribute("global", this.exportProperties(this.globalProperties));
        out.emitAttribute("local", this.exportProperties(this.localProperties));
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if ((schemaType = this.getSchemaType()) != null) {
            out.emitAttribute("type", schemaType.getEQName());
        }
        if (this.getHref() != null) {
            out.setChildRole("href");
            this.getHref().export(out);
        }
        if (this.getFormatExpression() != null) {
            out.setChildRole("format");
            this.getFormatExpression().export(out);
        }
        for (Map.Entry<StructuredQName, Operand> p : this.serializationAttributes.entrySet()) {
            StructuredQName name = p.getKey();
            Expression value = p.getValue().getChildExpression();
            out.setChildRole(name.getEQName());
            value.export(out);
        }
        out.setChildRole("content");
        this.getContentExpression().export(out);
        out.endElement();
    }

    private String exportProperties(Properties props) {
        try {
            StringWriter writer = new StringWriter();
            props.store(writer, "");
            return writer.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void processXslOutputElement(NodeInfo element, Properties props, XPathContext c) throws XPathException {
        NodeInfo att;
        AxisIterator iter = element.iterateAxis((byte)2);
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        while ((att = (NodeInfo)iter.next()) != null) {
            String uri = att.getURI();
            String local = att.getLocalPart();
            String val = Whitespace.trim(att.getStringValueCS());
            ResultDocument.setSerializationProperty(props, uri, local, val, resolver, false, c.getConfiguration());
        }
    }

    @Override
    public String getStreamerName() {
        return "ResultDocument";
    }

    public Expression getHref() {
        return this.hrefOp == null ? null : this.hrefOp.getChildExpression();
    }

    public void setHref(Expression href) {
        this.hrefOp.setChildExpression(href);
    }

    public void setFormatExpression(Expression formatExpression) {
        this.formatOp.setChildExpression(formatExpression);
    }

    @Override
    public Expression getContentExpression() {
        return this.contentOp.getChildExpression();
    }

    public static class CloseableResult {
        public Result result;

        public void close() throws TransformerException {
        }
    }
}

