/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.expr.sort.UntypedNumericComparer;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.GenerateId_1;
import net.sf.saxon.functions.PositionAndLast;
import net.sf.saxon.functions.StringLength_1;
import net.sf.saxon.functions.Subsequence_2;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public final class ValueComparison
extends BinaryExpression
implements ComparisonExpression,
Negatable {
    private AtomicComparer comparer;
    private BooleanValue resultWhenEmpty = null;
    private boolean needsRuntimeCheck;

    public ValueComparison(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    public String getExpressionName() {
        return "ValueComparison";
    }

    public void setAtomicComparer(AtomicComparer comparer) {
        this.comparer = comparer;
    }

    public AtomicComparer getAtomicComparer() {
        return this.comparer;
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return false;
    }

    public void setResultWhenEmpty(BooleanValue value) {
        this.resultWhenEmpty = value;
    }

    public BooleanValue getResultWhenEmpty() {
        return this.resultWhenEmpty;
    }

    public boolean needsRuntimeComparabilityCheck() {
        return this.needsRuntimeCheck;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        BuiltInAtomicType p1;
        this.resetLocalStaticProperties();
        this.typeCheckChildren(visitor, contextInfo);
        Configuration config = visitor.getConfiguration();
        StaticContext env = visitor.getStaticContext();
        if (Literal.isEmptySequence(this.getLhsExpression())) {
            return this.resultWhenEmpty == null ? this.getLhsExpression() : Literal.makeLiteral(this.resultWhenEmpty, this);
        }
        if (Literal.isEmptySequence(this.getRhsExpression())) {
            return this.resultWhenEmpty == null ? this.getRhsExpression() : Literal.makeLiteral(this.resultWhenEmpty, this);
        }
        if (this.comparer instanceof UntypedNumericComparer) {
            return this;
        }
        SequenceType optionalAtomic = SequenceType.OPTIONAL_ATOMIC;
        TypeChecker tc = config.getTypeChecker(false);
        RoleDiagnostic role0 = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(tc.staticTypeCheck(this.getLhsExpression(), optionalAtomic, role0, visitor));
        RoleDiagnostic role1 = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(tc.staticTypeCheck(this.getRhsExpression(), optionalAtomic, role1, visitor));
        PlainType t0 = this.getLhsExpression().getItemType().getAtomizedItemType();
        PlainType t1 = this.getRhsExpression().getItemType().getAtomizedItemType();
        if (t0.isExternalType() || t1.isExternalType()) {
            XPathException err = new XPathException("Cannot perform comparisons involving external objects");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            err.setLocation(this.getLocation());
            throw err;
        }
        BuiltInAtomicType p0 = (BuiltInAtomicType)t0.getPrimitiveItemType();
        if (p0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p0 = BuiltInAtomicType.STRING;
        }
        if ((p1 = (BuiltInAtomicType)t1.getPrimitiveItemType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            p1 = BuiltInAtomicType.STRING;
        }
        boolean bl = this.needsRuntimeCheck = p0.equals(BuiltInAtomicType.ANY_ATOMIC) || p1.equals(BuiltInAtomicType.ANY_ATOMIC);
        if (!this.needsRuntimeCheck && !Type.isPossiblyComparable(p0, p1, Token.isOrderedOperator(this.operator))) {
            boolean opt0 = Cardinality.allowsZero(this.getLhsExpression().getCardinality());
            boolean opt1 = Cardinality.allowsZero(this.getRhsExpression().getCardinality());
            if (opt0 || opt1) {
                String which = null;
                if (opt0) {
                    which = "the first operand is";
                }
                if (opt1) {
                    which = "the second operand is";
                }
                if (opt0 && opt1) {
                    which = "one or both operands are";
                }
                visitor.getStaticContext().issueWarning("Comparison of " + t0.toString() + (opt0 ? "?" : "") + " to " + t1.toString() + (opt1 ? "?" : "") + " will fail unless " + which + " empty", this.getLocation());
                this.needsRuntimeCheck = true;
            } else {
                String message = "In {" + this.toShortString() + "}: cannot compare " + t0.toString() + " to " + t1.toString();
                XPathException err = new XPathException(message);
                err.setIsTypeError(true);
                err.setErrorCode("XPTY0004");
                err.setLocation(this.getLocation());
                throw err;
            }
        }
        if (this.operator != 50 && this.operator != 51) {
            if (!p0.isOrdered(true)) {
                XPathException err = new XPathException("Type " + t0.toString() + " is not an ordered type");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocation(this.getLocation());
                throw err;
            }
            if (!p1.isOrdered(true)) {
                XPathException err = new XPathException("Type " + t1.toString() + " is not an ordered type");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocation(this.getLocation());
                throw err;
            }
        }
        if (this.comparer == null) {
            String defaultCollationName = env.getDefaultCollationName();
            StringCollator comp = config.getCollation(defaultCollationName);
            if (comp == null) {
                comp = CodepointCollator.getInstance();
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer(p0, p1, comp, env.getConfiguration().getConversionContext());
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        int p1;
        int p0;
        Expression arg;
        Expression e2;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.optimizeChildren(visitor, contextInfo);
        GroundedValue value0 = null;
        GroundedValue value1 = null;
        if (this.getLhsExpression() instanceof Literal) {
            value0 = ((Literal)this.getLhsExpression()).getValue();
        }
        if (this.getRhsExpression() instanceof Literal) {
            value1 = ((Literal)this.getRhsExpression()).getValue();
        }
        if (value0 != null && value1 != null) {
            try {
                BooleanValue r = this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext());
                return Literal.makeLiteral(r == null ? EmptySequence.getInstance() : r, this);
            }
            catch (NoDynamicContextException e) {
                return this;
            }
        }
        if (this.getLhsExpression().isCallOn(Count.class) && Literal.isAtomic(this.getRhsExpression()) ? (e2 = this.optimizeCount(false)) != null : this.getRhsExpression().isCallOn(Count.class) && Literal.isAtomic(this.getLhsExpression()) && (e2 = this.optimizeCount(true)) != null) {
            return e2.optimize(visitor, contextInfo);
        }
        if (this.getLhsExpression().isCallOn(StringLength_1.class) && ValueComparison.isZero(value1)) {
            arg = ((SystemFunctionCall)this.getLhsExpression()).getArg(0);
            switch (this.operator) {
                case 50: 
                case 55: {
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), arg);
                }
                case 51: 
                case 52: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), arg);
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
            }
        }
        if (this.getRhsExpression().isCallOn(StringLength_1.class) && ValueComparison.isZero(value0)) {
            arg = ((SystemFunctionCall)this.getRhsExpression()).getArg(0);
            switch (this.operator) {
                case 50: 
                case 54: {
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), arg);
                }
                case 51: 
                case 53: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), arg);
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
            }
        }
        if (((p0 = this.getLhsExpression().getItemType().getPrimitiveType()) == 513 || p0 == 529 || p0 == 631) && this.resultWhenEmpty != BooleanValue.TRUE && this.getRhsExpression() instanceof Literal && ((Literal)this.getRhsExpression()).getValue() instanceof StringValue && ((StringValue)((Literal)this.getRhsExpression()).getValue()).isZeroLength() && this.comparer instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 52: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getLhsExpression());
                }
                case 50: 
                case 55: {
                    if (this.getLhsExpression().getCardinality() != 16384) break;
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getLhsExpression());
                }
            }
        }
        if (((p1 = this.getRhsExpression().getItemType().getPrimitiveType()) == 513 || p1 == 529 || p1 == 631) && this.resultWhenEmpty != BooleanValue.TRUE && this.getLhsExpression() instanceof Literal && ((Literal)this.getLhsExpression()).getValue() instanceof StringValue && ((StringValue)((Literal)this.getLhsExpression()).getValue()).isZeroLength() && this.comparer instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 53: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getRhsExpression());
                }
                case 50: 
                case 54: {
                    if (this.getRhsExpression().getCardinality() != 16384) break;
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getRhsExpression());
                }
            }
        }
        if (this.getLhsExpression().isCallOn(PositionAndLast.Position.class) && this.getRhsExpression().isCallOn(PositionAndLast.Last.class)) {
            switch (this.operator) {
                case 50: 
                case 54: {
                    IsLastExpression iletrue = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, iletrue);
                    return iletrue;
                }
                case 51: 
                case 53: {
                    IsLastExpression ilefalse = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, ilefalse);
                    return ilefalse;
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
            }
        }
        if (this.getLhsExpression().isCallOn(PositionAndLast.Last.class) && this.getRhsExpression().isCallOn(PositionAndLast.Position.class)) {
            switch (this.operator) {
                case 50: 
                case 55: {
                    IsLastExpression iletrue = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, iletrue);
                    return iletrue;
                }
                case 51: 
                case 52: {
                    IsLastExpression ilefalse = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, ilefalse);
                    return ilefalse;
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
            }
        }
        if (value1 instanceof Int64Value && this.getLhsExpression().getCardinality() == 16384 && th.isSubType(this.getLhsExpression().getItemType(), NumericType.getInstance())) {
            return new CompareToIntegerConstant(this.getLhsExpression(), this.operator, ((Int64Value)value1).longValue());
        }
        if (value0 instanceof Int64Value && this.getRhsExpression().getCardinality() == 16384 && th.isSubType(this.getRhsExpression().getItemType(), NumericType.getInstance())) {
            return new CompareToIntegerConstant(this.getRhsExpression(), Token.inverse(this.operator), ((Int64Value)value0).longValue());
        }
        if (p0 == 514 && p1 == 514 && (this.operator == 50 || this.operator == 51) && this.getLhsExpression().getCardinality() == 16384 && this.getRhsExpression().getCardinality() == 16384 && (this.getLhsExpression() instanceof Literal || this.getRhsExpression() instanceof Literal)) {
            boolean negate;
            Literal literal = (Literal)(this.getLhsExpression() instanceof Literal ? this.getLhsExpression() : this.getRhsExpression());
            Expression other = this.getLhsExpression() instanceof Literal ? this.getRhsExpression() : this.getLhsExpression();
            boolean bl = negate = this.operator == 50 != ((BooleanValue)literal.getValue()).getBooleanValue();
            if (negate) {
                Expression fn = SystemFunction.makeCall("not", this.getRetainedStaticContext(), other);
                ExpressionTool.copyLocationInfo(this, fn);
                return fn.optimize(visitor, contextInfo);
            }
            return other;
        }
        if (this.getLhsExpression().isCallOn(GenerateId_1.class) && this.getRhsExpression().isCallOn(GenerateId_1.class)) {
            SystemFunctionCall f0 = (SystemFunctionCall)this.getLhsExpression();
            SystemFunctionCall f1 = (SystemFunctionCall)this.getRhsExpression();
            if (!Cardinality.allowsMany(f0.getArg(0).getCardinality()) && !Cardinality.allowsMany(f1.getArg(0).getCardinality()) && this.operator == 50) {
                IdentityComparison id = new IdentityComparison(f0.getArg(0), 20, f1.getArg(0));
                id.setGenerateIdEmulation(true);
                ExpressionTool.copyLocationInfo(this, id);
                return id.typeCheck(visitor, contextInfo).optimize(visitor, contextInfo);
            }
        }
        return this;
    }

    private Expression optimizeCount(boolean inverted) throws XPathException {
        int op;
        SystemFunctionCall countFn = (SystemFunctionCall)(inverted ? this.getRhsExpression() : this.getLhsExpression());
        Expression sequence = countFn.getArg(0);
        sequence = sequence.unordered(false, false);
        Optimizer opt = this.getConfiguration().obtainOptimizer();
        AtomicValue literalOperand = (AtomicValue)((Literal)(inverted ? this.getLhsExpression() : this.getRhsExpression())).getValue();
        int n = op = inverted ? Token.inverse(this.operator) : this.operator;
        if (ValueComparison.isZero(literalOperand)) {
            if (op == 50 || op == 55) {
                Expression result = SystemFunction.makeCall("empty", this.getRetainedStaticContext(), sequence);
                opt.trace("Rewrite count()=0 as:", result);
                return result;
            }
            if (op == 51 || op == 52) {
                Expression result = SystemFunction.makeCall("exists", this.getRetainedStaticContext(), sequence);
                opt.trace("Rewrite count()>0 as:", result);
                return result;
            }
            if (op == 54) {
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        if (literalOperand instanceof NumericValue) {
            long operand;
            if (literalOperand instanceof IntegerValue) {
                operand = ((IntegerValue)literalOperand).longValue();
            } else {
                if (literalOperand.isNaN()) {
                    return Literal.makeLiteral(BooleanValue.get(op == 51), this);
                }
                if (((NumericValue)literalOperand).isWholeNumber()) {
                    operand = ((NumericValue)literalOperand).longValue();
                } else {
                    if (op == 50) {
                        return Literal.makeLiteral(BooleanValue.FALSE, this);
                    }
                    if (op == 51) {
                        return Literal.makeLiteral(BooleanValue.TRUE, this);
                    }
                    if (op == 52 || op == 54) {
                        operand = ((NumericValue)literalOperand).ceiling().longValue();
                        op = 54;
                    } else {
                        operand = ((NumericValue)literalOperand).floor().longValue();
                        op = 55;
                    }
                }
            }
            if (operand < 0L) {
                switch (op) {
                    case 50: 
                    case 53: 
                    case 55: {
                        return Literal.makeLiteral(BooleanValue.FALSE, this);
                    }
                }
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            if (operand > Integer.MAX_VALUE) {
                switch (op) {
                    case 50: 
                    case 52: 
                    case 54: {
                        return Literal.makeLiteral(BooleanValue.FALSE, this);
                    }
                }
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            if (sequence instanceof TailExpression || sequence.isCallOn(Subsequence_2.class)) {
                return null;
            }
            switch (op) {
                case 50: 
                case 51: 
                case 53: 
                case 55: {
                    Expression ss = SystemFunction.makeCall("subsequence", this.getRetainedStaticContext(), sequence, Literal.makeLiteral(IntegerValue.PLUS_ONE, this), Literal.makeLiteral(Int64Value.makeIntegerValue(operand + 1L), this));
                    Expression ct = SystemFunction.makeCall("count", this.getRetainedStaticContext(), ss);
                    CompareToIntegerConstant ctic = new CompareToIntegerConstant(ct, op, operand);
                    opt.trace("Rewrite count()~N as:", ctic);
                    ExpressionTool.copyLocationInfo(this, ctic);
                    return ctic;
                }
                case 52: 
                case 54: {
                    TailExpression tail = new TailExpression(sequence, (int)(op == 54 ? operand : operand + 1L));
                    ExpressionTool.copyLocationInfo(this, tail);
                    Expression result = SystemFunction.makeCall("exists", this.getRetainedStaticContext(), tail);
                    ExpressionTool.copyLocationInfo(this, result);
                    opt.trace("Rewrite count()>=N as:", result);
                    return result;
                }
            }
        }
        return null;
    }

    public boolean isNegatable(TypeHierarchy th) {
        return !this.maybeNaN(this.getLhsExpression(), th) && !this.maybeNaN(this.getRhsExpression(), th);
    }

    private boolean maybeNaN(Expression exp, TypeHierarchy th) {
        return th.relationship(exp.getItemType(), BuiltInAtomicType.DOUBLE) != 4 || th.relationship(exp.getItemType(), BuiltInAtomicType.FLOAT) != 4;
    }

    public Expression negate() {
        ValueComparison vc = new ValueComparison(this.getLhsExpression(), Token.negate(this.operator), this.getRhsExpression());
        vc.comparer = this.comparer;
        vc.resultWhenEmpty = this.resultWhenEmpty == null || this.resultWhenEmpty == BooleanValue.FALSE ? BooleanValue.TRUE : BooleanValue.FALSE;
        ExpressionTool.copyLocationInfo(this, vc);
        return vc;
    }

    private static boolean isZero(Sequence v) {
        return v instanceof NumericValue && ((NumericValue)v).compareTo(0L) == 0;
    }

    public boolean equals(Object other) {
        return other instanceof ValueComparison && super.equals(other) && this.comparer.equals(((ValueComparison)other).comparer);
    }

    public Expression copy(RebindingMap rebindings) {
        ValueComparison vc = new ValueComparison(this.getLhsExpression().copy(rebindings), this.operator, this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, vc);
        vc.comparer = this.comparer;
        vc.resultWhenEmpty = this.resultWhenEmpty;
        vc.needsRuntimeCheck = this.needsRuntimeCheck;
        return vc;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        try {
            AtomicValue v0 = (AtomicValue)this.getLhsExpression().evaluateItem(context);
            if (v0 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            AtomicValue v1 = (AtomicValue)this.getRhsExpression().evaluateItem(context);
            if (v1 == null) {
                return this.resultWhenEmpty == BooleanValue.TRUE;
            }
            return ValueComparison.compare(v0, this.operator, v1, this.comparer.provideContext(context), this.needsRuntimeCheck);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    public static boolean compare(AtomicValue v0, int op, AtomicValue v1, AtomicComparer comparer, boolean checkTypes) throws XPathException {
        if (checkTypes && !Type.isGuaranteedComparable(v0.getPrimitiveType(), v1.getPrimitiveType(), Token.isOrderedOperator(op))) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
        if (v0.isNaN() || v1.isNaN()) {
            return op == 51;
        }
        try {
            switch (op) {
                case 50: {
                    return comparer.comparesEqual(v0, v1);
                }
                case 51: {
                    return !comparer.comparesEqual(v0, v1);
                }
                case 52: {
                    return comparer.compareAtomicValues(v0, v1) > 0;
                }
                case 53: {
                    return comparer.compareAtomicValues(v0, v1) < 0;
                }
                case 54: {
                    return comparer.compareAtomicValues(v0, v1) >= 0;
                }
                case 55: {
                    return comparer.compareAtomicValues(v0, v1) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + op);
        }
        catch (ClassCastException err) {
            XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(v0) + " to " + Type.displayTypeName(v1));
            e2.setErrorCode("XPTY0004");
            e2.setIsTypeError(true);
            throw e2;
        }
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        try {
            AtomicValue v0 = (AtomicValue)this.getLhsExpression().evaluateItem(context);
            if (v0 == null) {
                return this.resultWhenEmpty;
            }
            AtomicValue v1 = (AtomicValue)this.getRhsExpression().evaluateItem(context);
            if (v1 == null) {
                return this.resultWhenEmpty;
            }
            return BooleanValue.get(ValueComparison.compare(v0, this.operator, v1, this.comparer.provideContext(context), this.needsRuntimeCheck));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return null;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public UType getStaticUType(UType contextItemType) {
        return UType.BOOLEAN;
    }

    public int computeCardinality() {
        if (this.resultWhenEmpty != null) {
            return 16384;
        }
        return super.computeCardinality();
    }

    public String tag() {
        return "vc";
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        if (this.resultWhenEmpty != null) {
            out.emitAttribute("onEmpty", this.resultWhenEmpty.getBooleanValue() ? "1" : "0");
        }
        out.emitAttribute("comp", this.comparer.save());
    }
}

