/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ListCastableFunction;
import net.sf.saxon.expr.ListConstructorFunction;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UnionCastableFunction;
import net.sf.saxon.expr.UnionConstructorFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.OriginalFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFunctionCall
extends FunctionCall
implements Callable {
    private Function target;

    public StaticFunctionCall(Function target, Expression[] arguments) {
        if (target.getArity() != arguments.length) {
            throw new IllegalArgumentException("Function call to " + target.getFunctionName() + " with wrong number of arguments (" + arguments.length + ")");
        }
        this.target = target;
        this.setOperanda(arguments, target.getOperandRoles());
    }

    public Function getTargetFunction() {
        return this.target;
    }

    @Override
    public Function getTargetFunction(XPathContext context) {
        return this.getTargetFunction();
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.target.getFunctionName();
    }

    @Override
    public boolean isCallOn(Class<? extends SystemFunction> function) {
        return function.isAssignableFrom(this.target.getClass());
    }

    @Override
    public boolean isCallOnSystemFunction(String localName) {
        StructuredQName name = this.target.getFunctionName();
        return name.hasURI("http://www.w3.org/2005/xpath-functions") && localName.equals(name.getLocalPart());
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.checkFunctionCall(this.target, visitor);
        return super.typeCheck(visitor, contextInfo);
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Expression[] args2 = new Expression[this.getArity()];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            args2[i2] = this.getArg(i2).copy(rebindings);
        }
        return new StaticFunctionCall(this.target, args2);
    }

    @Override
    protected int computeCardinality() {
        return this.target.getFunctionItemType().getResultType().getCardinality();
    }

    @Override
    public ItemType getItemType() {
        return this.target.getFunctionItemType().getResultType().getPrimaryType();
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        UType result = this.getItemType().getUType();
        for (Operand o : this.operands()) {
            if (o.getUsage() != OperandUsage.TRANSMISSION) continue;
            result = result.intersection(o.getChildExpression().getStaticUType(contextItemType));
        }
        return result;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.target.call(context, arguments);
    }

    @Override
    public String getExpressionName() {
        return "staticFunctionCall";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        if (this.target instanceof OriginalFunction) {
            OriginalFunction pf = (OriginalFunction)this.target;
            out.startElement("origFC", this);
            out.emitAttribute("name", pf.getFunctionName());
            out.emitAttribute("pack", pf.getContainingPackageName());
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        } else if (this.target instanceof UnionCastableFunction) {
            out.startElement("castable", this);
            out.emitAttribute("emptiable", ((UnionCastableFunction)this.target).isAllowEmpty() ? "1" : "0");
            out.emitAttribute("as", ((UnionCastableFunction)this.target).getTargetType().getStructuredQName());
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        } else if (this.target instanceof ListCastableFunction) {
            out.startElement("castable", this);
            out.emitAttribute("emptiable", ((ListCastableFunction)this.target).isAllowEmpty() ? "1" : "0");
            out.emitAttribute("as", ((ListCastableFunction)this.target).getTargetType().getStructuredQName());
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        } else if (this.target instanceof UnionConstructorFunction) {
            out.startElement("cast", this);
            out.emitAttribute("emptiable", ((UnionConstructorFunction)this.target).isAllowEmpty() ? "1" : "0");
            out.emitAttribute("as", ((UnionConstructorFunction)this.target).getTargetType().getStructuredQName());
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        } else if (this.target instanceof ListConstructorFunction) {
            out.startElement("cast", this);
            out.emitAttribute("emptiable", ((ListConstructorFunction)this.target).isAllowEmpty() ? "1" : "0");
            out.emitAttribute("as", ((ListConstructorFunction)this.target).getTargetType().getStructuredQName());
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        } else {
            super.export(out);
        }
    }
}

