/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class CompareToIntegerConstant
extends UnaryExpression
implements ComparisonExpression {
    private long comparand;
    private int operator;

    public CompareToIntegerConstant(Expression operand, int operator, long comparand) {
        super(operand);
        this.operator = operator;
        this.comparand = comparand;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public Expression getLhsExpression() {
        return this.getBaseExpression();
    }

    public Operand getLhs() {
        return this.getOperand();
    }

    public Expression getRhsExpression() {
        return new Literal(new Int64Value(this.comparand));
    }

    public Operand getRhs() {
        return new Operand(this, this.getRhsExpression(), OperandRole.SINGLE_ATOMIC);
    }

    public long getComparand() {
        return this.comparand;
    }

    public int getComparisonOperator() {
        return this.operator;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public int computeSpecialProperties() {
        return 0x400000;
    }

    public Expression copy(RebindingMap rebindings) {
        CompareToIntegerConstant c2 = new CompareToIntegerConstant(this.getLhsExpression().copy(rebindings), this.operator, this.comparand);
        ExpressionTool.copyLocationInfo(this, c2);
        return c2;
    }

    public boolean equals(Object other) {
        return other instanceof CompareToIntegerConstant && ((CompareToIntegerConstant)other).getLhsExpression().equals(this.getLhsExpression()) && ((CompareToIntegerConstant)other).comparand == this.comparand && ((CompareToIntegerConstant)other).operator == this.operator;
    }

    public int computeHashCode() {
        int h2 = -2090134880;
        return h2 + this.getLhsExpression().computeHashCode() ^ (int)this.comparand;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        NumericValue n = (NumericValue)this.getLhsExpression().evaluateItem(context);
        if (n.isNaN()) {
            return this.operator == 51;
        }
        int c = n.compareTo(this.comparand);
        switch (this.operator) {
            case 50: {
                return c == 0;
            }
            case 51: {
                return c != 0;
            }
            case 52: {
                return c > 0;
            }
            case 53: {
                return c < 0;
            }
            case 54: {
                return c >= 0;
            }
            case 55: {
                return c <= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        if (this.getLhsExpression() instanceof Literal) {
            Literal lit = Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(null)));
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        return this;
    }

    public String getExpressionName() {
        return "compareToInt";
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("compareToInt", this);
        destination.emitAttribute("op", Token.tokens[this.operator]);
        destination.emitAttribute("val", this.comparand + "");
        this.getLhsExpression().export(destination);
        destination.endElement();
    }

    public String toString() {
        return ExpressionTool.parenthesize(this.getLhsExpression()) + " " + Token.tokens[this.operator] + " " + this.comparand;
    }

    public String toShortString() {
        return this.getLhsExpression().toShortString() + " " + Token.tokens[this.operator] + " " + this.comparand;
    }

    public AtomicComparer getAtomicComparer() {
        return DoubleSortComparer.getInstance();
    }

    public int getSingletonOperator() {
        return this.operator;
    }

    public boolean convertsUntypedToOther() {
        return true;
    }
}

