/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Untyped;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMSender {
    private Receiver receiver;
    protected Node root;
    protected String systemId;
    private Stack<List<NamespaceBinding>> namespaces = new Stack();
    private Node currentNode;

    public DOMSender(Node startNode, Receiver receiver) {
        if (startNode == null) {
            throw new NullPointerException("startNode");
        }
        if (receiver == null) {
            throw new NullPointerException("receiver");
        }
        this.root = startNode;
        this.receiver = new NamespaceReducer(receiver);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void send() throws XPathException {
        this.receiver.setSystemId(this.systemId);
        ExplicitLocation loc = ExplicitLocation.UNKNOWN_LOCATION;
        switch (this.root.getNodeType()) {
            case 9: 
            case 11: {
                this.receiver.startDocument(0);
                this.sendUnparsedEntities();
                this.walkNode(this.root);
                this.receiver.endDocument();
                break;
            }
            case 1: {
                this.sendElement((Element)this.root);
                break;
            }
            case 3: 
            case 4: {
                this.receiver.characters(((CharacterData)this.root).getData(), loc, 0);
                break;
            }
            case 8: {
                this.receiver.comment(((Comment)this.root).getData(), loc, 0);
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstruction)this.root).getTarget(), ((ProcessingInstruction)this.root).getData(), loc, 0);
                break;
            }
            default: {
                throw new IllegalStateException("DOMSender: unsupported kind of start node (" + this.root.getNodeType() + ")");
            }
        }
    }

    private void sendUnparsedEntities() throws XPathException {
        NamedNodeMap map;
        DocumentType docType;
        if (this.root instanceof Document && (docType = ((Document)this.root).getDoctype()) != null && (map = docType.getEntities()) != null) {
            for (int i2 = 0; i2 < map.getLength(); ++i2) {
                Entity e = (Entity)map.item(i2);
                if (e.getNotationName() == null) continue;
                String name = e.getNodeName();
                String systemId = e.getSystemId();
                try {
                    String base;
                    URI systemIdURI = new URI(systemId);
                    if (!systemIdURI.isAbsolute() && (base = this.root.getBaseURI()) != null) {
                        systemIdURI = new URI(base).resolve(systemIdURI);
                        systemId = systemIdURI.toString();
                    }
                }
                catch (URISyntaxException systemIdURI) {
                    // empty catch block
                }
                String publicId = e.getPublicId();
                this.receiver.setUnparsedEntity(name, systemId, publicId);
            }
        }
    }

    private void sendElement(Element startNode) throws XPathException {
        Element node = startNode;
        ArrayList<Element> ancestors = new ArrayList<Element>();
        ArrayList<NamespaceBinding> bindings = new ArrayList<NamespaceBinding>();
        for (Node parent = node; parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
            ancestors.add((Element)parent);
        }
        for (int i2 = ancestors.size() - 1; i2 >= 0; --i2) {
            this.gatherNamespaces((Element)ancestors.get(i2), bindings);
        }
        HashMap<String, String> distinctNamespaces = new HashMap<String, String>();
        for (NamespaceBinding namespaceBinding : bindings) {
            distinctNamespaces.put(namespaceBinding.getPrefix(), namespaceBinding.getURI());
        }
        if (distinctNamespaces.size() != bindings.size()) {
            bindings = new ArrayList();
            for (Map.Entry entry : distinctNamespaces.entrySet()) {
                bindings.add(new NamespaceBinding((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        this.namespaces.push(bindings);
        this.outputElement(startNode, true);
        this.namespaces.pop();
    }

    private NodeName getNodeName(String name, boolean useDefaultNS) {
        int colon = name.indexOf(58);
        if (colon < 0) {
            String uri;
            if (useDefaultNS && !(uri = this.getUriForPrefix("")).isEmpty()) {
                return new FingerprintedQName("", uri, name);
            }
            return new NoNamespaceName(name);
        }
        String prefix = name.substring(0, colon);
        String uri = this.getUriForPrefix(prefix);
        if (uri == null) {
            throw new IllegalStateException("Prefix " + prefix + " is not bound to any namespace");
        }
        return new FingerprintedQName(prefix, uri, name.substring(colon + 1));
    }

    private void walkNode(Node node) throws XPathException {
        ExplicitLocation loc = ExplicitLocation.UNKNOWN_LOCATION;
        if (node.hasChildNodes()) {
            NodeList nit = node.getChildNodes();
            int len = nit.getLength();
            block9: for (int i2 = 0; i2 < len; ++i2) {
                Node child;
                this.currentNode = child = nit.item(i2);
                switch (child.getNodeType()) {
                    case 9: 
                    case 11: {
                        continue block9;
                    }
                    case 1: {
                        Element element = (Element)child;
                        ArrayList<NamespaceBinding> bindings = new ArrayList<NamespaceBinding>();
                        this.namespaces.push(bindings);
                        this.gatherNamespaces(element, bindings);
                        this.outputElement(element, bindings.size() > 0);
                        this.namespaces.pop();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 7: {
                        this.receiver.processingInstruction(((ProcessingInstruction)child).getTarget(), ((ProcessingInstruction)child).getData(), loc, 0);
                        continue block9;
                    }
                    case 8: {
                        String text = ((Comment)child).getData();
                        if (text == null) continue block9;
                        this.receiver.comment(text, loc, 0);
                        continue block9;
                    }
                    case 3: 
                    case 4: {
                        String text = ((CharacterData)child).getData();
                        if (text == null) continue block9;
                        this.receiver.characters(text, loc, 0);
                        continue block9;
                    }
                    case 5: {
                        this.walkNode(child);
                        continue block9;
                    }
                }
            }
        }
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    private void outputElement(Element element, boolean hasNamespaceDeclarations) throws XPathException {
        NodeName name = this.getNodeName(element.getTagName(), true);
        ExplicitLocation loc = new ExplicitLocation(this.systemId, -1, -1);
        this.receiver.startElement(name, Untyped.getInstance(), loc, 0);
        for (NamespaceBinding ns : this.namespaces.peek()) {
            this.receiver.namespace(ns, 0);
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            int len = atts.getLength();
            for (int a2 = 0; a2 < len; ++a2) {
                Attr att = (Attr)atts.item(a2);
                int props = att.isId() ? 2048 : 0;
                String attname = att.getName();
                if (hasNamespaceDeclarations && (attname.equals("xmlns") || attname.startsWith("xmlns:"))) continue;
                NodeName attNodeName = this.getNodeName(attname, false);
                this.receiver.attribute(attNodeName, BuiltInAtomicType.UNTYPED_ATOMIC, att.getValue(), loc, props);
            }
        }
        this.receiver.startContent();
        this.walkNode(element);
        this.receiver.endElement();
    }

    private String getUriForPrefix(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i2 = this.namespaces.size() - 1; i2 >= 0; --i2) {
            List localNamespaces = (List)this.namespaces.get(i2);
            for (NamespaceBinding n : localNamespaces) {
                if (!n.getPrefix().equals(prefix)) continue;
                return n.getURI();
            }
        }
        if (prefix.equals("")) {
            return "";
        }
        throw new IllegalStateException("No binding for namespace prefix " + prefix);
    }

    private void gatherNamespaces(Element element, List<NamespaceBinding> list) {
        try {
            String prefix = element.getPrefix();
            String uri = element.getNamespaceURI();
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            if (!prefix.isEmpty() || !uri.isEmpty()) {
                list.add(new NamespaceBinding(prefix, uri));
            }
        }
        catch (Throwable prefix) {
            // empty catch block
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts == null) {
            return;
        }
        int alen = atts.getLength();
        for (int a1 = 0; a1 < alen; ++a1) {
            String uri;
            String prefix;
            Attr att = (Attr)atts.item(a1);
            String attname = att.getName();
            boolean possibleNamespace = attname.startsWith("xmlns");
            if (possibleNamespace && attname.length() == 5) {
                String uri2 = att.getValue();
                list.add(new NamespaceBinding("", uri2));
                continue;
            }
            if (possibleNamespace && attname.startsWith("xmlns:")) {
                prefix = attname.substring(6);
                uri = att.getValue();
                list.add(new NamespaceBinding(prefix, uri));
                continue;
            }
            if (attname.indexOf(58) < 0) continue;
            try {
                prefix = att.getPrefix();
                uri = att.getNamespaceURI();
                list.add(new NamespaceBinding(prefix, uri));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

