/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class HistoryMethodBinding
extends BaseResourceReturningMethodBinding {
    private final Integer myIdParamIndex;
    private final RestOperationTypeEnum myResourceOperationType;
    private final String myResourceName;

    public HistoryMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(HistoryMethodBinding.toReturnType(theMethod, theProvider), theMethod, theContext, theProvider);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex(theMethod, this.getContext());
        History historyAnnotation = theMethod.getAnnotation(History.class);
        Class<? extends IBaseResource> type = historyAnnotation.type();
        if (Modifier.isInterface(type.getModifiers())) {
            if (theProvider instanceof IResourceProvider) {
                type = ((IResourceProvider)theProvider).getResourceType();
                this.myResourceOperationType = this.myIdParamIndex != null ? RestOperationTypeEnum.HISTORY_INSTANCE : RestOperationTypeEnum.HISTORY_TYPE;
            } else {
                this.myResourceOperationType = RestOperationTypeEnum.HISTORY_SYSTEM;
            }
        } else {
            this.myResourceOperationType = this.myIdParamIndex != null ? RestOperationTypeEnum.HISTORY_INSTANCE : RestOperationTypeEnum.HISTORY_TYPE;
        }
        this.myResourceName = type != IBaseResource.class && type != IResource.class ? theContext.getResourceType(type) : null;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.HISTORY;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return this.myResourceOperationType;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    protected boolean isOffsetModeHistory() {
        return true;
    }

    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        boolean wantIdParam;
        if (!"_history".equals(theRequest.getOperation())) {
            return MethodMatchEnum.NONE;
        }
        if (theRequest.getResourceName() == null) {
            if (this.myResourceOperationType == RestOperationTypeEnum.HISTORY_SYSTEM) {
                return MethodMatchEnum.EXACT;
            }
            return MethodMatchEnum.NONE;
        }
        if (!StringUtils.equals((CharSequence)theRequest.getResourceName(), (CharSequence)this.myResourceName)) {
            return MethodMatchEnum.NONE;
        }
        boolean haveIdParam = theRequest.getId() != null && !theRequest.getId().isEmpty();
        boolean bl = wantIdParam = this.myIdParamIndex != null;
        if (haveIdParam != wantIdParam) {
            return MethodMatchEnum.NONE;
        }
        if (theRequest.getId() == null ? this.myResourceOperationType != RestOperationTypeEnum.HISTORY_TYPE : theRequest.getId().hasVersionIdPart()) {
            return MethodMatchEnum.NONE;
        }
        return MethodMatchEnum.EXACT;
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theRequest, theMethodParams);
        final IBundleProvider resources = this.toResourceList(response);
        return new IBundleProvider(){

            @Override
            public String getCurrentPageId() {
                return resources.getCurrentPageId();
            }

            @Override
            public String getNextPageId() {
                return resources.getNextPageId();
            }

            @Override
            public String getPreviousPageId() {
                return resources.getPreviousPageId();
            }

            @Override
            public IPrimitiveType<Date> getPublished() {
                return resources.getPublished();
            }

            @Override
            @Nonnull
            public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
                List<IBaseResource> retVal = resources.getResources(theFromIndex, theToIndex);
                int index = theFromIndex;
                for (IBaseResource nextResource : retVal) {
                    IdDt versionId;
                    if (nextResource.getIdElement() == null || StringUtils.isBlank((CharSequence)nextResource.getIdElement().getIdPart())) {
                        throw new InternalErrorException("Server provided resource at index " + index + " with no ID set (using IResource#setId(IdDt))");
                    }
                    if (StringUtils.isBlank((CharSequence)nextResource.getIdElement().getVersionIdPart()) && nextResource instanceof IResource && ((versionId = ResourceMetadataKeyEnum.VERSION_ID.get((IResource)nextResource)) == null || versionId.isEmpty())) {
                        throw new InternalErrorException("Server provided resource at index " + index + " with no Version ID set (using IResource#setId(IdDt))");
                    }
                    ++index;
                }
                return retVal;
            }

            @Override
            public String getUuid() {
                return resources.getUuid();
            }

            @Override
            public Integer preferredPageSize() {
                return resources.preferredPageSize();
            }

            @Override
            public Integer size() {
                return resources.size();
            }
        };
    }

    private static Class<? extends IBaseResource> toReturnType(Method theMethod, Object theProvider) {
        if (theProvider instanceof IResourceProvider) {
            return ((IResourceProvider)theProvider).getResourceType();
        }
        History historyAnnotation = theMethod.getAnnotation(History.class);
        Class<? extends IBaseResource> type = historyAnnotation.type();
        if (type != IBaseResource.class && type != IResource.class) {
            return type;
        }
        return null;
    }
}

