/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.s13n.standardizers;

import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.TextStandardizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;

public class FirstNameStandardizer
extends TextStandardizer {
    private Set<String> myDelimiters = new HashSet<String>();

    public FirstNameStandardizer() {
        this.initializeDelimiters();
    }

    protected void initializeDelimiters() {
        this.addDelimiters("-", "'");
    }

    protected FirstNameStandardizer addDelimiters(String ... theDelimiters) {
        this.myDelimiters.addAll(Arrays.asList(theDelimiters));
        return this;
    }

    @Override
    public String standardize(String theString) {
        theString = this.replaceTranslates(theString);
        return Arrays.stream(theString.split("\\s+")).map(this::standardizeNameToken).filter(s2 -> !StringUtils.isEmpty((CharSequence)s2)).collect(Collectors.joining(" "));
    }

    protected String capitalize(String theString) {
        if (theString.length() == 0) {
            return theString;
        }
        if (theString.length() == 1) {
            return theString.toUpperCase();
        }
        StringBuilder buf = new StringBuilder(theString.length());
        buf.append(Character.toUpperCase(theString.charAt(0)));
        buf.append(theString.substring(1));
        return buf.toString();
    }

    protected String standardizeNameToken(String theToken) {
        if (theToken.isEmpty()) {
            return theToken;
        }
        boolean isDelimitedToken = false;
        for (String d : this.myDelimiters) {
            if (!theToken.contains(d)) continue;
            isDelimitedToken = true;
            theToken = this.standardizeDelimitedToken(theToken, d);
        }
        if (isDelimitedToken) {
            return theToken;
        }
        theToken = this.removeNoise(theToken);
        theToken = CaseUtils.toCamelCase(theToken, true, new char[0]);
        return theToken;
    }

    protected String standardizeDelimitedToken(String theToken, String d) {
        boolean isTokenTheDelimiter = theToken.equals(d);
        if (isTokenTheDelimiter) {
            return theToken;
        }
        String splitToken = this.checkForRegexp(d);
        String[] splits = theToken.split(splitToken);
        for (int i2 = 0; i2 < splits.length; ++i2) {
            splits[i2] = this.standardizeNameToken(splits[i2]);
        }
        String retVal = this.join(splits, d);
        if (theToken.startsWith(d)) {
            retVal = d.concat(retVal);
        }
        if (theToken.endsWith(d)) {
            retVal = retVal.concat(d);
        }
        return retVal;
    }

    protected String join(String[] theSplits, String theDelimiter) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < theSplits.length; ++i2) {
            String s2 = theSplits[i2];
            if (s2 == null || s2.isEmpty()) continue;
            if (buf.length() != 0) {
                buf.append(theDelimiter);
            }
            buf.append(s2);
        }
        return buf.toString();
    }

    protected String checkForRegexp(String theExpression) {
        if (theExpression.equals(".") || theExpression.equals("|") || theExpression.equals("(") || theExpression.equals(")")) {
            return "\\".concat(theExpression);
        }
        return theExpression;
    }

    protected boolean isDelimiter(String theString) {
        return this.myDelimiters.contains(theString);
    }
}

