/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.MetaUtil;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class CaptureResourceSourceFromHeaderInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(CaptureResourceSourceFromHeaderInterceptor.class);
    private final FhirContext myFhirContext;
    private String myHeaderName;

    public CaptureResourceSourceFromHeaderInterceptor(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
        this.setHeaderName("X-Request-Source");
    }

    public String getHeaderName() {
        return this.myHeaderName;
    }

    public void setHeaderName(String theHeaderName) {
        this.myHeaderName = theHeaderName;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void extractSource(RequestDetails theRequestDetails) {
        String requestSource;
        IBaseResource resource = theRequestDetails.getResource();
        if (resource != null && StringUtils.isNotBlank((CharSequence)(requestSource = theRequestDetails.getHeader(this.getHeaderName())))) {
            ourLog.trace("Setting Meta.source to \"{}\" because of header \"{}\"", (Object)requestSource, (Object)this.getHeaderName());
            MetaUtil.setSource(this.myFhirContext, resource, requestSource);
        }
    }
}

