/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.context.ConfigurationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public interface IBundleProvider {
    default public String getCurrentPageId() {
        return null;
    }

    default public String getNextPageId() {
        return null;
    }

    default public String getPreviousPageId() {
        return null;
    }

    public IPrimitiveType<Date> getPublished();

    @Nonnull
    public List<IBaseResource> getResources(int var1, int var2);

    @Nonnull
    default public List<IBaseResource> getAllResources() {
        ArrayList<IBaseResource> retval = new ArrayList<IBaseResource>();
        Integer size = this.size();
        if (size == null) {
            throw new ConfigurationException("Attempt to request all resources from an asynchronous search result.  The SearchParameterMap for this search probably should have been synchronous.");
        }
        if (size > 0) {
            retval.addAll(this.getResources(0, size));
        }
        return retval;
    }

    @Nullable
    public String getUuid();

    public Integer preferredPageSize();

    @Nullable
    public Integer size();

    default public boolean isEmpty() {
        Integer size = this.size();
        if (size != null) {
            return size == 0;
        }
        return this.getResources(0, 1).isEmpty();
    }

    default public int sizeOrThrowNpe() {
        Integer retVal = this.size();
        Validate.notNull((Object)retVal, (String)"size() returned null", (Object[])new Object[0]);
        return retVal;
    }
}

