/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.application.listeners;

import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.UiDesk;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=info/elexis/notification/*"})
public class OsgiMessageEventListener
implements EventHandler {
    public void handleEvent(Event event) {
        final String topic = event.getTopic().substring("info/elexis/notification/".length());
        final String title = (String)event.getProperty("title");
        final String message = (String)event.getProperty("message");
        final ElexisStatus status = (ElexisStatus)event.getProperty("status");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                switch (topic) {
                    case "error": {
                        MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)title, (String)message);
                        break;
                    }
                    case "warn": {
                        MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)title, (String)message);
                        break;
                    }
                    case "info": {
                        MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)title, (String)message);
                        break;
                    }
                    case "status": {
                        LoggerFactory.getLogger(this.getClass()).info("StatusEvent [PLUGIN] " + status.getPlugin() + " [MESSAGE] " + status.getMessage() + " [EXCEPTION] " + status.getException());
                        StatusManager.getManager().handle((IStatus)status);
                        break;
                    }
                    default: {
                        LoggerFactory.getLogger(this.getClass()).error("invalid topic [" + topic + "] for message: " + title + "/" + message);
                    }
                }
            }
        });
    }
}

