/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts;

import ch.elexis.core.services.IQuery;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.ModelPackage;
import ch.elexis.core.ui.e4.parts.IRefreshablePart;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.tasks.internal.TaskModelServiceHolder;
import ch.elexis.core.ui.tasks.parts.controls.AbstractTaskDescriptorConfigurationComposite;
import ch.elexis.core.ui.tasks.parts.controls.GeneralConfigurationComposite;
import ch.elexis.core.ui.tasks.parts.controls.RunnableAndContextConfigurationComposite;
import ch.elexis.core.ui.tasks.parts.controls.TaskTriggerTypeConfigurationComposite;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TaskConfigurationPart
implements IRefreshablePart {
    @Inject
    private ITaskService taskService;
    @Inject
    private ESelectionService selectionService;
    private Table tableDescriptors;
    private GeneralConfigurationComposite gcp;
    private TaskTriggerTypeConfigurationComposite tttcp;
    private RunnableAndContextConfigurationComposite raccp;
    private TableViewer tvTaskDescriptors;
    private TaskLogComparator comparator;

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        GridData gd_composite = new GridData(4, 4, true, false, 1, 1);
        gd_composite.heightHint = 300;
        composite.setLayoutData((Object)gd_composite);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tvTaskDescriptors = new TableViewer(composite, 67584);
        this.tableDescriptors = this.tvTaskDescriptors.getTable();
        this.tableDescriptors.setHeaderVisible(true);
        this.tableDescriptors.setLinesVisible(true);
        this.tvTaskDescriptors.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tvTaskDescriptors.addSelectionChangedListener(sel -> this.selectionChanged((ITaskDescriptor)sel.getStructuredSelection().getFirstElement()));
        this.comparator = new TaskLogComparator();
        this.tvTaskDescriptors.setComparator((ViewerComparator)this.comparator);
        TableViewerColumn tvcStatus = new TableViewerColumn(this.tvTaskDescriptors, 0);
        TableColumn tblclmnStatus = tvcStatus.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnStatus, (ColumnLayoutData)new ColumnPixelData(16, false, true));
        tblclmnStatus.setText("status");
        tblclmnStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationPart.this.comparator.setColumn(1);
                TaskConfigurationPart.this.refresh();
            }
        });
        tvcStatus.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITaskDescriptor td = (ITaskDescriptor)element;
                if (td.getTransientData().get("incurred") != null) {
                    return "INC";
                }
                return td.isActive() ? "ACT" : "NACT";
            }
        });
        TableViewerColumn tvcReferenceId = new TableViewerColumn(this.tvTaskDescriptors, 0);
        TableColumn tblclmnReferenceId = tvcReferenceId.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnReferenceId, (ColumnLayoutData)new ColumnPixelData(150, true, true));
        tblclmnReferenceId.setText("referenceId");
        tblclmnReferenceId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationPart.this.comparator.setColumn(1);
                TaskConfigurationPart.this.refresh();
            }
        });
        tvcReferenceId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITaskDescriptor td = (ITaskDescriptor)element;
                return td.getReferenceId();
            }
        });
        TableViewerColumn tvcRunnableId = new TableViewerColumn(this.tvTaskDescriptors, 0);
        TableColumn tblclmnRunnableId = tvcRunnableId.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnRunnableId, (ColumnLayoutData)new ColumnPixelData(150, true, true));
        tblclmnRunnableId.setText("runnableId");
        tblclmnRunnableId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationPart.this.comparator.setColumn(2);
                TaskConfigurationPart.this.refresh();
            }
        });
        tvcRunnableId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITaskDescriptor td = (ITaskDescriptor)element;
                return td.getIdentifiedRunnableId();
            }
        });
        TableViewerColumn tvcOwner = new TableViewerColumn(this.tvTaskDescriptors, 0);
        TableColumn tblclmnOwner = tvcOwner.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnOwner, (ColumnLayoutData)new ColumnPixelData(150, true, true));
        tblclmnOwner.setText("Owner");
        tblclmnOwner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationPart.this.comparator.setColumn(3);
                TaskConfigurationPart.this.refresh();
            }
        });
        tvcOwner.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITaskDescriptor td = (ITaskDescriptor)element;
                String ownerId = td.getOwner() != null ? td.getOwner().getId() : "NO-OWNER";
                return String.valueOf(ownerId) + "@" + td.getRunner();
            }

            public Color getForeground(Object element) {
                ITaskDescriptor td = (ITaskDescriptor)element;
                return td.getOwner() == null ? Display.getCurrent().getSystemColor(3) : null;
            }
        });
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tabFolder.addListener(13, event -> {
            Control control = ((TabItem)event.item).getControl();
            if (control instanceof AbstractTaskDescriptorConfigurationComposite) {
                ((AbstractTaskDescriptorConfigurationComposite)control).refresh();
            }
        });
        TabItem tbtmGeneral = new TabItem(tabFolder, 0);
        tbtmGeneral.setText("general");
        this.gcp = new GeneralConfigurationComposite(this.taskService, (Composite)tabFolder, 0);
        tbtmGeneral.setControl((Control)this.gcp);
        TabItem tbtmTrigger = new TabItem(tabFolder, 0);
        tbtmTrigger.setText("trigger");
        this.tttcp = new TaskTriggerTypeConfigurationComposite((Composite)tabFolder, 0);
        tbtmTrigger.setControl((Control)this.tttcp);
        TabItem tbtmAction = new TabItem(tabFolder, 0);
        tbtmAction.setText("action");
        this.raccp = new RunnableAndContextConfigurationComposite((Composite)tabFolder, 0, this.taskService);
        tbtmAction.setControl((Control)this.raccp);
        menuService.registerContextMenu((Object)this.tableDescriptors, "ch.elexis.core.ui.tasks.popupmenu.tabledescriptors");
        this.refresh();
    }

    private void selectionChanged(ITaskDescriptor taskDescriptor) {
        this.selectionService.setSelection((Object)taskDescriptor);
        this.gcp.setSelection(taskDescriptor);
        this.tttcp.setSelection(taskDescriptor);
        this.raccp.setSelection(taskDescriptor);
    }

    @Focus
    public boolean setFocus() {
        return this.tableDescriptors.setFocus();
    }

    @Optional
    @Inject
    void refreshTaskDescriptor(@UIEventTopic(value="info/elexis/model/update") ITaskDescriptor taskDescriptor) {
        if (taskDescriptor != null) {
            this.tvTaskDescriptors.update((Object)taskDescriptor, null);
        }
    }

    public void refresh(Map<Object, Object> filterParameters) {
        boolean showSystemTasks;
        IQuery taskQuery = TaskModelServiceHolder.get().getQuery(ITaskDescriptor.class, true, false);
        boolean bl = showSystemTasks = filterParameters.get("sst") != null ? (Boolean)filterParameters.get("sst") : false;
        if (!showSystemTasks) {
            taskQuery.and((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)false);
        }
        List taskDescriptors = taskQuery.execute();
        Set incurredTaskIds = this.taskService.getIncurredTasks().stream().map(ict -> ict.getId()).collect(Collectors.toSet());
        taskDescriptors.forEach(td -> {
            if (incurredTaskIds.contains(td.getId())) {
                td.getTransientData().put("incurred", Boolean.TRUE.toString());
            }
        });
        this.tvTaskDescriptors.setInput((Object)taskDescriptors);
        this.tvTaskDescriptors.refresh(true);
    }

    @Optional
    @Inject
    void deleteTaskDescriptor(@UIEventTopic(value="info/elexis/model/delete") ITaskDescriptor taskDescriptor) {
        this.refresh();
    }

    @Optional
    @Inject
    void createTaskDescriptor(@UIEventTopic(value="info/elexis/model/create") ITaskDescriptor taskDescriptor) {
        this.refresh();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    public class TaskLogComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction *= -1;
            }
            this.propertyIndex = column;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            ITaskDescriptor ts1 = (ITaskDescriptor)o1;
            ITaskDescriptor ts2 = (ITaskDescriptor)o2;
            switch (this.propertyIndex) {
                case 0: {
                    boolean status1 = ts1.isActive();
                    boolean status2 = ts2.isActive();
                    return Objects.compare(status1, status2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 1: {
                    String ref1 = ts1.getReferenceId();
                    String ref2 = ts2.getReferenceId();
                    return Objects.compare(ref1, ref2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 2: {
                    String run1 = ts1.getIdentifiedRunnableId() != null ? ts1.getIdentifiedRunnableId() : "";
                    String run2 = ts2.getIdentifiedRunnableId() != null ? ts2.getIdentifiedRunnableId() : "";
                    return Objects.compare(run1, run2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 3: {
                    String own1 = ts1.getOwner() != null ? ts1.getOwner().getLabel() : "";
                    String own2 = ts2.getOwner() != null ? ts2.getOwner().getLabel() : "";
                    return Objects.compare(own1, own2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
            }
            return super.compare(viewer, o1, o2);
        }
    }
}

