/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter.event;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(service={EventHandler.class, EntityChangeEventListener.class}, property={"event.topics=info/elexis/jpa/entity/changed"})
public class EntityChangeEventListener
implements EventHandler {
    private WeakHashMap<EntityWithId, List<WeakReference<AbstractIdModelAdapter<?>>>> listenerMap = new WeakHashMap();
    private int addCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractIdModelAdapter<?> adapter) {
        WeakHashMap<EntityWithId, List<WeakReference<AbstractIdModelAdapter<?>>>> weakHashMap = this.listenerMap;
        synchronized (weakHashMap) {
            Object entity = adapter.getEntity();
            List<WeakReference<AbstractIdModelAdapter<?>>> listeners = this.getListenersFor((EntityWithId)entity);
            listeners.add(new WeakReference(adapter));
            this.listenerMap.put((EntityWithId)entity, listeners);
            if (this.addCount++ > 25000) {
                if (this.listenerMap.size() > 25000) {
                    this.cleanup();
                }
                this.addCount = 0;
            }
        }
    }

    private void cleanup() {
        Iterator<EntityWithId> entitiesIter = this.listenerMap.keySet().iterator();
        while (entitiesIter.hasNext()) {
            EntityWithId entity = entitiesIter.next();
            List<WeakReference<AbstractIdModelAdapter<?>>> listeners = this.listenerMap.get(entity);
            Iterator<WeakReference<AbstractIdModelAdapter<?>>> iter = listeners.iterator();
            while (iter.hasNext()) {
                AbstractIdModelAdapter adapter;
                WeakReference<AbstractIdModelAdapter<?>> reference = iter.next();
                if (reference == null || (adapter = (AbstractIdModelAdapter)reference.get()) != null) continue;
                iter.remove();
            }
            if (!listeners.isEmpty()) continue;
            entitiesIter.remove();
        }
    }

    private List<WeakReference<AbstractIdModelAdapter<?>>> getListenersFor(EntityWithId entity) {
        List<WeakReference<AbstractIdModelAdapter<?>>> listeners = this.listenerMap.get(entity);
        if (listeners == null) {
            listeners = new ArrayList();
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        EntityWithId entity = (EntityWithId)event.getProperty(EntityWithId.class.getName());
        WeakHashMap<EntityWithId, List<WeakReference<AbstractIdModelAdapter<?>>>> weakHashMap = this.listenerMap;
        synchronized (weakHashMap) {
            List<WeakReference<AbstractIdModelAdapter<?>>> listeners = this.getListenersFor(entity);
            this.listenerMap.put(entity, listeners);
            Iterator<WeakReference<AbstractIdModelAdapter<?>>> iter = listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<AbstractIdModelAdapter<?>> reference = iter.next();
                if (reference == null) continue;
                AbstractIdModelAdapter adapter = (AbstractIdModelAdapter)reference.get();
                if (adapter != null) {
                    adapter.setEntity(entity, false);
                    continue;
                }
                iter.remove();
            }
        }
    }
}

