/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.exceptions.AccessControlException;
import ch.elexis.core.jpa.entities.DBLog;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractModelAdapterFactory;
import ch.elexis.core.jpa.model.adapter.EmptyNamedQuery;
import ch.elexis.core.jpa.model.adapter.NamedQuery;
import ch.elexis.core.jpa.model.adapter.NativeQuery;
import ch.elexis.core.jpa.model.service.holder.ContextServiceHolder;
import ch.elexis.core.jpa.model.service.holder.StoreToStringServiceHolder;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.INativeQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.net.NetTool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelService
implements IModelService {
    private IAccessControlService accessControlService;
    protected AbstractModelAdapterFactory adapterFactory;
    protected ExecutorService executor = Executors.newCachedThreadPool();

    protected abstract EntityManager getEntityManager(boolean var1);

    protected abstract void closeEntityManager(EntityManager var1);

    protected abstract EventAdmin getEventAdmin();

    public <T> Optional<T> load(String id, Class<T> clazz, boolean includeDeleted, boolean refreshCache) {
        if (this.evaluateRightNoException(clazz, Right.READ) && StringUtils.isNotEmpty((CharSequence)id)) {
            EntityWithId dbObject;
            EntityManager em = this.getEntityManager(true);
            Class<? extends EntityWithId> dbObjectClass = this.adapterFactory.getEntityClass(clazz);
            HashMap<String, String> queryHints = new HashMap<String, String>();
            if (refreshCache) {
                queryHints.put("eclipselink.refresh", "True");
            }
            if ((dbObject = (EntityWithId)em.find(dbObjectClass, (Object)id, queryHints)) != null) {
                if (!includeDeleted && dbObject instanceof EntityWithDeleted && ((EntityWithDeleted)dbObject).isDeleted()) {
                    return Optional.empty();
                }
                Optional<Identifiable> modelObject = this.adapterFactory.getModelAdapter(dbObject, clazz, true);
                if (modelObject.isPresent() && clazz.isAssignableFrom(modelObject.get().getClass()) && this.evaluateRightNoException(Collections.singletonList(modelObject.get()), Right.READ)) {
                    return modelObject;
                }
            }
        }
        return Optional.empty();
    }

    public <T> List<T> findAll(Class<T> clazz) {
        IQuery query = this.getQuery(clazz);
        return query.execute();
    }

    public <T> List<T> findAllById(Collection<String> ids, Class<T> clazz) {
        IQuery query = this.getQuery(clazz);
        if (ids != null && !ids.isEmpty()) {
            query.and("id", IQuery.COMPARATOR.IN, ids);
            return query.execute();
        }
        return Collections.emptyList();
    }

    public <T> Optional<T> adapt(Object jpaEntity, Class<T> clazz) {
        if (jpaEntity instanceof EntityWithId) {
            return this.adapterFactory.getModelAdapter((EntityWithId)jpaEntity, clazz, false);
        }
        return Optional.empty();
    }

    public Class<?> getEntityClass(Class<?> clazz) {
        return this.adapterFactory.getEntityClass(clazz);
    }

    public void refresh(Identifiable identifiable, boolean refreshCache) {
        EntityManager em = this.getEntityManager(true);
        EntityWithId dbObject = this.getDbObject(identifiable).orElse(null);
        if (dbObject != null) {
            EntityWithId reloadedDbObject;
            HashMap<String, String> queryHints = new HashMap<String, String>();
            if (refreshCache) {
                queryHints.put("eclipselink.refresh", "True");
            }
            if ((reloadedDbObject = (EntityWithId)em.find(dbObject.getClass(), (Object)dbObject.getId(), queryHints)) != null) {
                this.setDbObject(identifiable, reloadedDbObject, false);
            }
        }
    }

    public Object getEntityProperty(String propertyName, Identifiable identifiable) {
        EntityWithId dbObject = this.getDbObject(identifiable).orElse(null);
        if (dbObject != null) {
            try {
                return BeanUtils.getProperty((Object)dbObject, (String)propertyName);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not get property [" + propertyName + "] of entity [" + dbObject + "]", (Throwable)e);
            }
        }
        return null;
    }

    public void setEntityProperty(String propertyName, Object value, Identifiable identifiable) {
        EntityWithId dbObject = this.getDbObject(identifiable).orElse(null);
        if (dbObject != null) {
            try {
                BeanUtils.setProperty((Object)dbObject, (String)propertyName, (Object)value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not set property [" + propertyName + "] of entity [" + dbObject + "]", (Throwable)e);
            }
        }
    }

    public void addToEntityList(String getterName, Identifiable value, Identifiable identifiable) {
        EntityWithId dbValueObject;
        EntityWithId dbObject = this.getDbObject(identifiable).orElse(null);
        if (dbObject != null && (dbValueObject = (EntityWithId)this.getDbObject(value).orElse(null)) != null) {
            try {
                Method getterMethod = dbObject.getClass().getMethod(getterName, null);
                Object list = getterMethod.invoke((Object)dbObject, null);
                if (list instanceof List) {
                    ((List)list).add(dbValueObject);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not add to entity list [" + getterName + "] of entity [" + dbObject + "]", (Throwable)e);
            }
        }
    }

    public void save(Identifiable identifiable) {
        if (identifiable != null && this.evaluateRight(identifiable.getClass(), Right.UPDATE)) {
            if (identifiable.getChanged() != null) {
                this.save(Collections.singletonList(identifiable));
                return;
            }
            Optional<EntityWithId> dbObject = this.getDbObject(identifiable);
            if (dbObject.isPresent()) {
                boolean newlyCreatedObject = dbObject.get().getLastupdate() == null;
                EntityManager em = this.getEntityManager(false);
                try {
                    em.getTransaction().begin();
                    EntityWithId merged = (EntityWithId)em.merge((Object)dbObject.get());
                    em.getTransaction().commit();
                    if (identifiable instanceof AbstractIdModelAdapter) {
                        this.setDbObject(identifiable, merged, true);
                    }
                    if (identifiable.getRefresh() != null) {
                        for (Identifiable toRefresh : identifiable.getRefresh()) {
                            this.refresh(toRefresh, true);
                        }
                        identifiable.clearRefresh();
                    }
                    if (identifiable.getUpdated() != null) {
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)identifiable, Collections.singletonMap("updated", identifiable.getUpdated()));
                        identifiable.clearUpdated();
                    }
                    if (newlyCreatedObject) {
                        ElexisEvent createEvent = this.getCreateEvent(identifiable);
                        if (createEvent != null) {
                            String userId;
                            if (ContextServiceHolder.isPresent() && (userId = (String)ContextServiceHolder.get().getActiveUser().map(Identifiable::getId).orElse(null)) != null) {
                                createEvent.getProperties().put("user", userId);
                            }
                            this.postElexisEvent(createEvent);
                        }
                        this.postEvent("info/elexis/model/create", identifiable);
                    }
                    return;
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            String message = "Could not save [" + identifiable + "]";
            LoggerFactory.getLogger(this.getClass()).error(message);
            throw new IllegalStateException(message);
        }
    }

    public void save(List<? extends Identifiable> identifiables) {
        if (this.evaluateRight(identifiables, Right.UPDATE)) {
            if (identifiables == null || identifiables.isEmpty()) {
                return;
            }
            identifiables = this.addChanged(identifiables);
            HashMap<Identifiable, EntityWithId> dbObjects = new HashMap<Identifiable, EntityWithId>();
            for (Identifiable identifiable : identifiables) {
                dbObjects.put(identifiable, this.getDbObject(identifiable).orElse(null));
            }
            if (!dbObjects.isEmpty()) {
                EntityManager entityManager = this.getEntityManager(false);
                try {
                    ArrayList<ElexisEvent> createdEvents = new ArrayList<ElexisEvent>();
                    ArrayList<Identifiable> createdIdentifiables = new ArrayList<Identifiable>();
                    HashMap<Identifiable, EntityWithId> mergedEntities = new HashMap<Identifiable, EntityWithId>();
                    entityManager.getTransaction().begin();
                    for (Identifiable identifiable : identifiables) {
                        EntityWithId dbObject = (EntityWithId)dbObjects.get(identifiable);
                        if (dbObject == null) continue;
                        boolean newlyCreatedObject = dbObject.getLastupdate() == null;
                        EntityWithId merged = (EntityWithId)entityManager.merge((Object)dbObject);
                        mergedEntities.put(identifiable, merged);
                        if (!newlyCreatedObject) continue;
                        ElexisEvent createEvent = this.getCreateEvent(identifiable);
                        if (createEvent != null) {
                            String userId;
                            if (ContextServiceHolder.isPresent() && (userId = (String)ContextServiceHolder.get().getActiveUser().map(Identifiable::getId).orElse(null)) != null) {
                                createEvent.getProperties().put("user", userId);
                            }
                            createdEvents.add(createEvent);
                        }
                        createdIdentifiables.add(identifiable);
                    }
                    entityManager.getTransaction().commit();
                    identifiables.stream().forEach(i -> {
                        if (i instanceof AbstractIdModelAdapter) {
                            this.setDbObject(i, (EntityWithId)mergedEntities.get(i), true);
                            if (i.getRefresh() != null) {
                                for (Identifiable toRefresh : i.getRefresh()) {
                                    this.refresh(toRefresh, true);
                                }
                                i.clearRefresh();
                            }
                            if (i.getUpdated() != null) {
                                ContextServiceHolder.get().postEvent("info/elexis/model/update", i, Collections.singletonMap("updated", i.getUpdated()));
                                i.clearUpdated();
                            }
                        }
                    });
                    createdEvents.stream().forEach(e -> this.postElexisEvent((ElexisEvent)e));
                    createdIdentifiables.stream().forEach(i -> this.postEvent("info/elexis/model/create", i));
                    return;
                }
                finally {
                    this.closeEntityManager(entityManager);
                }
            }
            String string = "Could not save list [" + identifiables + "]";
            LoggerFactory.getLogger(this.getClass()).error(string);
            throw new IllegalStateException(string);
        }
    }

    public void touch(Identifiable identifiable) {
        Optional<EntityWithId> dbObject;
        if (this.evaluateRight(identifiable.getClass(), Right.UPDATE) && (dbObject = this.getDbObject(identifiable)).isPresent()) {
            EntityManager em = this.getEntityManager(false);
            try {
                em.getTransaction().begin();
                dbObject.get().setLastupdate(Long.valueOf(System.currentTimeMillis()));
                em.merge((Object)dbObject.get());
                em.getTransaction().commit();
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    protected List<? extends Identifiable> addChanged(List<? extends Identifiable> identifiables) {
        ArrayList<? extends Identifiable> ret = new ArrayList<Identifiable>();
        ret.addAll(identifiables);
        identifiables.forEach(i -> {
            if (i.getChanged() != null) {
                for (Identifiable changed : i.getChanged()) {
                    if (ret.contains(changed)) continue;
                    ret.add(changed);
                }
                i.clearChanged();
            }
        });
        return ret;
    }

    public void remove(Identifiable identifiable) {
        Optional<EntityWithId> dbObject;
        if (this.evaluateRight(identifiable.getClass(), Right.REMOVE) && (dbObject = this.getDbObject(identifiable)).isPresent()) {
            EntityManager em = this.getEntityManager(false);
            try {
                em.getTransaction().begin();
                EntityWithId object = (EntityWithId)em.merge((Object)dbObject.get());
                em.remove((Object)object);
                em.getTransaction().commit();
                this.postEvent("info/elexis/model/delete", identifiable);
                return;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        String message = "Could not remove [" + identifiable + "]";
        LoggerFactory.getLogger(this.getClass()).error(message);
        throw new IllegalStateException(message);
    }

    public void remove(List<? extends Identifiable> identifiables) {
        if (identifiables != null) {
            ArrayList<Identifiable> listOfRemoved = new ArrayList<Identifiable>();
            EntityManager em = this.getEntityManager(false);
            try {
                em.getTransaction().begin();
                for (Identifiable identifiable : identifiables) {
                    Optional<EntityWithId> dbObject = this.getDbObject(identifiable);
                    if (!dbObject.isPresent()) continue;
                    em.remove(em.merge((Object)dbObject.get()));
                    listOfRemoved.add(identifiable);
                }
                em.getTransaction().commit();
                for (Identifiable identifiable : listOfRemoved) {
                    this.postEvent("info/elexis/model/delete", identifiable);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    protected abstract ElexisEvent getCreateEvent(Identifiable var1);

    protected Optional<EntityWithId> getDbObject(Object adapter) {
        if (adapter instanceof AbstractIdModelAdapter) {
            return Optional.ofNullable(((AbstractIdModelAdapter)adapter).getEntity());
        }
        return Optional.empty();
    }

    protected void setDbObject(Object adapter, EntityWithId entity, boolean resetDirty) {
        if (adapter instanceof AbstractIdModelAdapter) {
            ((AbstractIdModelAdapter)adapter).setEntity(entity, resetDirty);
            this.sendEntityChangeEvent(entity);
        }
    }

    private void sendEntityChangeEvent(EntityWithId entity) {
        if (this.getEventAdmin() == null) {
            throw new IllegalStateException("No EventAdmin available");
        }
        HashMap<String, EntityWithId> properites = new HashMap<String, EntityWithId>();
        properites.put(EntityWithId.class.getName(), entity);
        Event event = new Event("info/elexis/jpa/entity/changed", properites);
        this.getEventAdmin().sendEvent(event);
    }

    public void delete(Deleteable deletable) {
        if (this.evaluateRight(deletable.getClass(), Right.DELETE)) {
            deletable.setDeleted(true);
            this.save((Identifiable)deletable);
            this.createDBLog((Identifiable)deletable);
            this.postEvent("info/elexis/model/delete", deletable);
        }
    }

    public void delete(List<? extends Deleteable> deletables) {
        if (deletables != null && this.evaluateRight(deletables.stream().map(d -> (Identifiable)d).collect(Collectors.toList()), Right.DELETE)) {
            ArrayList identifiables = new ArrayList();
            deletables.forEach(item -> {
                item.setDeleted(true);
                identifiables.add((Identifiable)item);
            });
            this.save(identifiables);
            identifiables.forEach(item -> {
                this.createDBLog((Identifiable)item);
                this.postEvent("info/elexis/model/delete", item);
            });
        }
    }

    private void createDBLog(Identifiable identifiable) {
        DBLog dbLog = new DBLog();
        dbLog.setUserId(ContextServiceHolder.getActiveUserContact().map(Identifiable::getId).orElse("?"));
        dbLog.setOid(StoreToStringServiceHolder.getStoreToString(identifiable).orElse(identifiable.getId()));
        dbLog.setTyp(DBLog.Type.DELETE);
        dbLog.setDatum(LocalDate.now());
        dbLog.setStation(Optional.ofNullable(NetTool.hostname).orElse("?"));
        EntityManager em = this.getEntityManager(true);
        if (!em.getTransaction().isActive()) {
            em.getTransaction().begin();
            em.merge((Object)dbLog);
            em.getTransaction().commit();
        } else {
            em.merge((Object)dbLog);
        }
    }

    public void postEvent(String topic, Object object) {
        if (this.getEventAdmin() == null) {
            throw new IllegalStateException("No EventAdmin available");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("org.eclipse.e4.data", object);
        Event event = new Event(topic, properties);
        this.getEventAdmin().postEvent(event);
    }

    public void postElexisEvent(ElexisEvent elexisEvent) {
        if (elexisEvent == null || elexisEvent.getTopic() == null) {
            return;
        }
        String topic = elexisEvent.getTopic();
        if (!topic.startsWith("info/elexis/")) {
            topic = "info/elexis/" + topic;
        }
        Event event = new Event(topic, elexisEvent.getProperties());
        if (this.getEventAdmin() == null) {
            throw new IllegalStateException("No EventAdmin available");
        }
        this.getEventAdmin().sendEvent(event);
    }

    public <T> T create(Class<T> clazz) {
        if (this.evaluateRight(clazz, Right.CREATE)) {
            return this.adapterFactory.createAdapter(clazz);
        }
        return null;
    }

    private IAccessControlService getAccessControlService() {
        if (this.accessControlService == null) {
            this.accessControlService = OsgiServiceUtil.getService(IAccessControlService.class).orElse(null);
        }
        return this.accessControlService;
    }

    protected boolean evaluateRightNoException(Class<?> clazz, Right right) {
        boolean ret = CoreUtil.isTestMode();
        if (this.getAccessControlService() != null && !(ret = this.getAccessControlService().evaluate((EvaluatableACE)EvACE.of(clazz, (Right)right)))) {
            LoggerFactory.getLogger(this.getClass()).info("User has no right [" + right + "] for class [" + clazz.getName() + "]");
        }
        return ret;
    }

    protected boolean evaluateRight(Class<?> clazz, Right right) throws AccessControlException {
        boolean ret = this.evaluateRightNoException(clazz, right);
        if (!ret) {
            throw new AccessControlException(clazz, right);
        }
        return ret;
    }

    protected boolean evaluateRightNoException(List<? extends Identifiable> identifiables, Right right) {
        boolean ret = true;
        if (identifiables != null && !identifiables.isEmpty()) {
            if (!this.evaluateRightNoException(identifiables.get(0).getClass(), right)) {
                return false;
            }
            if (this.getAccessControlService() != null) {
                for (Identifiable identifiable : identifiables) {
                    String storeToString = StoreToStringServiceHolder.getStoreToString(identifiable).orElse(null);
                    if (storeToString == null) continue;
                    ObjectEvaluatableACE objAce = (ObjectEvaluatableACE)EvACE.of(identifiable.getClass(), (Right)right, (String)storeToString);
                    if (this.getAccessControlService().evaluate((EvaluatableACE)objAce)) continue;
                    return false;
                }
            }
        }
        return ret;
    }

    protected boolean evaluateRight(List<? extends Identifiable> identifiables, Right right) throws AccessControlException {
        boolean ret = this.evaluateRightNoException(identifiables, right);
        if (!ret && identifiables != null && !identifiables.isEmpty()) {
            throw new AccessControlException(identifiables.get(0).getClass(), right);
        }
        return ret;
    }

    public Stream<?> executeNativeQuery(String sql) {
        Query query = this.getEntityManager(true).createNativeQuery(sql);
        return query.getResultStream();
    }

    public <T> Stream<T> executeNativeQuery(String sql, Class<T> interfaceClazz) {
        Class<? extends EntityWithId> entityClazz = this.adapterFactory.getEntityClass(interfaceClazz);
        Query query = this.getEntityManager(true).createNativeQuery(sql, entityClazz);
        return query.getResultStream().map(e -> this.adapterFactory.getModelAdapter((EntityWithId)e, interfaceClazz, true).get());
    }

    public int executeNativeUpdate(String sql, boolean invalidateCache) {
        EntityManager em = this.getEntityManager(false);
        try {
            em.getTransaction().begin();
            int affected = em.createNativeQuery(sql).executeUpdate();
            em.getTransaction().commit();
            int n = affected;
            return n;
        }
        finally {
            this.closeEntityManager(em);
            if (invalidateCache) {
                this.clearCache();
            }
        }
    }

    protected String getNamedQueryName(Class<?> clazz, String ... properties) {
        Class<? extends EntityWithId> entityClazz = this.adapterFactory.getEntityClass(clazz);
        StringJoiner queryName = new StringJoiner(".");
        queryName.add(entityClazz.getSimpleName());
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            queryName.add(string);
            ++n2;
        }
        if (this.accessControlService.isAobo(EvACE.of(clazz, (Right)Right.READ))) {
            queryName.add("aobo");
        }
        return queryName.toString();
    }

    public INativeQuery getNativeQuery(String sql) {
        Query query = this.getEntityManager(true).createNativeQuery(sql);
        return new NativeQuery(query);
    }

    public <R, T> INamedQuery<R> getNamedQuery(Class<R> returnValueclazz, Class<T> definitionClazz, boolean refreshCache, String ... properties) {
        if (this.evaluateRightNoException(definitionClazz, Right.READ)) {
            return new NamedQuery<R, T>(returnValueclazz, definitionClazz, refreshCache, this.adapterFactory, this.getEntityManager(true), this.getNamedQueryName(definitionClazz, properties));
        }
        return new EmptyNamedQuery();
    }

    public <R, T> INamedQuery<R> getNamedQueryByName(Class<R> returnValueclazz, Class<T> definitionClazz, boolean refreshCache, String queryName) {
        if (this.evaluateRightNoException(definitionClazz, Right.READ)) {
            return new NamedQuery<R, T>(returnValueclazz, definitionClazz, refreshCache, this.adapterFactory, this.getEntityManager(true), queryName);
        }
        return new EmptyNamedQuery();
    }

    public <T> long getHighestLastUpdate(Class<T> clazz) {
        INativeQuery nativeQuery = this.getNativeQuery("SELECT COALESCE(MAX(LASTUPDATE),0) FROM " + this.getTableName(this.getEntityManager(true), this.getEntityClass(clazz)));
        Optional result = nativeQuery.executeWithParameters(Collections.emptyMap()).findFirst();
        if (result.isPresent()) {
            return ((Number)result.get()).longValue();
        }
        return 0L;
    }

    private <T> String getTableName(EntityManager em, Class<T> entityClass) {
        Metamodel meta = em.getMetamodel();
        EntityType entityType = meta.entity(entityClass);
        Table t = entityClass.getAnnotation(Table.class);
        String tableName = t == null ? entityType.getName().toUpperCase() : t.name();
        return tableName;
    }
}

