/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.StringTool;

public class VersionInfo
implements Comparable<VersionInfo> {
    String orig;
    String[] spl;

    public static String Version() {
        return "1.8.0";
    }

    public VersionInfo() {
        this(VersionInfo.Version());
    }

    public VersionInfo(String v) {
        if (StringTool.isNothing(v)) {
            this.orig = null;
            this.spl = null;
        } else {
            this.orig = v;
            this.spl = this.orig.split("\\.");
        }
    }

    public String getMaior() {
        if (this.spl == null || this.spl.length < 1) {
            return "0";
        }
        if (StringTool.isNothing(this.spl[0])) {
            return "0";
        }
        return this.spl[0];
    }

    public String getMinor() {
        if (this.spl == null || this.spl.length < 2) {
            return "0";
        }
        return this.spl[1];
    }

    public String getRevision() {
        if (this.spl == null || this.spl.length < 3) {
            return "0";
        }
        return this.spl[2];
    }

    public String getBuildTag() {
        if (this.spl == null || this.spl.length < 4) {
            return "";
        }
        return this.spl[3];
    }

    public String version() {
        return this.orig;
    }

    public boolean matches(VersionInfo pattern) {
        int i = 0;
        while (i < 3) {
            if (i >= this.spl.length) {
                return i >= pattern.spl.length;
            }
            if (i >= pattern.spl.length) {
                return false;
            }
            if (!this.matchElements(this.spl[0], pattern.spl[0])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean matchElements(String a, String b) {
        if (a.equals("*") || b.equals("*")) {
            return true;
        }
        return this.compareElem(a, b) == 0;
    }

    public boolean isNewer(String other) {
        VersionInfo vo = new VersionInfo(other);
        return this.isNewer(vo);
    }

    public boolean isOlder(String other) {
        VersionInfo vn = new VersionInfo(other);
        return this.isOlder(vn);
    }

    public boolean isNewer(VersionInfo vo) {
        return this.compareTo(vo) > 0;
    }

    public boolean isOlder(VersionInfo vo) {
        return this.compareTo(vo) < 0;
    }

    public boolean isNewerMaior(VersionInfo vo) {
        return this.compareElem(this.getMaior(), vo.getMaior()) > 0;
    }

    public boolean isNewerMinor(VersionInfo vo) {
        if (this.isNewerMaior(vo)) {
            return true;
        }
        if (this.isOlder(vo)) {
            return false;
        }
        return this.compareElem(this.getMinor(), vo.getMinor()) > 0;
    }

    public boolean isNewerRev(VersionInfo vo) {
        return this.isNewerMaior(vo) ? true : (this.isNewerMinor(vo) ? true : this.compareElem(this.getRevision(), vo.getRevision()) > 0);
    }

    public boolean isNewerBuild(VersionInfo vo) {
        return this.isNewerRev(vo) ? true : this.compareElem(this.getBuildTag(), vo.getBuildTag()) > 0;
    }

    public boolean isEqual(VersionInfo vo) {
        return this.compareTo(vo) == 0;
    }

    @Override
    public int compareTo(VersionInfo vo) {
        int c = this.compareElem(this.getMaior(), vo.getMaior());
        if (c != 0) {
            return c;
        }
        c = this.compareElem(this.getMinor(), vo.getMinor());
        if (c != 0) {
            return c;
        }
        c = this.compareElem(this.getRevision(), vo.getRevision());
        if (c != 0) {
            return c;
        }
        return this.compareElem(this.getBuildTag(), vo.getBuildTag());
    }

    private int compareElem(String a, String b) {
        int bl;
        int al = a.length();
        if (al == (bl = b.length())) {
            return a.compareToIgnoreCase(b);
        }
        int diff = Math.abs(al - bl);
        String x = StringTool.pad(1, '0', a, al + diff + 1);
        String y = StringTool.pad(1, '0', b, al + diff + 1);
        return x.compareToIgnoreCase(y);
    }
}

