/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import ch.rgw.io.ISettingChangedListener;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Settings
implements Serializable,
Cloneable {
    private static int SerializedVersion = 5;
    private static final long serialVersionUID = 993914522991464454L + (long)SerializedVersion;
    protected static Logger log = null;
    protected Hashtable node;
    private volatile String path = null;
    private volatile boolean dirty = false;
    private ISettingChangedListener settingChangedListener = null;
    public static final int OVL_REPLACE = 1;
    public static final int OVL_REPLACE_EXISTING = 2;
    public static final int OVL_ADD_MISSING = 4;
    public static final int OVL_ALL = 6;

    static {
        if (log == null) {
            log = LoggerFactory.getLogger((String)"Settings");
        }
    }

    public static String Version() {
        return "4.2.2";
    }

    protected Settings() {
        this.node = new Hashtable();
        this.dirty = false;
    }

    protected Settings(byte[] flat) {
        this.node = StringTool.fold(flat, 0, null);
        this.dirty = true;
    }

    protected Settings(Hashtable n) {
        this.node = n == null ? new Hashtable() : n;
        this.dirty = true;
    }

    public void setSettingChangedListener(ISettingChangedListener settingChangedListener) {
        this.settingChangedListener = settingChangedListener;
    }

    public ISettingChangedListener getSettingChangedListener() {
        return this.settingChangedListener;
    }

    protected void cleaned() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String toString() {
        return StringTool.enPrintable(StringTool.flatten(this.node, 0, null));
    }

    protected String getPath() {
        if (this.path == null) {
            return "";
        }
        return this.path;
    }

    public void clear() {
        this.node.clear();
        this.dirty = true;
    }

    public double get(String key, double defvalue) {
        String res = this.get(key, null);
        if (res == null) {
            return defvalue;
        }
        try {
            return Double.parseDouble(res);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            log.error("Parse fehler f\u00fcr Double " + res);
            return defvalue;
        }
    }

    public String get(String key, String defvalue) {
        Hashtable subnode = this.findParent(key, false);
        if (subnode == null) {
            return defvalue;
        }
        Object v = subnode.get(this.getLeaf(key));
        return StringTool.isNothing(v) ? defvalue : (String)v;
    }

    public boolean set(String key, String value) {
        if (key == null || value == null) {
            return false;
        }
        Hashtable subnode = this.findParent(key, true);
        this.dirty = true;
        if (this.settingChangedListener != null) {
            this.settingChangedListener.settingChanged(key, value);
        }
        return subnode.put(this.getLeaf(key), value) != null;
    }

    private String getLeaf(String key) {
        int id = key.lastIndexOf(47);
        if (id != -1) {
            String leaf = key.substring(id + 1);
            return leaf;
        }
        return key;
    }

    private Hashtable findParent(String key, boolean CreateIfNeeded) {
        String[] path1 = key.split("/");
        Hashtable subnode = this.node;
        int i = 0;
        while (i < path1.length - 1) {
            Object v = subnode.get(path1[i]);
            if (v == null || !(v instanceof Hashtable)) {
                if (CreateIfNeeded) {
                    v = new Hashtable();
                    subnode.put(path1[i], v);
                    this.dirty = true;
                } else {
                    return null;
                }
            }
            subnode = (Hashtable)v;
            ++i;
        }
        return subnode;
    }

    public String[] keys(String nod) {
        Settings sn = this.getBranch(nod, false);
        if (sn == null) {
            return null;
        }
        ArrayList al = sn.keys();
        return al.toArray(new String[0]);
    }

    public String[] nodes(String nod) {
        Settings sn = this.getBranch(nod, false);
        if (sn == null) {
            return null;
        }
        ArrayList al = sn.nodes();
        return al.toArray(new String[0]);
    }

    public ArrayList keys() {
        Enumeration en = this.node.keys();
        ArrayList dest = new ArrayList();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            if (this.node.get(k) instanceof Hashtable) continue;
            dest.add(k);
        }
        return dest;
    }

    public ArrayList nodes() {
        Enumeration en = this.node.keys();
        ArrayList dest = new ArrayList();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            if (!(this.node.get(k) instanceof Hashtable)) continue;
            dest.add(k);
        }
        return dest;
    }

    public Settings getBranch(String name, boolean CreateIfNotExist) {
        Hashtable parent = this.findParent(name, CreateIfNotExist);
        if (parent == null) {
            return null;
        }
        String id = this.getLeaf(name);
        Object k = parent.get(id);
        if (k == null || !(k instanceof Hashtable)) {
            if (CreateIfNotExist) {
                k = new Hashtable();
                parent.put(id, k);
                this.dirty = true;
            } else {
                return null;
            }
        }
        try {
            Settings n = (Settings)this.clone();
            n.path = this.path == null ? String.valueOf(name) + "/" : String.valueOf(this.path) + name + "/";
            n.node = (Hashtable)k;
            return n;
        }
        catch (CloneNotSupportedException e) {
            ExHandler.handle(e);
            return null;
        }
    }

    public ArrayList<String> getAll() {
        ArrayList<String> ret = new ArrayList<String>();
        this.addNode(ret, "", this.node);
        return ret;
    }

    public Iterator<String> iterator() {
        ArrayList<String> al = this.getAll();
        Iterator<String> it = al.iterator();
        return it;
    }

    private void addNode(ArrayList dest, String name, Hashtable n) {
        Enumeration en = n.keys();
        while (en.hasMoreElements()) {
            String k = (String)en.nextElement();
            Object o = n.get(k);
            if (o instanceof Hashtable) {
                this.addNode(dest, String.valueOf(name) + k + "/", (Hashtable)o);
                continue;
            }
            dest.add(String.valueOf(name) + k);
        }
    }

    private long getHashCode(String ex) {
        long hc = 0L;
        ArrayList<String> keys = this.getAll();
        int i = 0;
        while (i < keys.size()) {
            String a = keys.get(i);
            if (!a.equals(ex)) {
                String b = this.get(a, "");
                hc += (long)b.hashCode();
                if ((hc <<= 2) < 0L) {
                    hc |= 1L;
                }
            }
            ++i;
        }
        return hc;
    }

    public long createHashCode(String ex) {
        long ret = this.getHashCode(ex);
        this.set(ex, Long.toString(ret));
        return ret;
    }

    public boolean checkHashCode(String ex) {
        long oldval = Long.parseLong(this.get(ex, "-1"));
        long nval = this.getHashCode(ex);
        return nval == oldval;
    }

    public void set(String key, int value) {
        this.set(key, Integer.toString(value));
    }

    public void set(String key, Rectangle rec) {
        if (rec == null) {
            return;
        }
        String v = String.valueOf(Integer.toString(rec.x)) + "," + Integer.toString(rec.y) + "," + Integer.toString(rec.width) + "," + Integer.toString(rec.height);
        this.set(key, v);
    }

    public void set(String key, TimeTool d) {
        this.set(key, d.toString(5));
    }

    public void remove(String key) {
        Hashtable p = this.findParent(key, false);
        if (p != null) {
            if (this.settingChangedListener != null) {
                this.settingChangedListener.settingRemoved(key);
            }
            p.remove(this.getLeaf(key));
            this.dirty = true;
        }
    }

    public int get(String key, int defvalue) {
        String v = this.get(key, Integer.toString(defvalue));
        try {
            return Integer.parseInt(v);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            log.debug("Int parse Fehler. Gebe Default zur\u00fcck (" + defvalue + ")");
            this.set(key, defvalue);
            return defvalue;
        }
    }

    public String getQuoted(String key, String defvalue) {
        String vorl = this.get(key, defvalue);
        return vorl.replaceAll("\\\\", "/");
    }

    public String[] getStringArray(String key) {
        String raw = this.get(key, null);
        if (StringTool.isNothing(raw)) {
            return null;
        }
        return raw.split(",");
    }

    public TimeTool getDate(String key) {
        String d = this.get(key, "");
        if (d.equals("")) {
            return null;
        }
        try {
            return new TimeTool(d);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public Rectangle get(String key) {
        String v = this.get(key, "");
        if (v == null) {
            return null;
        }
        String[] r = v.split(",");
        if (r.length != 4) {
            return null;
        }
        return new Rectangle(Integer.parseInt(r[0]), Integer.parseInt(r[1]), Integer.parseInt(r[2]), Integer.parseInt(r[3]));
    }

    public boolean get(String key, boolean defvalue) {
        String v = this.get(key, null);
        if (v == null) {
            return defvalue;
        }
        if (v.equals("1")) {
            return true;
        }
        return v.equals("true");
    }

    public boolean set(String key, boolean value) {
        return this.set(key, value ? "1" : "0");
    }

    public void flush() {
        if (this.dirty) {
            this.flush_absolute();
            this.dirty = false;
        }
    }

    protected abstract void flush_absolute();

    public abstract void undo();

    public void overlay(Settings other, int mode) {
        ArrayList<String> otherEntries = other.getAll();
        if ((mode & 1) != 0) {
            this.node.clear();
        }
        int i = 0;
        while (i < otherEntries.size()) {
            String el = otherEntries.get(i);
            if (this.get(el, null) != null) {
                if ((mode & 2) != 0) {
                    this.set(el, other.get(el, null));
                }
            } else if ((mode & 5) != 0) {
                this.set(el, other.get(el, null));
            }
            ++i;
        }
    }

    public List<String> getAsList(String key) {
        String[] split;
        String string = this.get(key, null);
        if (string != null && (split = string.split(",")) != null && split.length > 0) {
            return Arrays.asList(split);
        }
        return Collections.emptyList();
    }

    public void setAsList(String key, List<String> values) {
        Optional<String> value = values.stream().map(o -> o.toString()).reduce((u, t) -> String.valueOf(u) + "," + t);
        if (value.isPresent()) {
            this.set(key, value.get());
        } else {
            this.remove(key);
        }
    }
}

