/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.dialogs.AddBuchungDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class AccountView
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.views.rechnung.AccountView";
    private static final String ACCOUNT_EXCESS_JOB_NAME = Messages.AccountView_calculateBalance;
    private BackgroundJob accountExcessJob;
    private FormToolkit tk;
    private Form form;
    private Label balanceLabel;
    private Label excessLabel;
    private TableViewer accountViewer;
    private Patient actPatient;
    private Action addPaymentAction;
    private Action removePaymentAction;
    private int sortColumn;
    private boolean sortReverse;
    private static final int DATE = 0;
    private static final int AMOUNT = 1;
    private static final int BILL = 2;
    private static final int REMARKS = 3;
    private static final int ACCOUNT = 4;
    private static final String[] COLUMN_TEXT = new String[]{Messages.Core_Date, Messages.Core_Amount, Messages.Core_Bill, Messages.Core_Remarks, Messages.AccountView_account};
    private static final int[] COLUMN_WIDTH = new int[]{80, 80, 80, 160, 80};

    @Inject
    void activeUser(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (patient != null) {
                this.setPatient((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient));
            } else {
                this.setPatient(null);
            }
        }, (Object)this.accountViewer);
    }

    @Inject
    void activeTransaction(@Optional IAccountTransaction transaction) {
        if (this.removePaymentAction != null) {
            this.removePaymentAction.setEnabled(transaction != null);
        }
    }

    public void createPartControl(Composite parent) {
        this.initializeJobs();
        parent.setLayout((Layout)new FillLayout());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite accountArea = this.tk.createComposite(this.form.getBody());
        accountArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        accountArea.setLayout((Layout)new GridLayout(3, false));
        this.tk.createLabel(accountArea, Messages.AccountView_account);
        this.tk.createLabel(accountArea, Messages.AccountView_accountAmount);
        this.balanceLabel = this.tk.createLabel(accountArea, "");
        this.balanceLabel.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.createLabel(accountArea, "");
        this.tk.createLabel(accountArea, Messages.AccountView_goodFromBills);
        this.excessLabel = this.tk.createLabel(accountArea, "");
        this.excessLabel.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.accountViewer = new TableViewer(this.form.getBody(), 65540);
        Table table = this.accountViewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tk.adapt((Composite)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        SelectionAdapter sortListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn col = (TableColumn)e.getSource();
                Integer colNo = (Integer)col.getData();
                if (colNo == AccountView.this.sortColumn) {
                    AccountView.this.sortReverse = !AccountView.this.sortReverse;
                } else {
                    AccountView.this.sortReverse = false;
                    AccountView.this.sortColumn = colNo;
                }
                AccountView.this.accountViewer.getTable().setSortDirection(AccountView.this.sortReverse ? 1024 : 128);
                AccountView.this.accountViewer.getTable().setSortColumn(col);
                AccountView.this.accountViewer.refresh();
            }
        };
        TableColumn[] tc = new TableColumn[COLUMN_TEXT.length];
        int i = 0;
        while (i < COLUMN_TEXT.length) {
            tc[i] = new TableColumn(table, 0);
            tc[i].setText(COLUMN_TEXT[i]);
            tc[i].setWidth(COLUMN_WIDTH[i]);
            tc[i].setData((Object)new Integer(i));
            tc[i].addSelectionListener((SelectionListener)sortListener);
            ++i;
        }
        this.accountViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (AccountView.this.actPatient == null) {
                    return new Object[]{Messages.Core_No_patient_selected_point};
                }
                Query qa = new Query(AccountTransaction.class);
                qa.add("PatientID", "=", AccountView.this.actPatient.getId());
                qa.orderBy(true, new String[]{"Datum"});
                return qa.execute().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.accountViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (!(element instanceof AccountTransaction)) {
                    return "";
                }
                AccountTransaction entry = (AccountTransaction)element;
                String text = "";
                AccountTransaction.Account account = null;
                switch (columnIndex) {
                    case 0: {
                        text = entry.get("Datum");
                        break;
                    }
                    case 1: {
                        text = entry.getAmount().getAmountAsString();
                        break;
                    }
                    case 2: {
                        Rechnung rechnung = entry.getRechnung();
                        if (rechnung != null && rechnung.exists()) {
                            text = rechnung.getNr();
                            break;
                        }
                        text = "";
                        break;
                    }
                    case 3: {
                        text = entry.getRemark();
                        break;
                    }
                    case 4: {
                        account = entry.getAccount();
                        if (account == null || account == AccountTransaction.Account.UNKNOWN) break;
                        text = account.getName();
                    }
                }
                return text;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        this.accountViewer.setSorter((ViewerSorter)new AccountTransactionSorter());
        this.accountViewer.setInput((Object)this.getViewSite());
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.addPaymentAction});
        this.removePaymentAction.setEnabled(false);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.accountViewer.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        if (this.sortColumn == 0) {
            this.sortReverse = true;
        }
    }

    private void initializeJobs() {
        this.accountExcessJob = new AccountExcessJob(ACCOUNT_EXCESS_JOB_NAME);
        this.accountExcessJob.addListener(new BackgroundJob.BackgroundJobListener(){

            @Override
            public void jobFinished(BackgroundJob j) {
                AccountView.this.setKontoText();
            }
        });
        this.accountExcessJob.schedule();
    }

    private void finishJobs() {
        this.accountExcessJob.cancel();
    }

    public void setFocus() {
        this.accountViewer.getControl().setFocus();
    }

    public void dispose() {
        this.finishJobs();
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        this.accountViewer.removeSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        super.dispose();
    }

    private void setPatient(Patient patient) {
        this.actPatient = patient;
        this.accountExcessJob.invalidate();
        this.accountExcessJob.schedule();
        String title = "";
        title = this.actPatient != null ? this.actPatient.getLabel() : Messages.Core_No_patient_selected_point;
        this.form.setText(title);
        this.setKontoText();
        this.accountViewer.refresh();
        this.form.layout();
    }

    private void setKontoText() {
        if (this.balanceLabel.isDisposed() || this.excessLabel.isDisposed()) {
            return;
        }
        String balanceText = "";
        String excessText = "...";
        if (this.actPatient != null) {
            Object jobData;
            balanceText = this.actPatient.getKontostand().getAmountAsString();
            if (this.accountExcessJob.isValid() && (jobData = this.accountExcessJob.getData()) instanceof Money) {
                Money accountExcess = (Money)jobData;
                excessText = accountExcess.getAmountAsString();
            }
        }
        this.balanceLabel.setText(balanceText);
        this.excessLabel.setText(excessText);
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            Patient patient = ElexisEventDispatcher.getSelectedPatient();
            this.setPatient(patient);
        } else {
            this.setPatient(null);
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private void makeActions() {
        this.addPaymentAction = new Action(Messages.Invoice_Add_Payment){
            {
                this.setToolTipText(Messages.Invoice_add_amount_as_payment);
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
            }

            public void run() {
                if (new AddBuchungDialog(AccountView.this.getViewSite().getShell(), AccountView.this.actPatient).open() == 0) {
                    AccountView.this.setPatient(AccountView.this.actPatient);
                }
            }
        };
        this.removePaymentAction = new Action(Messages.AccountView_deleteBookingAction){
            {
                this.setToolTipText(Messages.AccountView_deleteBookingTooltip);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                AccountTransaction at = (AccountTransaction)ElexisEventDispatcher.getSelected(AccountTransaction.class);
                if (at != null && SWTHelper.askYesNo(Messages.AccountView_deleteBookingConfirmCaption, Messages.AccountView_deleteBookingConfirmBody)) {
                    at.delete();
                    AccountView.this.setPatient(AccountView.this.actPatient);
                }
            }
        };
    }

    class AccountExcessJob
    extends BackgroundJob {
        public AccountExcessJob(String name) {
            super(name);
        }

        @Override
        public IStatus execute(IProgressMonitor monitor) {
            this.result = AccountView.this.actPatient != null ? AccountView.this.actPatient.getAccountExcess() : null;
            return Status.OK_STATUS;
        }

        @Override
        public int getSize() {
            return 1;
        }
    }

    class AccountTransactionSorter
    extends ViewerSorter {
        AccountTransactionSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof AccountTransaction && e2 instanceof AccountTransaction) {
                AccountTransaction accountTransaction1 = (AccountTransaction)e1;
                AccountTransaction accountTransaction2 = (AccountTransaction)e2;
                int retVal = 0;
                switch (AccountView.this.sortColumn) {
                    case 0: {
                        retVal = ObjectUtils.compare((Comparable)new TimeTool(accountTransaction1.getDate()), (Comparable)new TimeTool(accountTransaction2.getDate()));
                        break;
                    }
                    case 1: {
                        retVal = ObjectUtils.compare((Comparable)accountTransaction1.getAmount(), (Comparable)accountTransaction2.getAmount());
                        break;
                    }
                    case 2: {
                        Rechnung rechnung1 = accountTransaction1.getRechnung();
                        Rechnung rechnung2 = accountTransaction2.getRechnung();
                        if (rechnung1 == null) {
                            retVal = -1;
                            break;
                        }
                        if (rechnung2 == null) {
                            retVal = 1;
                            break;
                        }
                        retVal = ObjectUtils.compare((Comparable)Integer.valueOf(NumberUtils.toInt((String)rechnung1.getNr())), (Comparable)Integer.valueOf(NumberUtils.toInt((String)rechnung2.getNr())));
                        break;
                    }
                    case 3: {
                        retVal = ObjectUtils.compare((Comparable)((Object)accountTransaction1.getRemark()), (Comparable)((Object)accountTransaction2.getRemark()));
                        break;
                    }
                    case 4: {
                        retVal = ObjectUtils.compare((Comparable)((Object)accountTransaction1.getAccount().getName()), (Comparable)((Object)accountTransaction2.getAccount().getName()));
                    }
                }
                return AccountView.this.sortReverse ? retVal * -1 : retVal;
            }
            return 0;
        }
    }
}

