/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.editors.ContactSelectionDialogCellEditor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockDetailComposite
extends Composite {
    private WritableValue<IArticle> wvArtikel = new WritableValue(null, IArticle.class);
    private Logger log = LoggerFactory.getLogger(StockDetailComposite.class);
    private Table table;
    private Map<IStock, IStockEntry> stockEntries = new HashMap<IStock, IStockEntry>();
    private CheckboxTableViewer checkboxTableViewer;

    public StockDetailComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        this.checkboxTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table = this.checkboxTableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setEnabled(false);
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IStock stock = (IStock)element;
                if (stock == null) {
                    return null;
                }
                return stock.getCode();
            }
        });
        TableColumn tblclmnStock = tableViewerColumn.getColumn();
        tblclmnStock.setResizable(true);
        tblclmnStock.setAlignment(0x1000000);
        tcl_composite.setColumnData((Widget)tblclmnStock, (ColumnLayoutData)new ColumnPixelData(100, false, false));
        tblclmnStock.setText("Verf\u00fcgbar in Lager");
        TableViewerColumn tvcMin = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport sees = new StockEntryEditingSupport(this.checkboxTableViewer, 0);
        tvcMin.setEditingSupport((EditingSupport)sees);
        tvcMin.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getMinimumStock());
                }
                return null;
            }
        });
        TableColumn tblclmnMin = tvcMin.getColumn();
        tblclmnMin.setResizable(true);
        tblclmnMin.setAlignment(0x1000000);
        tcl_composite.setColumnData((Widget)tblclmnMin, (ColumnLayoutData)new ColumnPixelData(30, false, true));
        tblclmnMin.setText("Min");
        TableViewerColumn tvcIst = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport seesIst = new StockEntryEditingSupport(this.checkboxTableViewer, 1);
        tvcIst.setEditingSupport((EditingSupport)seesIst);
        tvcIst.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getCurrentStock());
                }
                return null;
            }
        });
        TableColumn tblclmnNewColumn = tvcIst.getColumn();
        tblclmnNewColumn.setResizable(true);
        tcl_composite.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnPixelData(30, false, true));
        tblclmnNewColumn.setText("Ist");
        TableViewerColumn tvcMax = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport seesMax = new StockEntryEditingSupport(this.checkboxTableViewer, 2);
        tvcMax.setEditingSupport((EditingSupport)seesMax);
        tvcMax.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getMaximumStock());
                }
                return null;
            }
        });
        TableColumn tblclmnMax = tvcMax.getColumn();
        tblclmnMax.setResizable(true);
        tcl_composite.setColumnData((Widget)tblclmnMax, (ColumnLayoutData)new ColumnPixelData(30, true, true));
        tblclmnMax.setText("Max");
        TableViewerColumn tvcFraction = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport seesFrac = new StockEntryEditingSupport(this.checkboxTableViewer, 3);
        tvcFraction.setEditingSupport((EditingSupport)seesFrac);
        tvcFraction.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getFractionUnits());
                }
                return null;
            }
        });
        TableColumn tblclmnFraction = tvcFraction.getColumn();
        tblclmnFraction.setResizable(true);
        tcl_composite.setColumnData((Widget)tblclmnFraction, (ColumnLayoutData)new ColumnPixelData(30, false, true));
        tblclmnFraction.setText("Anbruch");
        TableViewerColumn tvcProvider = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        tvcProvider.setEditingSupport(new EditingSupport((ColumnViewer)this.checkboxTableViewer){

            protected void setValue(Object element, Object value) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return;
                }
                IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
                if (se == null) {
                    return;
                }
                se.setProvider((IContact)value);
                CoreModelServiceHolder.get().save((Identifiable)se);
                this.getViewer().refresh();
            }

            protected Object getValue(Object element) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
                if (se == null) {
                    return null;
                }
                return se.getProvider();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ContactSelectionDialogCellEditor((Composite)((CheckboxTableViewer)this.getViewer()).getTable(), "Lieferant ausw\u00e4hlen", "Bitte selektieren Sie den Lieferant");
            }

            protected boolean canEdit(Object element) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return false;
                }
                return StockDetailComposite.this.stockEntries.get(stock) != null;
            }
        });
        tvcProvider.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IStock stock = (IStock)element;
                IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
                if (se == null) {
                    return null;
                }
                IContact provider = se.getProvider();
                if (provider == null) {
                    return null;
                }
                return provider.getLabel();
            }
        });
        TableColumn tblclmnProvider = tvcProvider.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnProvider, (ColumnLayoutData)new ColumnPixelData(200, true, true));
        tblclmnProvider.setText("Lieferant");
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (StockDetailComposite.this.wvArtikel.getValue() instanceof IArticle) {
                    IStock stock = (IStock)event.getElement();
                    IArticle art = (IArticle)StockDetailComposite.this.wvArtikel.getValue();
                    if (stock != null && art != null && !stock.isCommissioningSystem()) {
                        if (event.getChecked()) {
                            StockServiceHolder.get().storeArticleInStock(stock, StoreToStringServiceHolder.getStoreToString((Object)art));
                        } else {
                            StockServiceHolder.get().unstoreArticleFromStock(stock, StoreToStringServiceHolder.getStoreToString((Object)art));
                        }
                    }
                }
                StockDetailComposite.this.refreshData();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                IStock stock = (IStock)element;
                if (stock == null || StockDetailComposite.this.wvArtikel.getValue() == null) {
                    return false;
                }
                return StockDetailComposite.this.stockEntries.get(stock) != null;
            }
        });
        List stocks = StockServiceHolder.get().getAllStocks(true);
        for (IStock stock : stocks) {
            this.stockEntries.put(stock, null);
        }
        this.checkboxTableViewer.setInput((Object)stocks);
        TableViewer ret = new TableViewer(this.table);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(ret, new FocusCellHighlighter((ColumnViewer)ret){});
        ColumnViewerEditorActivationStrategy editorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)ret){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = (ViewerCell)event.getSource();
                return cell.getColumnIndex() > 0 && cell.getColumnIndex() < 5;
            }
        };
        TableViewerEditor.create((TableViewer)ret, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)16);
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    @Optional
    @Inject
    public void udpate(@UIEventTopic(value="info/elexis/model/update") IStockEntry entry) {
        if (entry != null && this.checkboxTableViewer != null && this.stockEntries != null && !this.checkboxTableViewer.getControl().isDisposed()) {
            for (IStock key : this.stockEntries.keySet()) {
                if (this.stockEntries.get(key) == null || !this.stockEntries.get(key).equals(entry)) continue;
                this.refreshData();
            }
        }
    }

    private void refreshData() {
        String articleString;
        boolean enabled = false;
        String string = articleString = this.wvArtikel.getValue() != null ? StoreToStringServiceHolder.getStoreToString((Object)this.wvArtikel.getValue()) : null;
        if (this.wvArtikel.getValue() instanceof IArticle) {
            enabled = !((IArticle)this.wvArtikel.getValue()).isProduct();
        }
        this.table.setEnabled(enabled);
        this.stockEntries.replaceAll((k, v) -> null);
        if (articleString != null) {
            this.stockEntries.keySet().forEach(k -> this.stockEntries.put((IStock)k, StockServiceHolder.get().findStockEntryForArticleInStock(k, articleString)));
        }
        this.checkboxTableViewer.refresh(true);
    }

    protected void checkSubclass() {
    }

    public void setArticle(IArticle article) {
        this.wvArtikel.setValue((Object)article);
        this.refreshData();
    }

    public class StockEntryEditingSupport
    extends EditingSupport {
        public static final int MIN = 0;
        public static final int CURR = 1;
        public static final int MAX = 2;
        public static final int FRAC = 3;
        private final int editorFor;
        private final CellEditor editor;

        public StockEntryEditingSupport(CheckboxTableViewer columnViewer, int editorFor) {
            super((ColumnViewer)columnViewer);
            this.editorFor = editorFor;
            this.editor = new TextCellEditor((Composite)columnViewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            IStock stock = (IStock)element;
            if (stock == null || StockDetailComposite.this.wvArtikel.getValue() == null || StockDetailComposite.this.stockEntries.get(stock) == null) {
                return false;
            }
            return 1 != this.editorFor && 3 != this.editorFor || !stock.isCommissioningSystem();
        }

        protected Object getValue(Object element) {
            IStock stock = (IStock)element;
            if (stock == null || StockDetailComposite.this.wvArtikel.getValue() == null) {
                return "";
            }
            IStockEntry se = StockDetailComposite.this.stockEntries.get(stock);
            if (se == null) {
                return "";
            }
            int value = 0;
            switch (this.editorFor) {
                case 0: {
                    value = se.getMinimumStock();
                    break;
                }
                case 1: {
                    value = se.getCurrentStock();
                    break;
                }
                case 2: {
                    value = se.getMaximumStock();
                    break;
                }
                case 3: {
                    value = se.getFractionUnits();
                }
            }
            return Integer.toString(value);
        }

        protected void setValue(Object element, Object value) {
            IStock stock = (IStock)element;
            if (stock == null || StockDetailComposite.this.wvArtikel.getValue() == null) {
                return;
            }
            IStockEntry stockEntry = StockDetailComposite.this.stockEntries.get(stock);
            if (stockEntry == null) {
                return;
            }
            LockResponse lr = LocalLockServiceHolder.get().acquireLock((Object)stockEntry);
            if (!lr.isOk()) {
                return;
            }
            int val = 0;
            try {
                val = Integer.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (this.editorFor) {
                case 0: {
                    stockEntry.setMinimumStock(val);
                    break;
                }
                case 2: {
                    stockEntry.setMaximumStock(val);
                    break;
                }
                case 1: {
                    stockEntry.setCurrentStock(val);
                    break;
                }
                case 3: {
                    stockEntry.setFractionUnits(val);
                }
            }
            CoreModelServiceHolder.get().save((Identifiable)stockEntry);
            lr = LocalLockServiceHolder.get().releaseLock((Object)stockEntry);
            if (!lr.isOk()) {
                StockDetailComposite.this.log.warn("Error releasing lock for [{}]: {}", (Object)stockEntry.getId(), (Object)lr.getStatus());
            }
            this.getViewer().refresh();
        }
    }
}

