/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.IMedicationHelper;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.types.ArticleTyp;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Medication;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class MedicationIArticleTransformer
implements IFhirTransformer<Medication, IArticle> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IStoreToStringService storeToStringService;
    private IMedicationHelper medicationHelper;

    @Activate
    private void activate() {
        this.medicationHelper = new IMedicationHelper();
    }

    @Override
    public Optional<Medication> getFhirObject(IArticle localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Medication medication = new Medication();
        medication.setId((IIdType)new IdDt("Medication", localObject.getTyp() + "." + localObject.getId()));
        CodeableConcept code = new CodeableConcept();
        code.addCoding(this.medicationHelper.getNameCoding(localObject.getName()));
        code.addCoding(this.medicationHelper.getTypeCoding(localObject));
        code.addCoding(this.medicationHelper.getGtinCoding(localObject.getGtin()));
        List<Coding> atcCodings = this.medicationHelper.getAtcCodings(localObject.getAtcCode());
        for (Coding atcCoding : atcCodings) {
            code.addCoding(atcCoding);
        }
        medication.setCode(code);
        if (!localObject.isProduct()) {
            medication.setAmount(this.medicationHelper.determineAmount(localObject));
        }
        return Optional.of(medication);
    }

    @Override
    public Optional<IArticle> getLocalObject(Medication fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            String realId = id.substring(id.indexOf(46) + 1);
            if (id.startsWith(ArticleTyp.ARTIKELSTAMM.getCodeSystemName())) {
                return this.storeToStringService.loadFromString("ch.artikelstamm.elexis.common.ArtikelstammItem::" + realId).map(IArticle.class::cast);
            }
            return this.coreModelService.load(realId, IArticle.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IArticle> updateLocalObject(Medication fhirObject, IArticle localObject) {
        return null;
    }

    @Override
    public Optional<IArticle> createLocalObject(Medication fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Medication.class.equals(fhirClazz) && IArticle.class.equals(localClazz);
    }
}

