/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts.controls;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskTriggerType;
import ch.elexis.core.ui.tasks.parts.controls.AbstractTaskDescriptorConfigurationComposite;
import ch.elexis.core.ui.tasks.parts.controls.RunContextCheckButtonWithDefaultValue;
import ch.elexis.core.ui.tasks.parts.controls.RunContextTextWithDefaultValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public class RunnableAndContextConfigurationComposite
extends AbstractTaskDescriptorConfigurationComposite {
    private ITaskService taskService;
    private IIdentifiedRunnable selectedRunnable;
    private Text txtRunnableId;
    private Composite compAssisted;
    private Composite compRaw;
    private Text txtRunContextRaw;

    public RunnableAndContextConfigurationComposite(Composite parent, int style, ITaskService taskService) {
        super(parent, style);
        this.taskService = taskService;
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblRunnable = new Label((Composite)this, 0);
        lblRunnable.setText("runnable");
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRunnableId = new Text(composite, 2048);
        this.txtRunnableId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Link linkRunnableSelect = new Link(composite, 0);
        linkRunnableSelect.setBounds(0, 0, 54, 15);
        linkRunnableSelect.setText("<a>...</a>");
        linkRunnableSelect.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                RunnableAndContextConfigurationComposite.this.openRunnableSelectionDialog();
            }
        });
        TabFolder tabFolder = new TabFolder((Composite)this, 1024);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabItem tbtmAssisted = new TabItem(tabFolder, 0);
        tbtmAssisted.setText("Assisted");
        this.compAssisted = new Composite((Composite)tabFolder, 0);
        tbtmAssisted.setControl((Control)this.compAssisted);
        GridLayout gl_compAssisted = new GridLayout(2, false);
        gl_compAssisted.marginWidth = 0;
        gl_compAssisted.marginHeight = 0;
        this.compAssisted.setLayout((Layout)gl_compAssisted);
        TabItem tbtmRaw = new TabItem(tabFolder, 0);
        tbtmRaw.setText("Raw");
        this.compRaw = new Composite((Composite)tabFolder, 0);
        tbtmRaw.setControl((Control)this.compRaw);
        this.compRaw.setLayout((Layout)new FillLayout(256));
        this.txtRunContextRaw = new Text(this.compRaw, 2050);
    }

    @Override
    public void setSelection(ITaskDescriptor taskDescriptor) {
        super.setSelection(taskDescriptor);
        this.selectedRunnable = null;
        if (taskDescriptor != null) {
            String identifiedRunnableId = taskDescriptor.getIdentifiedRunnableId();
            if (this.taskService != null && identifiedRunnableId != null) {
                List identifiedRunnables = this.taskService.getIdentifiedRunnables();
                for (IIdentifiedRunnable iIdentifiedRunnable : identifiedRunnables) {
                    if (!identifiedRunnableId.equalsIgnoreCase(iIdentifiedRunnable.getId())) continue;
                    this.selectedRunnable = iIdentifiedRunnable;
                    taskDescriptor.setIdentifiedRunnableId(this.selectedRunnable.getId());
                    this.saveTaskDescriptor();
                    break;
                }
            }
            this.txtRunnableId.setText(identifiedRunnableId);
            this.refreshAssistedConfigurationComposite();
        } else {
            this.txtRunnableId.setText("");
            this.txtRunContextRaw.setText("");
        }
    }

    @Override
    public void refresh() {
        this.refreshAssistedConfigurationComposite();
    }

    private void refreshAssistedConfigurationComposite() {
        Label description;
        Control[] children;
        Control[] controlArray = children = this.compAssisted.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (this.selectedRunnable != null) {
            description = new Label(this.compAssisted, 0);
            description.setText(this.selectedRunnable.getLocalizedDescription());
            description.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
            new Label(this.compAssisted, 0);
            new Label(this.compAssisted, 0);
            Map defaultRunContext = this.selectedRunnable.getDefaultRunContext();
            Map configuredRunContext = this.taskDescriptor.getRunContext();
            Set keySet = defaultRunContext.keySet();
            for (String key : keySet) {
                Label keyLabel = new Label(this.compAssisted, 0);
                keyLabel.setText(key);
                keyLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
                Object defaultValue = (Serializable)defaultRunContext.get(key);
                Serializable configuredValue = (Serializable)configuredRunContext.get(key);
                if (defaultValue == null) {
                    defaultValue = "null";
                }
                if (defaultValue instanceof Boolean) {
                    RunContextCheckButtonWithDefaultValue btnValue = new RunContextCheckButtonWithDefaultValue(this.compAssisted, this, key, (Boolean)defaultValue, (Boolean)configuredValue);
                    btnValue.setText("active");
                    btnValue.setLayoutData(new GridData(4, 128, true, false, 1, 1));
                    continue;
                }
                boolean enabled = true;
                if (TaskTriggerType.FILESYSTEM_CHANGE == this.taskDescriptor.getTriggerType() && "url".equals(key)) {
                    enabled = false;
                    defaultValue = "supplied by trigger";
                }
                RunContextTextWithDefaultValue txtValue = new RunContextTextWithDefaultValue(this.compAssisted, this, key, Objects.toString(defaultValue, null), Objects.toString(configuredValue, null), enabled);
                txtValue.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            }
        } else {
            description = new Label(this.compAssisted, 0);
            description.setText("No assist available");
            description.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        }
        this.compAssisted.layout(true);
    }

    private void openRunnableSelectionDialog() {
        Object[] result;
        ListDialog listDialog = new ListDialog(this.getShell());
        listDialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        List identifiedRunnables = this.taskService.getIdentifiedRunnables();
        Collections.sort(identifiedRunnables, Comparator.comparing(IIdentifiedRunnable::getId));
        listDialog.setInput((Object)identifiedRunnables);
        listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IIdentifiedRunnable runnable = (IIdentifiedRunnable)element;
                return runnable.getId();
            }
        });
        listDialog.setMessage("Select an action");
        int open = listDialog.open();
        if (open == 0 && (result = listDialog.getResult()) != null && result.length >= 1) {
            IIdentifiedRunnable selection = (IIdentifiedRunnable)result[0];
            this.taskDescriptor.setIdentifiedRunnableId(selection.getId());
            this.setSelection(this.taskDescriptor);
        }
    }
}

