/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter.internal;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.internal.PredicateGroupStack;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.SingularAttribute;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.LoggerFactory;

public class PredicateHandler {
    protected CriteriaBuilder criteriaBuilder;
    protected Root<? extends EntityWithId> rootQuery;
    protected PredicateGroupStack predicateGroups;
    protected Class<? extends EntityWithId> entityClazz;

    public PredicateHandler(PredicateGroupStack predicateGroups, Class<? extends EntityWithId> entityClazz, CriteriaBuilder criteriaBuilder, Root<? extends EntityWithId> rootQuery) {
        this.predicateGroups = predicateGroups;
        this.entityClazz = entityClazz;
        this.criteriaBuilder = criteriaBuilder;
        this.rootQuery = rootQuery;
    }

    public String getAttributeName(EStructuralFeature feature, Class<? extends EntityWithId> entityClazz) {
        String ret = feature.getName();
        EAnnotation mappingAnnotation = feature.getEAnnotation("http://elexis.info/jpa/entity/attribute/mapping");
        if (mappingAnnotation != null && (ret = (String)mappingAnnotation.getDetails().get((Object)(String.valueOf(entityClazz.getSimpleName()) + "#" + IModelService.EANNOTATION_ENTITY_ATTRIBUTE_MAPPING_NAME))) == null) {
            ret = (String)mappingAnnotation.getDetails().get(IModelService.EANNOTATION_ENTITY_ATTRIBUTE_MAPPING_NAME);
        }
        return ret;
    }

    public void exists(Subquery<?> query) {
        this.predicateGroups.getCurrentPredicateGroup().and(this.criteriaBuilder.exists(query));
    }

    public void notExists(Subquery<?> query) {
        this.predicateGroups.getCurrentPredicateGroup().and(this.criteriaBuilder.exists(query).not());
    }

    public void and(EStructuralFeature feature, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        String entityAttributeName = this.getAttributeName(feature, this.entityClazz);
        Optional<SingularAttribute> attribute = this.resolveAttribute(this.entityClazz.getName(), entityAttributeName);
        value = this.resolveValue(value);
        if (!attribute.isPresent()) {
            throw new IllegalStateException("Could not resolve attribute [" + feature + "] of entity [" + this.entityClazz + "]");
        }
        Optional<Predicate> predicate = this.getPredicate(attribute.get(), comparator, value, ignoreCase);
        predicate.ifPresent(p -> this.predicateGroups.getCurrentPredicateGroup().and((Predicate)p));
    }

    public void andFeatureCompare(EStructuralFeature feature, IQuery.COMPARATOR comparator, EStructuralFeature otherFeature) {
        String entityAttributeName = this.getAttributeName(feature, this.entityClazz);
        String entityOtherAttributeName = this.getAttributeName(otherFeature, this.entityClazz);
        this.andCompare(this.rootQuery, this.entityClazz, entityOtherAttributeName, comparator, entityAttributeName);
    }

    public void andCompare(Root<? extends EntityWithId> otherRoot, Class<? extends EntityWithId> otherEntityClazz, String otherEntityAttributeName, IQuery.COMPARATOR comparator, String entityAttributeName) {
        Optional<SingularAttribute> attribute = this.resolveAttribute(this.entityClazz.getName(), entityAttributeName);
        Optional<SingularAttribute> otherAttribute = this.resolveAttribute(otherEntityClazz.getName(), otherEntityAttributeName);
        if (!attribute.isPresent() || !otherAttribute.isPresent()) {
            throw new IllegalStateException("Could not resolve attribute [" + entityAttributeName + "] of entity [" + this.entityClazz + "] or [" + otherEntityAttributeName + "] of entity [" + otherEntityClazz + "]");
        }
        Optional<Predicate> predicate = this.getPredicate(attribute.get(), comparator, otherAttribute.get(), otherRoot, false);
        predicate.ifPresent(p -> this.predicateGroups.getCurrentPredicateGroup().and((Predicate)p));
    }

    public void and(String entityAttributeName, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        Optional<SingularAttribute> attribute = this.resolveAttribute(this.entityClazz.getName(), entityAttributeName);
        value = this.resolveValue(value);
        if (!attribute.isPresent()) {
            throw new IllegalStateException("Could not resolve attribute [" + entityAttributeName + "] of entity [" + this.entityClazz + "]");
        }
        Optional<Predicate> predicate = this.getPredicate(attribute.get(), comparator, value, ignoreCase);
        predicate.ifPresent(p -> this.predicateGroups.getCurrentPredicateGroup().and((Predicate)p));
    }

    public void or(EStructuralFeature feature, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        String entityAttributeName = this.getAttributeName(feature, this.entityClazz);
        Optional<SingularAttribute> attribute = this.resolveAttribute(this.entityClazz.getName(), entityAttributeName);
        value = this.resolveValue(value);
        if (!attribute.isPresent()) {
            throw new IllegalStateException("Could not resolve attribute [" + feature + "] of entity [" + this.entityClazz + "]");
        }
        Optional<Predicate> predicate = this.getPredicate(attribute.get(), comparator, value, ignoreCase);
        predicate.ifPresent(p -> this.predicateGroups.getCurrentPredicateGroup().or((Predicate)p));
    }

    public void or(String entityAttributeName, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        Optional<SingularAttribute> attribute = this.resolveAttribute(this.entityClazz.getName(), entityAttributeName);
        value = this.resolveValue(value);
        if (!attribute.isPresent()) {
            throw new IllegalStateException("Could not resolve attribute [" + entityAttributeName + "] of entity [" + this.entityClazz + "]");
        }
        Optional<Predicate> predicate = this.getPredicate(attribute.get(), comparator, value, ignoreCase);
        predicate.ifPresent(p -> this.predicateGroups.getCurrentPredicateGroup().or((Predicate)p));
    }

    protected Optional<Predicate> getPredicate(SingularAttribute attribute, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        return this.getPredicate(attribute, comparator, value, null, ignoreCase);
    }

    protected Optional<Predicate> getPredicate(SingularAttribute attribute, IQuery.COMPARATOR comparator, Object value, Root<? extends EntityWithId> valueRoot, boolean ignoreCase) {
        switch (comparator) {
            case EQUALS: {
                if (value instanceof SingularAttribute) {
                    return Optional.of(this.criteriaBuilder.equal((Expression)this.rootQuery.get(attribute), (Expression)(valueRoot != null ? valueRoot.get((SingularAttribute)value) : this.rootQuery.get((SingularAttribute)value))));
                }
                return Optional.of(this.criteriaBuilder.equal((Expression)this.rootQuery.get(attribute), value));
            }
            case NOT_EQUALS: {
                if (value instanceof SingularAttribute) {
                    return Optional.of(this.criteriaBuilder.notEqual((Expression)this.rootQuery.get(attribute), (Expression)(valueRoot != null ? valueRoot.get((SingularAttribute)value) : this.rootQuery.get((SingularAttribute)value))));
                }
                return Optional.of(this.criteriaBuilder.notEqual((Expression)this.rootQuery.get(attribute), value));
            }
            case LIKE: {
                if (value instanceof String) {
                    if (ignoreCase) {
                        return Optional.of(this.criteriaBuilder.like(this.criteriaBuilder.lower((Expression)this.rootQuery.get(attribute)), ((String)value).toLowerCase()));
                    }
                    return Optional.of(this.criteriaBuilder.like((Expression)this.rootQuery.get(attribute), (String)value));
                }
                throw new IllegalStateException("[" + value + "] is not a known type");
            }
            case NOT_LIKE: {
                if (value instanceof String) {
                    if (ignoreCase) {
                        return Optional.of(this.criteriaBuilder.notLike(this.criteriaBuilder.lower((Expression)this.rootQuery.get(attribute)), ((String)value).toLowerCase()));
                    }
                    return Optional.of(this.criteriaBuilder.notLike((Expression)this.rootQuery.get(attribute), (String)value));
                }
                throw new IllegalStateException("[" + value + "] is not a known type");
            }
            case GREATER: {
                if (value instanceof String) {
                    return Optional.of(this.criteriaBuilder.greaterThan((Expression)this.rootQuery.get(attribute), (Comparable)((Object)((String)value))));
                }
                if (value instanceof Integer) {
                    return Optional.of(this.criteriaBuilder.greaterThan((Expression)this.rootQuery.get(attribute), (Comparable)((Integer)value)));
                }
                if (value instanceof Long) {
                    return Optional.of(this.criteriaBuilder.greaterThan((Expression)this.rootQuery.get(attribute), (Comparable)((Long)value)));
                }
                if (value instanceof LocalDateTime) {
                    return Optional.of(this.criteriaBuilder.greaterThan((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDateTime)value)));
                }
                if (value instanceof LocalDate) {
                    return Optional.of(this.criteriaBuilder.greaterThan((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDate)value)));
                }
                if (value instanceof SingularAttribute) {
                    return Optional.of(this.criteriaBuilder.greaterThan((Expression)this.rootQuery.get(attribute), (Expression)(valueRoot != null ? valueRoot.get((SingularAttribute)value) : this.rootQuery.get((SingularAttribute)value))));
                }
                throw new IllegalStateException("[" + value + "] is not a known type");
            }
            case GREATER_OR_EQUAL: {
                if (value instanceof String) {
                    return Optional.of(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((Object)((String)value))));
                }
                if (value instanceof Integer) {
                    return Optional.of(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((Integer)value)));
                }
                if (value instanceof Long) {
                    return Optional.of(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((Long)value)));
                }
                if (value instanceof LocalDateTime) {
                    return Optional.of(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDateTime)value)));
                }
                if (value instanceof LocalDate) {
                    return Optional.of(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDate)value)));
                }
                if (value instanceof SingularAttribute) {
                    return Optional.of(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Expression)(valueRoot != null ? valueRoot.get((SingularAttribute)value) : this.rootQuery.get((SingularAttribute)value))));
                }
                throw new IllegalStateException("[" + value + "] is not a known type");
            }
            case LESS: {
                if (value instanceof String) {
                    return Optional.of(this.criteriaBuilder.lessThan((Expression)this.rootQuery.get(attribute), (Comparable)((Object)((String)value))));
                }
                if (value instanceof Integer) {
                    return Optional.of(this.criteriaBuilder.lessThan((Expression)this.rootQuery.get(attribute), (Comparable)((Integer)value)));
                }
                if (value instanceof Long) {
                    return Optional.of(this.criteriaBuilder.lessThan((Expression)this.rootQuery.get(attribute), (Comparable)((Long)value)));
                }
                if (value instanceof LocalDateTime) {
                    return Optional.of(this.criteriaBuilder.lessThan((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDateTime)value)));
                }
                if (value instanceof LocalDate) {
                    return Optional.of(this.criteriaBuilder.lessThan((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDate)value)));
                }
                if (value instanceof SingularAttribute) {
                    return Optional.of(this.criteriaBuilder.lessThan((Expression)this.rootQuery.get(attribute), (Expression)(valueRoot != null ? valueRoot.get((SingularAttribute)value) : this.rootQuery.get((SingularAttribute)value))));
                }
                throw new IllegalStateException("[" + value + "] is not a known type");
            }
            case LESS_OR_EQUAL: {
                if (value instanceof String) {
                    return Optional.of(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((Object)((String)value))));
                }
                if (value instanceof Integer) {
                    return Optional.of(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((Integer)value)));
                }
                if (value instanceof Long) {
                    return Optional.of(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((Long)value)));
                }
                if (value instanceof LocalDateTime) {
                    return Optional.of(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDateTime)value)));
                }
                if (value instanceof LocalDate) {
                    return Optional.of(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Comparable)((LocalDate)value)));
                }
                if (value instanceof SingularAttribute) {
                    return Optional.of(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.rootQuery.get(attribute), (Expression)(valueRoot != null ? valueRoot.get((SingularAttribute)value) : this.rootQuery.get((SingularAttribute)value))));
                }
                throw new IllegalStateException("[" + value + "] is not a known type");
            }
            case IN: {
                if (value instanceof Iterable) {
                    Path expr = this.rootQuery.get(attribute);
                    Iterable values = (Iterable)value;
                    CriteriaBuilder.In in = this.criteriaBuilder.in((Expression)expr);
                    values.forEach(p -> {
                        CriteriaBuilder.In in2 = in.value(p);
                    });
                    return Optional.of(in);
                }
                throw new IllegalStateException("[" + value + "] is not a known type");
            }
        }
        return Optional.empty();
    }

    public Optional<SingularAttribute> resolveAttribute(String entityClazzName, String featureName) {
        try {
            Field[] fields;
            Class<?> metaClazz = this.getClass().getClassLoader().loadClass(String.valueOf(entityClazzName) + "_");
            Field[] fieldArray = fields = metaClazz.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object value;
                Field field = fieldArray[n2];
                if (field.getName().equalsIgnoreCase(featureName) && (value = field.get(null)) instanceof SingularAttribute) {
                    return Optional.of((SingularAttribute)value);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not find metamodel class for entity [" + entityClazzName + "]");
        }
        return Optional.empty();
    }

    protected Object resolveValue(Object value) {
        Object ret = value;
        if (value instanceof AbstractIdModelAdapter) {
            ret = ((AbstractIdModelAdapter)value).getEntity();
        }
        return ret;
    }
}

