/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter;

import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.mixin.ExtInfoHandler;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.WithExtInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractIdModelAdapter<T extends EntityWithId>
implements Identifiable {
    protected List<Identifiable> refreshList;
    protected List<Identifiable> changedList;
    protected ExtInfoHandler extInfoHandler;
    private final String entityType;
    private T entity;
    private boolean dirty = false;

    public AbstractIdModelAdapter(T entity) {
        this.entity = entity;
        this.entityType = entity.getClass().getName();
        if (!(entity instanceof EntityWithId)) {
            throw new IllegalStateException("Model " + entity + " is no subclass of " + EntityWithId.class.getSimpleName());
        }
        if (this instanceof WithExtInfo && entity instanceof EntityWithExtInfo) {
            this.extInfoHandler = new ExtInfoHandler(this);
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public T getEntityMarkDirty() {
        this.dirty = true;
        return this.entity;
    }

    public synchronized void setEntity(EntityWithId entity, boolean resetDirty) {
        if (!this.dirty || this.dirty && resetDirty) {
            this.entity = entity;
            this.dirty = false;
        }
    }

    public String getId() {
        return this.getEntity().getId();
    }

    public String getLabel() {
        return this.getEntity().toString();
    }

    public Long getLastupdate() {
        return this.getEntity().getLastupdate() != null ? this.getEntity().getLastupdate() : 0L;
    }

    public void addRefresh(Identifiable changed) {
        if (this.refreshList == null) {
            this.refreshList = new ArrayList<Identifiable>();
        }
        this.refreshList.add(changed);
    }

    public List<Identifiable> getRefresh() {
        return this.refreshList;
    }

    public void clearRefresh() {
        this.refreshList = null;
    }

    public void addChanged(Identifiable changed) {
        if (this.changedList == null) {
            this.changedList = new ArrayList<Identifiable>();
            this.changedList.add(this);
        }
        this.changedList.add(changed);
    }

    public List<Identifiable> getChanged() {
        return this.changedList;
    }

    public void clearChanged() {
        this.changedList = null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected Date toDate(LocalDateTime localDateTime) {
        ZonedDateTime atZone = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(atZone.toInstant());
    }

    protected Date toDate(LocalDate localDate) {
        ZonedDateTime atZone = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(atZone.toInstant());
    }

    protected LocalDateTime toLocalDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [getEntity()=" + this.getEntity() + ", isDrity()=" + this.isDirty() + ", getLastupdate()=" + this.getLastupdate() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractIdModelAdapter other = (AbstractIdModelAdapter)obj;
        return !(this.entity == null ? other.entity != null : !this.entityEqualId((EntityWithId)this.entity, (EntityWithId)other.entity));
    }

    private boolean entityEqualId(EntityWithId left, EntityWithId right) {
        if (left.getId() != null && right.getId() != null) {
            return left.getId().equals(right.getId());
        }
        return false;
    }
}

