/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.admin.ACE;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Right;
import ch.rgw.tools.JdbcLink;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class Role
extends PersistentObject {
    public static final String TABLENAME = "ROLE";
    public static final String FLD_SYSTEM_ROLE = "ISSYSTEMROLE";
    public static final String FLD_EXT_I18N_LABEL = "LAB_" + Locale.getDefault().getLanguage();
    public static final String FLD_JOINT_RIGHTS = "Rights";

    static {
        Role.addMapping(TABLENAME, "id", FLD_SYSTEM_ROLE, "ExtInfo", "Rights=LIST:ROLE_ID:ROLE_RIGHT_JOINT");
        Role.initTables();
    }

    public Role() {
    }

    @Deprecated(forRemoval=true)
    protected static void initTables() {
        if (!Role.tableExists(TABLENAME)) {
            Role.executeDBInitScriptForClass(Role.class, null);
            ACE.initializeACEDefaults(false);
        }
    }

    public Role(boolean isSystemRole) {
        this.create(null);
        this.setSystemRole(false);
    }

    protected Role(String id) {
        super(id);
    }

    public static Role load(String id) {
        return new Role(id);
    }

    @Override
    public String getLabel() {
        return this.get("id");
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public boolean isSystemRole() {
        return this.getBoolean(FLD_SYSTEM_ROLE);
    }

    public void setSystemRole(boolean val) {
    }

    public String getRoleName() {
        return this.get("id");
    }

    @Nullable
    public Role setRoleName(String rolename) {
        if (Role.verifyRoleNameNotTaken(rolename)) {
            List<ACE> ar = Arrays.asList(this.getAssignedAccessRights());
            ar.stream().forEachOrdered(a -> this.revokeAccessRight((ACE)a));
            this.set("id", rolename);
            Role r = Role.load(rolename);
            ar.stream().forEachOrdered(a -> r.grantAccessRight((ACE)a));
            return r;
        }
        return null;
    }

    public static boolean verifyRoleNameNotTaken(String rolename) {
        return new Query(Role.class, "id", rolename).execute().size() == 0;
    }

    public String getTranslatedLabel() {
        return (String)this.getExtInfoStoredObjectByKey(FLD_EXT_I18N_LABEL);
    }

    public void setTranslatedLabel(String translatedLabel) {
        this.setExtInfoStoredObjectByKey(FLD_EXT_I18N_LABEL, translatedLabel);
    }

    public ACE[] getAssignedAccessRights() {
        ACE[] array = (ACE[])ACE.getAllDefinedACElements().stream().filter(p -> CoreHub.acl.request(this, (ACE)p)).toArray(ACE[]::new);
        return array;
    }

    private List<String> getAssignedRightsIds() {
        return this.getList(FLD_JOINT_RIGHTS, false);
    }

    public void grantAccessRight(ACE ace) {
        Right right = Right.getOrCreateRightByACE(ace);
        if (this.getAssignedRightsIds().contains(ace.getUniqueHashFromACE())) {
            return;
        }
        this.addToList(FLD_JOINT_RIGHTS, right.getId(), new String[0]);
    }

    public void revokeAccessRight(ACE ace) {
        ace.getChildren(true).stream().map((? super T p) -> Right.getOrCreateRightByACE(p)).forEachOrdered(r -> this.removeFromList(FLD_JOINT_RIGHTS, r.getId()));
    }

    @Override
    public boolean delete() {
        if (this.isSystemRole()) {
            return false;
        }
        Arrays.asList(this.getAssignedAccessRights()).stream().forEachOrdered(a -> this.revokeAccessRight((ACE)a));
        JdbcLink.Stm stm = Role.getConnection().getStatement();
        int res = stm.exec("DELETE FROM ROLE WHERE ID=" + this.getWrappedId());
        Role.getConnection().releaseStatement(stm);
        return res == 1;
    }

    public void revokeAllRightsForRole() {
        JdbcLink.Stm stm = Role.getConnection().getStatement();
        stm.exec("DELETE FROM ROLE_RIGHT_JOINT WHERE ROLE_ID=" + this.getWrappedId());
        Role.getConnection().releaseStatement(stm);
    }
}

