/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.preferences;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.ComboFieldEditor;
import ch.elexis.core.ui.preferences.inputs.MultilineFieldEditor;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.Sticker;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class UserSettings2
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String REMEMBER_LAST_STATE = Messages.UserSettings2_RememberLastState;
    public static final String ALWAYS_CLOSED = Messages.UserSettings2_AlwaysClosed;
    public static final String ALWAYS_OPEN = Messages.UserSettings2_AlwaysOpen;
    private ConfigServicePreferenceStore prefs = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER);
    private static final String[] patlistFocusFields = new String[]{"PatientNr", "Name", "Vorname", "Geburtsdatum"};

    public UserSettings2() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)this.prefs);
        this.prefs.setDefault("view/expandableComposites/setting", "3");
        this.prefs.setDefault("anwender/patlist/zeigenr", false);
        this.prefs.setDefault("anwender/patlist/zeigename", true);
        this.prefs.setDefault("anwender/patlist/zeigevorname", true);
        this.prefs.setDefault("anwender/patlist/zeigegebdat", true);
        this.prefs.setDefault("anwender/suppressintractioncheck", true);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new RadioGroupFieldEditor("view/expandableComposites/setting", Messages.UserSettings2_ExtendableFields, 1, (String[][])new String[][]{{ALWAYS_OPEN, "1"}, {ALWAYS_CLOSED, "2"}, {REMEMBER_LAST_STATE, "3"}}, this.getFieldEditorParent()));
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        new Label(this.getFieldEditorParent(), 0).setText(Messages.UserSettings2_FieldsInList);
        this.addField((FieldEditor)new BooleanFieldEditor("anwender/patlist/zeigenr", Messages.Core_Patient_Number, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("anwender/patlist/zeigename", Messages.Core_Name, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("anwender/patlist/zeigevorname", Messages.Core_Firstname, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("anwender/patlist/zeigegebdat", Messages.Core_Enter_Birthdate, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("anwender/patlist/focusfield", "Fokusfeld", patlistFocusFields, this.getFieldEditorParent()));
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        new Label(this.getFieldEditorParent(), 0).setText(Messages.UserSettings2_AddidtionalFields);
        this.addField((FieldEditor)new MultilineFieldEditor("views/patientenblatt/extrafelder", "", 5, 0, true, this.getFieldEditorParent()));
        new Label(this.getFieldEditorParent(), 0).setText("");
        final ComboFieldEditor editor = new ComboFieldEditor("sticker/patient/deceased", "Sticker f\u00fcr verstorbene", this.getStickerComboItems(), this.getFieldEditorParent());
        editor.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        this.addField((FieldEditor)editor);
        final Button migrateButton = new Button(this.getFieldEditorParent(), 8);
        migrateButton.setText("Verstorben Info aus Sticker \u00fcbernehmen");
        migrateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String cfgSticker = editor.getCombo().getItem(editor.getCombo().getSelectionIndex());
                final ISticker sticker = UserSettings2.this.getSticker(cfgSticker);
                if (sticker != null) {
                    if (MessageDialog.openQuestion((Shell)UserSettings2.this.getShell(), (String)"Verstorben Info", (String)("Soll bei Patienten mit dem Sticker " + cfgSticker + " die verstorben Information gesetzt werden?\nAchtung, der Vorgang kann nicht r\u00fcckg\u00e4ngig gemacht werden."))) {
                        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(UserSettings2.this.getShell());
                        try {
                            progressDialog.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    IQuery query = CoreModelServiceHolder.get().getQuery(IPatient.class);
                                    Throwable throwable = null;
                                    Object var4_5 = null;
                                    try (IQueryCursor cursor = query.executeAsCursor();){
                                        monitor.beginTask("Verstorben Migration", cursor.size());
                                        while (cursor.hasNext()) {
                                            IPatient patient = (IPatient)cursor.next();
                                            ISticker existing = StickerServiceHolder.get().getSticker((Identifiable)patient, sticker);
                                            if (existing != null && !patient.isDeceased()) {
                                                patient.setDeceased(true);
                                                CoreModelServiceHolder.get().save((Identifiable)patient);
                                            }
                                            monitor.worked(1);
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            MessageDialog.openError((Shell)UserSettings2.this.getShell(), (String)"Verstorben Sticker", (String)"Fehler beim verstorben Information setzen.");
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error migration of deceased sticker", (Throwable)ex);
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)UserSettings2.this.getShell(), (String)"Verstorben Sticker", (String)("Es konnte kein Sticker mit dem Namen " + cfgSticker + " f\u00fcr Patient gefunden werden."));
                }
            }
        });
        editor.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                migrateButton.setEnabled(editor.getCombo().getSelectionIndex() > 0);
            }
        });
        migrateButton.setEnabled(StringUtils.isNotBlank((CharSequence)ConfigServiceHolder.getGlobal((String)"sticker/patient/deceased", (String)"")));
    }

    private String[] getStickerComboItems() {
        List stickers = Sticker.getStickersForClass(Patient.class);
        List<String> stickerNames = stickers.stream().map(s -> s.getLabel()).collect(Collectors.toList());
        stickerNames.add(0, "");
        return stickerNames.toArray(new String[stickerNames.size()]);
    }

    private ISticker getSticker(String stickername) {
        for (ISticker iSticker : StickerServiceHolder.get().getStickersForClass(IPatient.class)) {
            if (!iSticker.getName().equalsIgnoreCase(stickername)) continue;
            return iSticker;
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        SWTHelper.reloadViewPart((String)"ch.elexis.PatListView");
        return super.performOk();
    }
}

