/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.internal.VirtualFilesystemHandle;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.osgi.service.component.annotations.Component;

@Component
public class VirtualFilesystemService
implements IVirtualFilesystemService {
    public IVirtualFilesystemService.IVirtualFilesystemHandle of(String uriString) throws IOException {
        try {
            URI uri = IVirtualFilesystemService.stringToURI((String)uriString);
            return new VirtualFilesystemHandle(uri);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IOException("Error handling uri string [" + uriString + "]", e);
        }
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle of(File file) throws IOException {
        if (file == null) {
            return null;
        }
        URI uri = file.toURI();
        return new VirtualFilesystemHandle(uri);
    }
}

