/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import ch.elexis.core.services.IVirtualFilesystemService;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class VirtualFilesystemUriEditorDialog
extends TitleAreaDialog {
    private DataBindingContext m_bindingContext;
    private IVirtualFilesystemService virtualFilesystemService;
    private MyURI uri;
    private Text txtHost;
    private Text txtPort;
    private Text txtUser;
    private Text txtPath;
    private Text txtPassword;
    private Text txtUri;
    private Combo comboScheme;

    public VirtualFilesystemUriEditorDialog(Shell parentShell, IVirtualFilesystemService virtualFilesystemService, URI uri) {
        super(parentShell);
        this.virtualFilesystemService = virtualFilesystemService;
        this.uri = new MyURI();
        if (uri != null) {
            this.uri.setUri(uri);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("URL Editor");
        this.setMessage("Edit Virtual Filesystem Service supported URL");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblScheme = new Label(container, 0);
        lblScheme.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblScheme.setText("Scheme");
        this.comboScheme = new Combo(container, 0);
        this.comboScheme.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboScheme.setItems(new String[]{"smb", "file"});
        Label lblHost = new Label(container, 0);
        lblHost.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblHost.setText("Host");
        this.txtHost = new Text(container, 2048);
        this.txtHost.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPort = new Label(container, 0);
        lblPort.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPort.setText("Port");
        this.txtPort = new Text(container, 2048);
        this.txtPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPath = new Label(container, 0);
        lblPath.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPath.setText("Path");
        this.txtPath = new Text(container, 2048);
        this.txtPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label txtPath = new Label(container, 0);
        txtPath.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        txtPath.setText("User");
        this.txtUser = new Text(container, 2048);
        this.txtUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(container, 0);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText("Password");
        this.txtPassword = new Text(container, 2048);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel = new Label(container, 258);
        lblNewLabel.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Label lblUri = new Label(container, 0);
        lblUri.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUri.setText("URI");
        this.txtUri = new Text(container, 2048);
        this.txtUri.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, "Test", false);
        this.createButton(parent, 1025, JFaceResources.getString((String)"openBrowse"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.m_bindingContext = this.initDataBindings();
    }

    protected void buttonPressed(int buttonId) {
        block8: {
            this.setErrorMessage(null);
            if (1024 == buttonId) {
                try {
                    boolean isOk;
                    IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = this.virtualFilesystemService.of(this.uri.getUri().toString());
                    boolean bl = isOk = vfsHandle.exists() && vfsHandle.canRead();
                    if (isOk) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"URL Test", (String)(String.valueOf(this.uri.getUri().toString()) + " exists and is readable"));
                        break block8;
                    }
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"URL Test", (String)(String.valueOf(this.uri.getUri().toString()) + " does not exist or is not readable"));
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getLocalizedMessage());
                }
            } else if (1025 == buttonId) {
                DirectoryDialog dirDialog = new DirectoryDialog(this.getShell());
                String selectedDir = dirDialog.open();
                if (StringUtils.isNotBlank((CharSequence)selectedDir)) {
                    this.uri.setUri(new File(selectedDir).toURI());
                    this.uri.setPort(null);
                }
            } else {
                super.buttonPressed(buttonId);
            }
        }
    }

    public URI getValue() {
        return this.uri.getUri();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue widgetScheme = WidgetProperties.comboSelection().observe((Widget)this.comboScheme);
        IObservableValue modelScheme = BeanProperties.value(MyURI.class, (String)"scheme", String.class).observe((Object)this.uri);
        bindingContext.bindValue((IObservableValue)widgetScheme, modelScheme, null, null);
        ISWTObservableValue widget = WidgetProperties.text((int)24).observe((Widget)this.txtHost);
        IObservableValue model = BeanProperties.value(MyURI.class, (String)"host", String.class).observe((Object)this.uri);
        bindingContext.bindValue((IObservableValue)widget, model, null, null);
        ISWTObservableValue widgetPort = WidgetProperties.text((int)24).observe((Widget)this.txtPort);
        IObservableValue modelPort = BeanProperties.value(MyURI.class, (String)"port", Integer.class).observe((Object)this.uri);
        bindingContext.bindValue((IObservableValue)widgetPort, modelPort, null, null);
        ISWTObservableValue widgetPath = WidgetProperties.text((int)24).observe((Widget)this.txtPath);
        IObservableValue modelPath = BeanProperties.value(MyURI.class, (String)"path", String.class).observe((Object)this.uri);
        bindingContext.bindValue((IObservableValue)widgetPath, modelPath, null, null);
        ISWTObservableValue widgetPass = WidgetProperties.text((int)24).observe((Widget)this.txtPassword);
        IObservableValue modelPass = BeanProperties.value(MyURI.class, (String)"pass", String.class).observe((Object)this.uri);
        bindingContext.bindValue((IObservableValue)widgetPass, modelPass, null, null);
        ISWTObservableValue widgetUser = WidgetProperties.text((int)24).observe((Widget)this.txtUser);
        IObservableValue modelUser = BeanProperties.value(MyURI.class, (String)"user", String.class).observe((Object)this.uri);
        bindingContext.bindValue((IObservableValue)widgetUser, modelUser, null, null);
        IConverter stringToUriConverter = IConverter.create(String.class, URI.class, o -> URI.create(o.toString()));
        IConverter uriToStringConverter = IConverter.create(URI.class, String.class, u -> u != null ? this.uri.getUri().toString() : "");
        ISWTObservableValue widgetUri = WidgetProperties.text((int)24).observe((Widget)this.txtUri);
        IObservableValue modelUri = BeanProperties.value(MyURI.class, (String)"uri", URI.class).observe((Object)this.uri);
        bindingContext.bindValue((IObservableValue)widgetUri, modelUri, UpdateValueStrategy.create((IConverter)stringToUriConverter), UpdateValueStrategy.create((IConverter)uriToStringConverter));
        return bindingContext;
    }

    private class MyURI {
        private String scheme;
        private String host;
        private String path;
        private String user;
        private String pass;
        private Integer port;
        private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        private MyURI() {
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
            this.firePropertyChange("port", this.port, this.port);
            this.firePropertyChange("uri", null, this.getUri());
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
            this.firePropertyChange("scheme", this.scheme, this.scheme);
            this.firePropertyChange("uri", null, this.getUri());
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
            this.firePropertyChange("host", this.host, this.host);
            this.firePropertyChange("uri", null, this.getUri());
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
            this.firePropertyChange("path", this.path, this.path);
            this.firePropertyChange("uri", null, this.getUri());
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
            this.firePropertyChange("user", this.user, this.user);
            this.firePropertyChange("uri", null, this.getUri());
        }

        public String getPass() {
            return this.pass;
        }

        public void setPass(String pass) {
            this.pass = pass;
            this.firePropertyChange("pass", this.pass, this.pass);
            this.firePropertyChange("uri", null, this.getUri());
        }

        public URI getUri() {
            try {
                URIBuilder uriBuilder = new URIBuilder();
                if (StringUtils.isNotBlank((CharSequence)this.scheme)) {
                    uriBuilder.setScheme(this.scheme);
                }
                if (StringUtils.isNotBlank((CharSequence)this.host)) {
                    uriBuilder.setHost(this.host);
                }
                if (StringUtils.isNotBlank((CharSequence)this.path)) {
                    uriBuilder.setPath(this.path);
                }
                if (StringUtils.isNotBlank((CharSequence)this.user)) {
                    uriBuilder.setUserInfo(this.user, this.pass);
                }
                if (this.port != null && this.port > 0) {
                    uriBuilder.setPort(this.port.intValue());
                }
                return uriBuilder.build();
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        public void setUri(URI uri) {
            this.setScheme(uri.getScheme());
            this.setHost(uri.getHost());
            this.setPort(uri.getPort());
            this.setPath(uri.getPath());
            String userInfo = uri.getUserInfo();
            if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                int indexOf = userInfo.indexOf(58);
                if (indexOf > 0) {
                    this.setUser(userInfo.substring(0, indexOf));
                    this.setPass(userInfo.substring(indexOf + 1, userInfo.length()));
                } else {
                    this.setUser(userInfo);
                }
            }
            this.firePropertyChange("uri", this.getUri(), uri);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

