/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Zahlung;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountArticles {
    HashMap<IBillable, Double> paid = new HashMap();
    HashMap<IBillable, Double> unpaid = new HashMap();
    Money mPaid = new Money();
    Money mUnpaid = new Money();

    public String run(String fromDate, String untilDate, String referenceDate, String outputFile) {
        try {
            Query qbe = new Query(Konsultation.class);
            qbe.add("Datum", ">=", new TimeTool(fromDate).toString(9));
            qbe.add("Datum", "<=", new TimeTool(untilDate).toString(9));
            qbe.add("MandantID", "=", CoreHub.actMandant.getId());
            TimeTool refDate = new TimeTool(referenceDate);
            for (Konsultation k : qbe.execute()) {
                boolean bPaid = false;
                Rechnung r = k.getRechnung();
                if (r != null && r.getOffenerBetrag().isNeglectable()) {
                    List payments = r.getZahlungen();
                    for (Zahlung z : payments) {
                        if (!new TimeTool(z.getDatum()).isBeforeOrEqual(refDate)) continue;
                        bPaid = true;
                        break;
                    }
                }
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
                for (IBilled v : encounter.getBilled()) {
                    Double sum;
                    IBillable iv = v.getBillable();
                    if (!(iv instanceof IArticle)) continue;
                    if (bPaid) {
                        this.mPaid.addMoney(v.getTotal());
                        sum = this.paid.get(iv);
                        if (sum == null) {
                            sum = new Double(v.getAmount());
                            this.paid.put(iv, sum);
                            continue;
                        }
                        sum = sum + v.getAmount();
                        continue;
                    }
                    this.mUnpaid.addMoney(v.getTotal());
                    sum = this.unpaid.get(iv);
                    if (sum == null) {
                        sum = new Double(v.getAmount());
                        this.unpaid.put(iv, sum);
                        continue;
                    }
                    sum = sum + v.getAmount();
                }
            }
            if (outputFile != null) {
                Double sum;
                IBillable iv;
                File file = new File(outputFile);
                FileWriter fw = new FileWriter(file);
                CSVWriter cs = new CSVWriter(fw);
                cs.writeNext(new String[]{"Artikelstatistik per", refDate.toString(4)});
                cs.writeNext(new String[]{"Bezahlte Artikel", "Anzahl"});
                for (Map.Entry<IBillable, Double> entry : this.paid.entrySet()) {
                    iv = entry.getKey();
                    sum = entry.getValue();
                    cs.writeNext(new String[]{iv.getText(), sum.toString()});
                }
                cs.writeNext(new String[]{"Gesamtbetrag:", this.mPaid.getAmountAsString()});
                cs.writeNext(new String[0]);
                cs.writeNext(new String[]{"Unbezahlte Artikel", "Anzahl"});
                for (Map.Entry<IBillable, Double> entry : this.unpaid.entrySet()) {
                    iv = entry.getKey();
                    sum = entry.getValue();
                    cs.writeNext(new String[]{iv.getText(), sum.toString()});
                }
                cs.writeNext(new String[]{"Gesamtbetrag:", this.mUnpaid.getAmountAsString()});
                cs.close();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Artikelabgabe von (einschliesslich) ").append(new TimeTool(fromDate).toString(4)).append(" bis (einschliesslich) ").append(new TimeTool(untilDate).toString(4)).append(":\n").append("Bezahlte Artikel: ").append(this.mPaid.getAmountAsString()).append("\n").append("Unbezahlte Artikel: ").append(this.mUnpaid.getAmountAsString()).append("\n").append("(Jeweils per Stichtag " + new TimeTool(referenceDate).toString(4)).append(")\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return "Error executing Script: " + ex.getMessage();
        }
    }
}

