/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.ISticker;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dialogs.DocumentSelectDialog;
import ch.elexis.core.ui.text.MimeTypeUtil;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class TextTemplate {
    public static final String DEFAULT_MANDANT = "Alle";
    private String name;
    private String description;
    private String mimeType;
    private String mimeTypePrintname;
    private String mandantId;
    private String templateId;
    private String printer;
    private String tray;
    private boolean exists;
    private boolean systemTemplate;
    private boolean askForAddress;
    private String cfgTemplateBase;
    private byte[] documentContent = null;

    public TextTemplate(String name, String description, String mimeType) {
        this(name, description, mimeType, null, null, false, false, false);
    }

    public TextTemplate(String name, String description, String mimeType, boolean systemTemplate) {
        this(name, description, mimeType, null, null, false, systemTemplate, false);
    }

    public TextTemplate(String name, String description, String mimeType, String mandantId, String templateId, boolean exists, boolean systemTemplate, boolean askForAddress) {
        this.name = name;
        this.description = description;
        this.mandantId = mandantId;
        this.exists = exists;
        this.systemTemplate = systemTemplate;
        this.askForAddress = askForAddress;
        this.templateId = templateId;
        this.setMimeType(mimeType);
        this.updateConfigTemplateBase();
    }

    private void addTemplateReference(Brief template, boolean systemTemplate) {
        ISticker sticker;
        this.templateId = template.getId();
        this.exists = true;
        this.setSystemTemplate(systemTemplate);
        Kontakt adressat = template.getAdressat();
        if (adressat != null) {
            this.setMandant(template.getAdressat().getId());
        }
        if ((sticker = template.getSticker()) != null && sticker.getLabel().equals("brief_dontaskforaddressee-*-&")) {
            this.setAskForAddress(false);
        } else {
            this.setAskForAddress(true);
        }
        this.updateConfigTemplateBase();
        this.printer = CoreHub.localCfg.get(String.valueOf(this.cfgTemplateBase) + "/printer", null);
        this.tray = CoreHub.localCfg.get(String.valueOf(this.cfgTemplateBase) + "/tray", null);
    }

    public void removeTemplateReference() {
        this.templateId = null;
        this.exists = false;
        this.removePrintSettings();
    }

    private void removePrintSettings() {
        CoreHub.localCfg.remove(String.valueOf(this.cfgTemplateBase) + "/printer");
        CoreHub.localCfg.remove(String.valueOf(this.cfgTemplateBase) + "/tray");
        CoreHub.localCfg.flush();
    }

    public void addFormTemplateReference(Brief template) {
        this.addTemplateReference(template, false);
    }

    public void addSystemTemplateReference(Brief template) {
        this.addTemplateReference(template, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
        this.setMimeTypePrintname(mimeType);
    }

    public String getMimeTypePrintname() {
        return this.mimeTypePrintname;
    }

    public void setMimeTypePrintname(String rawMimeType) {
        this.mimeTypePrintname = MimeTypeUtil.getPrettyPrintName(rawMimeType);
    }

    public void setMandant(String mandantId) {
        if (mandantId == null) {
            mandantId = "";
        }
        this.mandantId = mandantId;
        this.updateTemplateReference(UPDATE_TYPE.MANDANT);
        this.updateConfigTemplateBase();
    }

    public void setMandant(Mandant mandant) {
        if (mandant == null) {
            this.setMandant("");
        } else {
            this.setMandant(mandant.getId());
        }
    }

    public Mandant getMandant() {
        Mandant ret;
        Mandant mandant = ret = this.mandantId == "" ? null : Mandant.load((String)this.mandantId);
        if (ret != null && ret.exists()) {
            return ret;
        }
        return null;
    }

    public String getMandantLabel() {
        Mandant mandant = this.getMandant();
        if (mandant == null || !mandant.isValid()) {
            return DEFAULT_MANDANT;
        }
        return mandant.get("Bezeichnung3");
    }

    public Brief getTemplate() {
        return this.templateId == null ? null : Brief.load((String)this.templateId);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
        CoreHub.localCfg.set(String.valueOf(this.cfgTemplateBase) + "/printer", printer);
        CoreHub.localCfg.flush();
    }

    public String getTray() {
        return this.tray;
    }

    public void setTray(String tray) {
        this.tray = tray;
        CoreHub.localCfg.set(String.valueOf(this.cfgTemplateBase) + "/tray", tray);
        CoreHub.localCfg.flush();
    }

    public String getCfgTemplateBase() {
        return this.cfgTemplateBase;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isSystemTemplate() {
        return this.systemTemplate;
    }

    public void setSystemTemplate(boolean systemTemplate) {
        this.systemTemplate = systemTemplate;
        this.updateTemplateReference(UPDATE_TYPE.SYS_TEMPLATE);
    }

    public boolean askForAddress() {
        return this.askForAddress;
    }

    public void setAskForAddress(boolean askForAddress) {
        this.askForAddress = askForAddress;
        this.updateTemplateReference(UPDATE_TYPE.ADDRESS);
    }

    private void updateTemplateReference(UPDATE_TYPE updateType) {
        Brief bt = this.getTemplate();
        if (bt != null) {
            switch (updateType) {
                case MANDANT: {
                    bt.setAdressat(this.mandantId);
                    break;
                }
                case ADDRESS: {
                    DocumentSelectDialog.setDontAskForAddresseeForThisTemplate(bt, !this.askForAddress);
                    break;
                }
                case SYS_TEMPLATE: {
                    String sysTemplate = this.systemTemplate ? "SYS" : "";
                    bt.set("BehandlungsID", sysTemplate);
                    break;
                }
            }
        }
    }

    public void prepareRewrite() {
        IDocumentTemplate documentTemplate = CoreModelServiceHolder.get().load(this.templateId, IDocumentTemplate.class).orElse(null);
        if (documentTemplate != null) {
            try {
                this.documentContent = IOUtils.toByteArray((InputStream)documentTemplate.getContent());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error caching template content");
            }
        }
    }

    public void rewrite() {
        IDocumentTemplate documentTemplate = CoreModelServiceHolder.get().load(this.templateId, IDocumentTemplate.class).orElse(null);
        if (documentTemplate != null && this.documentContent != null) {
            documentTemplate.setContent(null);
            documentTemplate.setContent((InputStream)new ByteArrayInputStream(this.documentContent));
            this.documentContent = null;
        }
    }

    private void updateConfigTemplateBase() {
        String type = MimeTypeUtil.getSimpleName(this.mimeType);
        if (this.printer != null) {
            this.removePrintSettings();
        }
        this.cfgTemplateBase = this.systemTemplate || this.mandantId == null || this.mandantId.isEmpty() ? "texttemplates/public/" + type + "/" + this.name : "texttemplates/private/" + this.mandantId + "/" + type + "/" + this.name;
        if (this.printer != null) {
            this.setPrinter(this.printer);
        }
        if (this.tray != null) {
            this.setTray(this.tray);
        }
    }

    public static Brief findExistingTemplate(String name, String mandantId) {
        Query qbe = new Query(Brief.class);
        qbe.add("Typ", "=", "Vorlagen");
        qbe.and();
        qbe.add("Betreff", "=", name);
        qbe.startGroup();
        if (mandantId != null) {
            qbe.add("DestID", "=", mandantId);
            qbe.or();
        }
        qbe.add("DestID", "=", "");
        qbe.endGroup();
        List list = qbe.execute();
        Brief ret = null;
        if (list != null && !list.isEmpty()) {
            ret = (Brief)list.get(0);
            if (list.size() > 1 && mandantId != null) {
                for (Brief brief : list) {
                    if (mandantId.equals(brief.get("DestID"))) {
                        ret = brief;
                        break;
                    }
                    if (ret != null || !StringUtils.isEmpty((CharSequence)brief.get("DestID"))) continue;
                    ret = brief;
                }
            }
        }
        return ret;
    }

    public static List<Brief> findExistingTemplates(boolean isSysTemplate, String name, String mimeType, String mandantId) {
        Query qbe = new Query(Brief.class);
        qbe.add("Betreff", "=", name);
        qbe.add("Typ", "=", "Vorlagen");
        if (mimeType != null) {
            qbe.add("MimeType", "=", mimeType);
        }
        if (isSysTemplate) {
            qbe.add("BehandlungsID", "=", "SYS");
        } else {
            qbe.add("BehandlungsID", "<>", "SYS");
        }
        if (mandantId != null) {
            qbe.add("DestID", "=", mandantId);
        } else {
            qbe.startGroup();
            qbe.add("DestID", "=", "");
            qbe.or();
            qbe.addToken("DestID is NULL");
            qbe.endGroup();
        }
        return qbe.execute();
    }

    private static enum UPDATE_TYPE {
        MANDANT,
        ADDRESS,
        SYS_TEMPLATE;

    }
}

