/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;

public class MediVerlaufView
extends ViewPart
implements IActivationListener {
    TableViewer tv;
    ArrayList<MediAbgabe> mListe = new ArrayList();
    private static final String[] columns = new String[]{Messages.Core_Since, Messages.Core_Date_Until, Messages.MediVerlaufView_medicament, Messages.Core_Dosage};
    private static final int[] colwidth = new int[]{90, 90, 300, 200};
    private ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            MediVerlaufView.this.reload();
        }
    };
    private static int sortCol = 0;
    private static boolean revert = false;
    public static final String TOOPEN = " ... ";
    MediSorter sorter = new MediSorter();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.tv = new TableViewer(parent, 0);
        Table table = this.tv.getTable();
        int i = 0;
        while (i < columns.length) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(columns[i]);
            tc.setWidth(colwidth[i]);
            tc.setData((Object)i);
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i = (Integer)((TableColumn)e.getSource()).getData();
                    revert = sortCol == i ? !revert : false;
                    sortCol = i;
                    MediVerlaufView.this.reload();
                }
            });
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tv.setUseHashlookup(true);
        this.tv.setContentProvider((IContentProvider)new MediVerlaufContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new MediVerlaufLabelProvider());
        GlobalEventDispatcher.addActivationListener(this, this.getViewSite().getPart());
        this.tv.setSorter((ViewerSorter)this.sorter);
        this.tv.setInput((Object)this.getViewSite());
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, this.getViewSite().getPart());
    }

    public void setFocus() {
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
    }

    public void reload() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Patient sp = ElexisEventDispatcher.getSelectedPatient();
                    if (sp == null) {
                        return;
                    }
                    monitor.beginTask(Messages.MediVerlaufView_reading, -1);
                    monitor.subTask(Messages.MediVerlaufView_findPrescriptions);
                    Query qbe = new Query(Prescription.class);
                    qbe.add("PatientID", "=", sp.getId());
                    List list = qbe.execute();
                    MediVerlaufView.this.mListe.clear();
                    monitor.subTask(Messages.MediVerlaufView_findMedicaments);
                    try {
                        for (Prescription p : list) {
                            SortedMap terms = p.getTerms();
                            TimeTool[] tts = terms.keySet().toArray(new TimeTool[0]);
                            int i = 0;
                            while (i < tts.length - 1) {
                                if (i < tts.length - 1) {
                                    MediVerlaufView.this.mListe.add(new MediAbgabe(tts[i].toString(4), tts[i + 1].toString(4), p));
                                } else {
                                    MediVerlaufView.this.mListe.add(new MediAbgabe(tts[i].toString(4), MediVerlaufView.TOOPEN, p));
                                }
                                ++i;
                            }
                            MediVerlaufView.this.mListe.add(new MediAbgabe(tts[tts.length - 1].toString(4), MediVerlaufView.TOOPEN, p));
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                    }
                    MediVerlaufView.this.tv.refresh();
                    monitor.done();
                }
            }, null);
        }
        catch (Throwable ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    public void selectionEvent(PersistentObject obj) {
        if (obj instanceof Patient) {
            this.reload();
        }
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
            this.reload();
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    private static class MediAbgabe
    implements Comparable<MediAbgabe> {
        String von;
        String bis;
        String medi;
        String dosis;
        private static TimeTool compare = new TimeTool();
        private static TimeTool compareTo = new TimeTool();

        MediAbgabe(String v, String b, Prescription p) {
            this.von = v;
            this.bis = b;
            this.medi = p.getSimpleLabel();
            this.dosis = p.getDosis();
        }

        @Override
        public int compareTo(MediAbgabe o) {
            int ret = 0;
            switch (sortCol) {
                case 0: {
                    compare.set(this.von);
                    compareTo.set(o.von);
                    ret = compare.compareTo((Calendar)compareTo);
                    break;
                }
                case 1: {
                    if (this.bis.equals(MediVerlaufView.TOOPEN) && !o.bis.equals(MediVerlaufView.TOOPEN)) {
                        ret = 1;
                        break;
                    }
                    if (!this.bis.equals(MediVerlaufView.TOOPEN) && o.bis.equals(MediVerlaufView.TOOPEN)) {
                        ret = -1;
                        break;
                    }
                    if (this.bis.equals(MediVerlaufView.TOOPEN) && o.bis.equals(MediVerlaufView.TOOPEN)) {
                        ret = 0;
                        break;
                    }
                    compare.set(this.bis);
                    compareTo.set(o.bis);
                    ret = compare.compareTo((Calendar)compareTo);
                    break;
                }
                case 2: {
                    ret = this.medi.compareTo(o.medi);
                    break;
                }
                case 3: {
                    ret = this.dosis.compareTo(o.dosis);
                }
            }
            if (revert) {
                if (ret > 0) {
                    ret = -1;
                } else if (ret < 0) {
                    ret = 1;
                }
            }
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MediAbgabe) {
                return this.compareTo((MediAbgabe)obj) == 0;
            }
            return false;
        }
    }

    private static class MediSorter
    extends ViewerSorter {
        private MediSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return ((MediAbgabe)e1).compareTo((MediAbgabe)e2);
        }
    }

    class MediVerlaufContentProvider
    implements IStructuredContentProvider {
        MediVerlaufContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return MediVerlaufView.this.mListe.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class MediVerlaufLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MediVerlaufLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MediAbgabe) {
                MediAbgabe ma = (MediAbgabe)element;
                switch (columnIndex) {
                    case 0: {
                        return ma.von;
                    }
                    case 1: {
                        return ma.bis;
                    }
                    case 2: {
                        return ma.medi;
                    }
                    case 3: {
                        return ma.dosis;
                    }
                }
                return "??";
            }
            return "?";
        }
    }
}

