/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.handlers;

import ch.elexis.core.ac.AccessControlDefaults;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IBillingSystemService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.dialog.UserDialog;
import ch.elexis.core.ui.e4.handlers.RestrictedHandler;
import java.time.LocalDate;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;

public class EncounterCreateHandler
extends RestrictedHandler {
    public EncounterCreateHandler() {
        super(AccessControlDefaults.KONS_CREATE);
    }

    @Execute
    public void execute(IContextService contextService, IConfigService configService, IEncounterService encounterService, IBillingSystemService billingSystemService) {
        ICoverage coverage = contextService.getActiveCoverage().orElse(null);
        if (coverage == null) {
            Object coverages;
            IPatient patient = contextService.getActivePatient().orElse(null);
            if (patient == null) {
                UserDialog.error(Messages.GlobalActions_CantCreateKons, Messages.GlobalActions_DoSelectCase);
                return;
            }
            IEncounter latestEncounter = encounterService.getLatestEncounter(patient).orElse(null);
            coverage = latestEncounter != null ? latestEncounter.getCoverage() : (!(coverages = patient.getCoverages()).isEmpty() ? (ICoverage)coverages.get(0) : new ICoverageBuilder(CoreModelServiceHolder.get(), configService, billingSystemService, patient).buildAndSave());
        }
        if (!coverage.isOpen()) {
            UserDialog.error(Messages.GlobalActions_casclosed, Messages.Core_Cannot_add_consultation_to_closed_case);
            return;
        }
        List encounters = coverage.getEncounters();
        for (IEncounter iEncounter : encounters) {
            if (!LocalDate.now().equals(iEncounter.getDate()) || UserDialog.question(Messages.GlobalActions_SecondForToday, Messages.GlobalActions_SecondForTodayQuestion)) continue;
            return;
        }
        IMandator mandator = contextService.getActiveMandator().orElse(null);
        if (mandator == null) {
            UserDialog.error("No mandator selected", "Encounter creation requires a mandator");
            return;
        }
        IEncounter enounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, mandator).buildAndSave();
        encounterService.addDefaultDiagnosis(enounter);
        contextService.getRootContext().setTyped((Object)enounter);
    }
}

