/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Eigenleistung;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.ModelUtil;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.rgw.tools.Money;
import org.apache.commons.lang3.StringUtils;

public class CustomService
extends AbstractIdDeleteModelAdapter<Eigenleistung>
implements IdentifiableWithXid,
ICustomService {
    private static IBillableOptifier<CustomService> optifier;
    private static IBillableVerifier verifier;
    private static Money noMoney;

    static {
        noMoney = new Money();
    }

    public CustomService(Eigenleistung entity) {
        super((EntityWithId)entity);
    }

    public Money getPrice() {
        String priceString = ((Eigenleistung)this.getEntity()).getSalePrice();
        if (priceString != null) {
            if (StringUtils.isNumeric((CharSequence)priceString)) {
                return ModelUtil.getMoneyForCentString((String)priceString).orElse(noMoney);
            }
            if (priceString.matches("[0-9\\.]+")) {
                return ModelUtil.getMoneyForPriceString((String)priceString).orElse(noMoney);
            }
        }
        return noMoney;
    }

    public void setPrice(Money value) {
        ((Eigenleistung)this.getEntityMarkDirty()).setSalePrice(value.getCentsAsString());
    }

    public Money getNetPrice() {
        String priceString = ((Eigenleistung)this.getEntity()).getBasePrice();
        if (StringUtils.isNumeric((CharSequence)priceString)) {
            return ModelUtil.getMoneyForCentString((String)priceString).orElse(noMoney);
        }
        if (priceString.matches("[0-9\\.]+")) {
            return ModelUtil.getMoneyForPriceString((String)priceString).orElse(noMoney);
        }
        return noMoney;
    }

    public void setNetPrice(Money value) {
        ((Eigenleistung)this.getEntityMarkDirty()).setBasePrice(value.getCentsAsString());
    }

    public synchronized IBillableOptifier<CustomService> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<CustomService>(CoreModelServiceHolder.get(), ContextServiceHolder.get()){

                protected void setPrice(CustomService billable, IBilled billed) {
                    billed.setFactor(1.0);
                    billed.setNetPrice(billable.getNetPrice());
                    billed.setPoints(billable.getPrice().getCents());
                }
            };
        }
        return optifier;
    }

    public synchronized IBillableVerifier getVerifier() {
        if (verifier == null) {
            verifier = new DefaultVerifier();
        }
        return verifier;
    }

    public String getCodeSystemName() {
        return "Eigenleistung";
    }

    public String getCode() {
        String ret = ((Eigenleistung)this.getEntity()).getCode();
        if (ret == null || ret.isEmpty()) {
            ret = this.getId();
        }
        return ret;
    }

    public void setCode(String value) {
        ((Eigenleistung)this.getEntityMarkDirty()).setCode(value);
    }

    public String getText() {
        return ((Eigenleistung)this.getEntity()).getDescription();
    }

    public void setText(String value) {
        ((Eigenleistung)this.getEntityMarkDirty()).setDescription(value);
    }

    public String getLabel() {
        return this.getText();
    }

    public int getMinutes() {
        return ((Eigenleistung)this.getEntity()).getTime();
    }

    public void setMinutes(int value) {
        ((Eigenleistung)this.getEntityMarkDirty()).setTime(value);
    }
}

