/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.pdfbox.ui.parts;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.pdfbox.ui.parts.PdfPreviewPartLoadHandler;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.LoggerFactory;

public class PdfPreviewPart {
    @Inject
    private IConfigService configService;
    private Composite previewComposite;
    private ScrolledComposite scrolledComposite;
    private PdfPreviewPartLoadHandler pdfPreviewPartLoadHandler;

    @PostConstruct
    public void postConstruct(Composite parent) throws IOException {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.previewComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.previewComposite);
        this.previewComposite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(this.previewComposite, 0);
        label.setText(Messages.PdfPreview_NoPDFSelected);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.previewComposite.computeSize(-1, -1));
    }

    @Inject
    @Optional
    void activePatient(IPatient patient) throws IOException {
        if (this.pdfPreviewPartLoadHandler != null) {
            this.pdfPreviewPartLoadHandler.unloadDocument();
            this.updatePreview((InputStream)null);
        }
    }

    @Inject
    @Optional
    void updatePreview(@UIEventTopic(value="ui/preview/mimetype/application/pdf") IDocument pdfIDocument) {
        this.updatePreview(pdfIDocument != null ? pdfIDocument.getContent() : null);
    }

    private void updatePreview(InputStream pdfInputStream) {
        if (this.pdfPreviewPartLoadHandler != null) {
            if (pdfInputStream == null) {
                try {
                    this.pdfPreviewPartLoadHandler.unloadDocument();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Error unloading document", (Throwable)e);
                }
            }
            this.pdfPreviewPartLoadHandler.close();
        }
        String zoomLevel = this.configService.getActiveUserContact("pdfPreviewPart/defaultZoomLevel", "1.2f");
        this.pdfPreviewPartLoadHandler = new PdfPreviewPartLoadHandler(pdfInputStream, Float.valueOf(zoomLevel), this.previewComposite, this.scrolledComposite);
    }

    public void changeScalingFactor(Float _zoomLevel) {
        this.pdfPreviewPartLoadHandler.changeScalingFactor(_zoomLevel);
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

