/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.service;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IClinicalImpression;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.IProcedureRequest;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.codes.ICodingService;
import ch.elexis.core.findings.templates.model.CodeElement;
import ch.elexis.core.findings.templates.model.DataType;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputData;
import ch.elexis.core.findings.templates.model.InputDataBoolean;
import ch.elexis.core.findings.templates.model.InputDataDate;
import ch.elexis.core.findings.templates.model.InputDataGroup;
import ch.elexis.core.findings.templates.model.InputDataGroupComponent;
import ch.elexis.core.findings.templates.model.InputDataNumeric;
import ch.elexis.core.findings.templates.model.InputDataText;
import ch.elexis.core.findings.templates.model.ModelFactory;
import ch.elexis.core.findings.templates.model.Type;
import ch.elexis.core.findings.templates.service.IFindingsTemplateService;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.data.Patient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class FindingsTemplateService
implements IFindingsTemplateService {
    private static final String FINDINGS_TEMPLATE_ID_PREFIX = "Findings_Template_";
    @Reference
    private IFindingsService findingsService;
    @Reference
    private ICodingService codingService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    public FindingsTemplates getFindingsTemplates(String templateId) {
        Optional<FindingsTemplates> loaded;
        Assert.isNotNull((Object)templateId);
        templateId = templateId.replaceAll(" ", "_");
        Optional blob = this.coreModelService.load(FINDINGS_TEMPLATE_ID_PREFIX + templateId, IBlob.class);
        if (blob.isPresent() && (loaded = this.loadFindingsTemplates((IBlob)blob.get())).isPresent()) {
            ECollections.sort((EList)loaded.get().getFindingsTemplates(), (l, r) -> {
                if (l == null || r == null) {
                    return l != null ? 1 : -1;
                }
                return ObjectUtils.compare((Comparable)((Object)l.getTitle()), (Comparable)((Object)r.getTitle()));
            });
            return loaded.get();
        }
        ModelFactory factory = ModelFactory.eINSTANCE;
        FindingsTemplates findingsTemplates = factory.createFindingsTemplates();
        findingsTemplates.setId(FINDINGS_TEMPLATE_ID_PREFIX + templateId);
        findingsTemplates.setTitle("Standard Vorlagen");
        return findingsTemplates;
    }

    private Optional<FindingsTemplates> loadFindingsTemplates(IBlob iBlob) {
        String stringContent = iBlob.getStringContent();
        if (stringContent != null && !stringContent.isEmpty()) {
            try {
                Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
                Map m = reg.getExtensionToFactoryMap();
                m.put("xmi", new XMIResourceFactoryImpl());
                ResourceSetImpl resSet = new ResourceSetImpl();
                Resource resource = resSet.createResource(URI.createURI((String)"findingsTemplate.xml"));
                resource.load((InputStream)new URIConverter.ReadableInputStream(stringContent), null);
                return Optional.ofNullable((FindingsTemplates)resource.getContents().get(0));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(FindingsTemplateService.class).error("read findings templates error", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private String createXMI(FindingsTemplates findingsTemplates) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xmi", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createURI((String)"findingsTemplate.xml"));
        resource.getContents().add((Object)findingsTemplates);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            resource.save((OutputStream)os, Collections.EMPTY_MAP);
            os.flush();
            String aString = new String(os.toByteArray(), "UTF-8");
            os.close();
            return aString;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(FindingsTemplateService.class).error("", (Throwable)e);
            return null;
        }
    }

    public String saveFindingsTemplates(Optional<FindingsTemplates> findingsTemplates) {
        if (findingsTemplates.isPresent()) {
            String xmi = this.createXMI(findingsTemplates.get());
            String id = findingsTemplates.get().getId();
            this.saveXmiToNamedBlob(xmi, id);
            return xmi;
        }
        return null;
    }

    private void saveXmiToNamedBlob(String xmi, String blobId) {
        if (xmi != null && blobId != null) {
            IBlob blob = this.coreModelService.load(blobId, IBlob.class).orElse(null);
            if (blob == null) {
                blob = (IBlob)this.coreModelService.create(IBlob.class);
                blob.setId(blobId);
            }
            blob.setStringContent(xmi);
            this.coreModelService.save((Identifiable)blob);
        } else {
            LoggerFactory.getLogger(FindingsTemplateService.class).warn("cannot save template - xmi string is null");
        }
    }

    public void exportTemplateToFile(FindingsTemplates findingsTemplates, String path) throws IOException {
        if (findingsTemplates != null) {
            File toExport = new File(path);
            String content = this.saveFindingsTemplates(Optional.of(findingsTemplates));
            if (content != null) {
                FileUtils.writeStringToFile((File)toExport, (String)content);
            }
        }
    }

    public FindingsTemplates importTemplateFromFile(String path) throws IOException {
        if (path != null) {
            File toImport = new File(path);
            String xmi = FileUtils.readFileToString((File)toImport);
            this.saveXmiToNamedBlob(xmi, FINDINGS_TEMPLATE_ID_PREFIX + "Standard Vorlagen".replaceAll(" ", "_"));
            return this.getFindingsTemplates("Standard Vorlagen");
        }
        return null;
    }

    public void addComponent(IFinding iFinding, FindingsTemplate findingsTemplate) {
        if (iFinding instanceof IObservation) {
            IObservation iObservation = (IObservation)iFinding;
            ObservationComponent component = new ObservationComponent(UUID.randomUUID().toString());
            component.setCoding(this.initCodings(component.getCoding(), findingsTemplate));
            if (findingsTemplate.getInputData() instanceof InputDataNumeric) {
                InputDataNumeric inputDataNumeric = (InputDataNumeric)findingsTemplate.getInputData();
                component.setNumericValue(null);
                component.setNumericValueUnit(inputDataNumeric.getUnit());
            }
            if (findingsTemplate.getInputData() instanceof InputDataText) {
                component.setStringValue(null);
            }
            iObservation.addComponent(component);
        }
    }

    public IFinding createFinding(Patient patient, FindingsTemplate findingsTemplate) throws ElexisException {
        IClinicalImpression iFinding = null;
        if (patient != null && patient.exists()) {
            this.validateCycleDetection(findingsTemplate, 0, 100);
            Type type = findingsTemplate.getType();
            switch (type) {
                case CONDITION: {
                    ICondition iCondition = this.create(ICondition.class);
                    iCondition.setCategory(ICondition.ConditionCategory.PROBLEMLISTITEM);
                    iFinding = iCondition;
                    this.setFindingsAttributes((IFinding)iFinding, patient, findingsTemplate);
                    break;
                }
                case EVALUATION: {
                    iFinding = this.create(IClinicalImpression.class);
                    this.setFindingsAttributes((IFinding)iFinding, patient, findingsTemplate);
                    break;
                }
                case OBSERVATION_VITAL: {
                    iFinding = this.createObservation(patient, findingsTemplate);
                    this.setFindingsAttributes((IFinding)iFinding, patient, findingsTemplate);
                    break;
                }
                case PROCEDURE: {
                    iFinding = this.create(IProcedureRequest.class);
                    this.setFindingsAttributes((IFinding)iFinding, patient, findingsTemplate);
                    break;
                }
            }
        } else {
            throw new ElexisException("Kein Patient ausgew\u00e4hlt.");
        }
        return iFinding;
    }

    private List<ICoding> initCodings(List<ICoding> codes, FindingsTemplate findingsTemplate) {
        String localCode = findingsTemplate.getTitle();
        Optional<ICoding> iLocalCoding = this.getOrCreateCode(localCode, CodingSystem.ELEXIS_LOCAL_CODESYSTEM, true);
        if (iLocalCoding.isPresent()) {
            CodeElement codeElement;
            Optional<ICoding> loincCode;
            if (findingsTemplate.getCodeElement() != null && (loincCode = this.getOrCreateCode((codeElement = findingsTemplate.getCodeElement()).getCode(), CodingSystem.LOINC_CODESYSTEM, false)).isPresent()) {
                codes.add(loincCode.get());
                if (iLocalCoding.get() instanceof ILocalCoding) {
                    ILocalCoding localCoding = (ILocalCoding)iLocalCoding.get();
                    ArrayList<ICoding> mappedCodes = new ArrayList<ICoding>();
                    mappedCodes.add(loincCode.get());
                    localCoding.setMappedCodes(mappedCodes);
                }
            }
            codes.add(iLocalCoding.get());
        }
        return codes;
    }

    private Optional<ICoding> getOrCreateCode(final String code, final CodingSystem codingSystem, boolean createCodeIfNotExists) {
        if (createCodeIfNotExists) {
            this.codingService.addLocalCoding(new ICoding(){

                public String getSystem() {
                    return codingSystem.getSystem();
                }

                public String getDisplay() {
                    return code;
                }

                public String getCode() {
                    return code;
                }
            });
        }
        return this.codingService.getCode(codingSystem.getSystem(), code);
    }

    public Optional<ICoding> findOneCode(List<ICoding> coding, CodingSystem codingSystem) {
        for (ICoding iCoding : coding) {
            if (!codingSystem.getSystem().equals(iCoding.getSystem())) continue;
            return Optional.of(iCoding);
        }
        return Optional.empty();
    }

    private void setFindingsAttributes(IFinding iFinding, Patient patient, FindingsTemplate findingsTemplate) {
        if (iFinding != null) {
            iFinding.setPatientId(patient.getId());
            String text = findingsTemplate.getTitle();
            if (iFinding instanceof IObservation) {
                IObservation iObservation = (IObservation)iFinding;
                List codings = iObservation.getCoding();
                iObservation.setCoding(this.initCodings(codings, findingsTemplate));
            } else {
                iFinding.setText(text);
            }
        }
    }

    public void validateCycleDetection(FindingsTemplate findingsTemplate, int depth, int maxDepth) throws ElexisException {
        block4: {
            InputData inputData;
            block3: {
                if (++depth > maxDepth) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Es trat ein Fehler in der Vorlage auf.\n");
                    builder.append("Die maximale Komplexit\u00e4t von ");
                    builder.append(maxDepth);
                    builder.append(" wurde \u00fcberschritten.");
                    builder.append("\n\n");
                    builder.append("Bitte \u00fcberpr\u00fcfen Sie ihre Vorlage '");
                    builder.append(findingsTemplate.getTitle());
                    builder.append("' auf Zyklen, oder verringern Sie die Komplexit\u00e4t.");
                    throw new ElexisException(builder.toString());
                }
                inputData = findingsTemplate.getInputData();
                if (!(inputData instanceof InputDataGroup)) break block3;
                InputDataGroup group = (InputDataGroup)inputData;
                for (FindingsTemplate item : group.getFindingsTemplates()) {
                    this.validateCycleDetection(item, depth, maxDepth);
                }
                break block4;
            }
            if (!(inputData instanceof InputDataGroupComponent)) break block4;
            InputDataGroupComponent group = (InputDataGroupComponent)inputData;
            for (FindingsTemplate item : group.getFindingsTemplates()) {
                this.validateCycleDetection(item, depth, maxDepth);
            }
        }
    }

    private IFinding createObservation(Patient patient, FindingsTemplate findingsTemplate) throws ElexisException {
        IObservation iObservation = this.create(IObservation.class);
        iObservation.setEffectiveTime(LocalDateTime.now());
        switch (findingsTemplate.getType()) {
            case OBSERVATION_VITAL: {
                iObservation.setCategory(IObservation.ObservationCategory.VITALSIGNS);
                break;
            }
        }
        InputData inputData = findingsTemplate.getInputData();
        if (inputData instanceof InputDataGroup) {
            iObservation.setObservationType(IObservation.ObservationType.REF);
            InputDataGroup group = (InputDataGroup)inputData;
            for (FindingsTemplate findingsTemplates : group.getFindingsTemplates()) {
                IFinding iFinding = this.createFinding(patient, findingsTemplates);
                if (!(iFinding instanceof IObservation)) continue;
                IObservation target = (IObservation)iFinding;
                target.setReferenced(true);
                iObservation.addTargetObservation(target, IObservationLink.ObservationLinkType.REF);
            }
        } else if (inputData instanceof InputDataGroupComponent) {
            iObservation.setObservationType(IObservation.ObservationType.COMP);
            InputDataGroupComponent group = (InputDataGroupComponent)inputData;
            iObservation.addFormat("textSeparator", group.getTextSeparator());
            for (FindingsTemplate findingsTemplates : group.getFindingsTemplates()) {
                this.addComponent((IFinding)iObservation, findingsTemplates);
            }
        } else if (inputData instanceof InputDataNumeric) {
            iObservation.setObservationType(IObservation.ObservationType.NUMERIC);
            InputDataNumeric inputDataNumeric = (InputDataNumeric)inputData;
            iObservation.setNumericValue(null, inputDataNumeric.getUnit());
            iObservation.setDecimalPlace(inputDataNumeric.getDecimalPlace());
            String script = ((InputDataNumeric)inputData).getScript();
            if (script != null && !script.isEmpty()) {
                iObservation.setScript(script);
            }
        } else if (inputData instanceof InputDataText) {
            iObservation.setObservationType(IObservation.ObservationType.TEXT);
        } else if (inputData instanceof InputDataBoolean) {
            iObservation.setObservationType(IObservation.ObservationType.BOOLEAN);
        } else if (inputData instanceof InputDataDate) {
            iObservation.setObservationType(IObservation.ObservationType.DATE);
        }
        return iObservation;
    }

    public <T extends IFinding> T create(Class<T> clazz) {
        return (T)this.findingsService.create(clazz);
    }

    public List<IFinding> getFindings(Patient patient) {
        if (patient != null && patient.exists()) {
            String patientId = patient.getId();
            List<IFinding> items = this.getObservations(patientId);
            return items;
        }
        return Collections.emptyList();
    }

    private List<IFinding> getObservations(String patientId) {
        return this.findingsService.getPatientsFindings(patientId, IObservation.class).stream().filter(item -> {
            IObservation iObservation = item;
            IObservation.ObservationCategory category = iObservation.getCategory();
            if (category == IObservation.ObservationCategory.VITALSIGNS || category == IObservation.ObservationCategory.SOAP_SUBJECTIVE || category == IObservation.ObservationCategory.SOAP_OBJECTIVE) {
                return !iObservation.isReferenced();
            }
            return false;
        }).collect(Collectors.toList());
    }

    public Type getType(IFinding iFinding) {
        if (iFinding instanceof IObservation) {
            if (((IObservation)iFinding).getCategory() == IObservation.ObservationCategory.SOAP_SUBJECTIVE) {
                return Type.OBSERVATION_VITAL;
            }
            if (((IObservation)iFinding).getCategory() == IObservation.ObservationCategory.SOAP_OBJECTIVE) {
                return Type.OBSERVATION_VITAL;
            }
            if (((IObservation)iFinding).getCategory() == IObservation.ObservationCategory.VITALSIGNS) {
                return Type.OBSERVATION_VITAL;
            }
        } else if (iFinding instanceof ICondition) {
            if (((ICondition)iFinding).getCategory() == ICondition.ConditionCategory.PROBLEMLISTITEM) {
                return Type.CONDITION;
            }
        } else {
            if (iFinding instanceof IClinicalImpression) {
                return Type.EVALUATION;
            }
            if (iFinding instanceof IProcedureRequest) {
                return Type.PROCEDURE;
            }
        }
        return null;
    }

    public String getTypeAsText(Type type) {
        if (type != null) {
            switch (type) {
                case CONDITION: {
                    return "Problem";
                }
                case EVALUATION: {
                    return "Beurteilung";
                }
                case OBSERVATION_VITAL: {
                    return "Beobachtung Vitalzeichen";
                }
                case PROCEDURE: {
                    return "Prozedere";
                }
            }
        }
        return "";
    }

    public String getDataTypeAsText(DataType dataType) {
        switch (dataType) {
            case GROUP: {
                return "Gruppe";
            }
            case GROUP_COMPONENT: {
                return "Komponent";
            }
            case NUMERIC: {
                return "Numerisch";
            }
            case TEXT: {
                return "Text";
            }
            case BOOLEAN: {
                return "Checkbox";
            }
            case DATE: {
                return "Datum";
            }
        }
        return "";
    }

    public Optional<FindingsTemplate> getFindingsTemplate(ICoding localCode) {
        IQuery query = this.coreModelService.getQuery(IBlob.class);
        query.and("id", IQuery.COMPARATOR.LIKE, (Object)"Findings_Template_%");
        List templatesBlobs = query.execute();
        for (IBlob iBlob : templatesBlobs) {
            Optional<FindingsTemplates> templates = this.loadFindingsTemplates(iBlob);
            if (!templates.isPresent()) continue;
            for (FindingsTemplate template : templates.get().getFindingsTemplates()) {
                if (template.getCodeElement() == null || !localCode.getSystem().equals(template.getCodeElement().getSystem()) || !localCode.getCode().equals(template.getCodeElement().getCode())) continue;
                return Optional.of(template);
            }
            for (FindingsTemplate template : templates.get().getFindingsTemplates()) {
                if (!template.getTitle().equals(localCode.getCode())) continue;
                return Optional.of(template);
            }
        }
        return Optional.empty();
    }
}

