/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.findings.ui.views.CodesSelectionComposite;
import ch.elexis.core.findings.ui.views.ObservationLabelProvider;
import ch.elexis.core.findings.ui.views.nattable.DragAndDropSupport;
import ch.elexis.core.findings.ui.views.nattable.DynamicCodingHeaderDataProvider;
import ch.elexis.core.findings.ui.views.nattable.DynamicCodingRowDataProvider;
import ch.elexis.core.findings.ui.views.nattable.DynamicDataProvider;
import ch.elexis.core.findings.ui.views.nattable.DynamicDateHeaderDataProvider;
import ch.elexis.core.findings.ui.views.nattable.DynamicDateRowDataProvider;
import ch.elexis.core.findings.ui.views.nattable.FindingsNatTableTooltip;
import ch.elexis.core.findings.ui.views.nattable.LabelDataProvider;
import ch.elexis.core.findings.ui.views.nattable.NatTableWrapper;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class FindingsViewDynamic
extends ViewPart
implements IActivationListener {
    private CodesSelectionComposite codeSelectionComposite;
    private NatTable natTable;
    private DynamicDataProvider dataProvider;
    private IDataProvider headerDataProvider;
    private IDataProvider rowDataProvider;
    private final ElexisUiEventListenerImpl eeli_find = new ElexisUiEventListenerImpl(IFinding.class, 11){

        public void runInUi(ElexisEvent ev) {
            FindingsViewDynamic.this.refresh();
        }
    };
    private final ElexisUiEventListenerImpl eeli_code = new ElexisUiEventListenerImpl(ICoding.class, 11){

        public void runInUi(ElexisEvent ev) {
            FindingsViewDynamic.this.codeRefresh();
        }
    };
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            FindingsViewDynamic.this.refresh();
        }
    };
    private NatTableWrapper wrapper;

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)SWTHelper.createGridLayout((boolean)true, (int)1));
        this.codeSelectionComposite = new CodesSelectionComposite(main, 0);
        this.codeSelectionComposite.setLayoutData(new GridData(4, 128, true, false));
        this.dataProvider = new DynamicDataProvider();
        if (ConfigServiceHolder.getGlobal((String)"findingsui/settings/rowsaredates", (boolean)false)) {
            this.dataProvider.setRowsAreDates(true);
            this.headerDataProvider = new DynamicCodingHeaderDataProvider(this.dataProvider);
            this.rowDataProvider = new DynamicDateRowDataProvider(this.dataProvider);
        } else {
            this.dataProvider.setRowsAreDates(false);
            this.headerDataProvider = new DynamicDateHeaderDataProvider(this.dataProvider);
            this.rowDataProvider = new DynamicCodingRowDataProvider(this.dataProvider);
        }
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)new LabelDataProvider(this.dataProvider, new ObservationLabelProvider()));
        bodyDataLayer.setColumnPercentageSizing(true);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer){
            private CellLayerPainter painter;
            {
                this.painter = new CellLayerPainter();
            }

            public ILayerPainter getLayerPainter() {
                return this.painter;
            }
        };
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DataLayer columnHeaderDataLayer = new DataLayer(this.headerDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DataLayer rowHeaderDataLayer = new DataLayer(this.rowDataProvider, 150, 20);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(this.headerDataProvider, this.rowDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.natTable = new NatTable(main, 538184448, (ILayer)gridLayer, false);
        this.natTable.setBackground(this.natTable.getDisplay().getSystemColor(1));
        this.natTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.wrapper = new NatTableWrapper(this.natTable, this.dataProvider, selectionLayer);
        this.wrapper.addContextMenu("ch.elexis.core.findings.ui.views.FindingsView", this.getSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.wrapper);
        this.wrapper.configure();
        this.natTable.setTheme((ThemeConfiguration)new ModernNatTableThemeConfiguration());
        this.codeSelectionComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                FindingsViewDynamic.this.updateCodingsSelection(selection);
            }
        });
        this.updateCodingsSelection((StructuredSelection)this.codeSelectionComposite.getSelection());
        this.wrapper.addDoubleClickListener(new NatTableWrapper.IDoubleClickListener(){

            @Override
            public void doubleClick(NatTableWrapper source, ISelection selection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                if (!structuredSelection.isEmpty()) {
                    for (Object o : structuredSelection.toList()) {
                        if (!(o instanceof IFinding)) continue;
                        FindingsUiUtil.executeCommand("ch.elexis.core.findings.ui.commandEdit", (IFinding)o);
                    }
                }
            }
        });
        DragAndDropSupport dndSupport = new DragAndDropSupport(this.wrapper);
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        this.natTable.addDragSupport(1, transfer, (DragSourceListener)dndSupport);
        this.atachTooltip();
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_find, this.eeli_code});
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.refresh();
    }

    public void setRowsAreDates(boolean value) {
        if (this.dataProvider.isRowsAreDates() != value) {
            this.dataProvider.setRowsAreDates(value);
            if (value) {
                this.headerDataProvider = new DynamicCodingHeaderDataProvider(this.dataProvider);
                this.rowDataProvider = new DynamicDateRowDataProvider(this.dataProvider);
            } else {
                this.headerDataProvider = new DynamicDateHeaderDataProvider(this.dataProvider);
                this.rowDataProvider = new DynamicCodingRowDataProvider(this.dataProvider);
            }
        }
    }

    private void atachTooltip() {
        FindingsNatTableTooltip toolTip = new FindingsNatTableTooltip(this.natTable, this.dataProvider);
        toolTip.setPopupDelay(250);
        toolTip.activate();
        toolTip.setShift(new Point(10, 10));
    }

    private void updateCodingsSelection(StructuredSelection selection) {
        List<ICoding> shownCodings = selection.toList();
        shownCodings = this.expandGroups(shownCodings);
        shownCodings.sort(new Comparator<ICoding>(){

            @Override
            public int compare(ICoding arg0, ICoding arg1) {
                if (arg0 instanceof ILocalCoding && arg1 instanceof ILocalCoding) {
                    ILocalCoding left = (ILocalCoding)arg0;
                    ILocalCoding right = (ILocalCoding)arg1;
                    return Integer.valueOf(left.getPrio()).compareTo(right.getPrio());
                }
                return 0;
            }
        });
        this.dataProvider.setShownCodings(shownCodings);
        this.natTable.refresh(true);
    }

    private List<ICoding> expandGroups(List<ICoding> codings) {
        ArrayList<ICoding> ret = new ArrayList<ICoding>();
        for (ICoding iCoding : codings) {
            if (FindingsUiUtil.isCodingForGroup(iCoding)) {
                List<ICoding> codesOfGroup = FindingsUiUtil.getCodesOfGroup(iCoding);
                for (ICoding codeOfGroup : codesOfGroup) {
                    if (ret.contains(codeOfGroup)) continue;
                    ret.add(codeOfGroup);
                }
                continue;
            }
            ret.add(iCoding);
        }
        return ret;
    }

    public void refresh() {
        this.dataProvider.reload(ElexisEventDispatcher.getSelectedPatient());
        this.natTable.refresh();
    }

    public void codeRefresh() {
        this.codeSelectionComposite.refresh();
        this.updateCodingsSelection((StructuredSelection)this.codeSelectionComposite.getSelection());
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_find, this.eeli_code});
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
    }

    public void setFocus() {
    }
}

