/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.parts.IRefreshablePart;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceActions;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListBottomComposite;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListContentProvider;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListHeaderComposite;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.rgw.io.Settings;
import ch.rgw.tools.Money;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class InvoiceListView
extends ViewPart
implements IRefreshablePart {
    public static final String ID = "ch.elexis.core.ui.views.rechnung.InvoiceListView";
    private Settings rnStellerSettings;
    private TableViewer tableViewerInvoiceList;
    private InvoiceListHeaderComposite invoiceListHeaderComposite;
    private InvoiceListBottomComposite invoiceListBottomComposite;
    private InvoiceListContentProvider invoiceListContentProvider;
    private Action reloadViewAction = new Action(Messages.Core_Reload){
        {
            this.setToolTipText(Messages.Core_Reread_List);
            this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
        }

        public void run() {
            InvoiceListView.this.refresh();
        }
    };
    private SelectionAdapter sortAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn sortColumn = InvoiceListView.this.tableViewerInvoiceList.getTable().getSortColumn();
            TableColumn selectedColumn = (TableColumn)e.widget;
            int sortDirection = InvoiceListView.this.tableViewerInvoiceList.getTable().getSortDirection();
            if (sortColumn == selectedColumn) {
                sortDirection = sortDirection == 128 ? 1024 : 128;
            } else {
                InvoiceListView.this.tableViewerInvoiceList.getTable().setSortColumn(selectedColumn);
                sortDirection = 128;
            }
            InvoiceListView.this.tableViewerInvoiceList.setComparator(null);
            InvoiceListView.this.setSortOrder(selectedColumn, sortDirection);
        }
    };
    private SelectionAdapter sortViewerAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn sortColumn = InvoiceListView.this.tableViewerInvoiceList.getTable().getSortColumn();
            TableColumn selectedColumn = (TableColumn)e.widget;
            int sortDirection = InvoiceListView.this.tableViewerInvoiceList.getTable().getSortDirection();
            if (sortColumn == selectedColumn) {
                sortDirection = sortDirection == 128 ? 1024 : 128;
            } else {
                InvoiceListView.this.tableViewerInvoiceList.getTable().setSortColumn(selectedColumn);
                sortDirection = 128;
            }
            InvoiceListView.this.tableViewerInvoiceList.getTable().setSortDirection(sortDirection);
            InvoiceListView.this.tableViewerInvoiceList.setComparator(InvoiceListView.this.sortViewerComparator);
            InvoiceListView.this.tableViewerInvoiceList.refresh();
        }
    };
    private ViewerComparator sortViewerComparator = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            TableColumn sortColumn = ((TableViewer)viewer).getTable().getSortColumn();
            int sortDirection = ((TableViewer)viewer).getTable().getSortDirection();
            if (InvoiceListView.this.tableViewerInvoiceList.getTable().indexOf(sortColumn) == 6) {
                InvoiceListContentProvider.InvoiceEntry l = (InvoiceListContentProvider.InvoiceEntry)e1;
                InvoiceListContentProvider.InvoiceEntry r = (InvoiceListContentProvider.InvoiceEntry)e2;
                this.resolve(l);
                this.resolve(r);
                String s1 = l.getReceiverLabel();
                String s2 = r.getReceiverLabel();
                return this.getComparator().compare(s1, s2) * (sortDirection == 128 ? 1 : -1);
            }
            if (InvoiceListView.this.tableViewerInvoiceList.getTable().indexOf(sortColumn) == 5) {
                InvoiceListContentProvider.InvoiceEntry l = (InvoiceListContentProvider.InvoiceEntry)e1;
                InvoiceListContentProvider.InvoiceEntry r = (InvoiceListContentProvider.InvoiceEntry)e2;
                this.resolve(l);
                this.resolve(r);
                String s1 = l.getPayerType();
                String s2 = r.getPayerType();
                return this.getComparator().compare(s1, s2) * (sortDirection == 128 ? 1 : -1);
            }
            if (InvoiceListView.this.tableViewerInvoiceList.getTable().indexOf(sortColumn) == 4) {
                InvoiceListContentProvider.InvoiceEntry l = (InvoiceListContentProvider.InvoiceEntry)e1;
                InvoiceListContentProvider.InvoiceEntry r = (InvoiceListContentProvider.InvoiceEntry)e2;
                this.resolve(l);
                this.resolve(r);
                String s1 = l.getBillingSystem();
                String s2 = r.getBillingSystem();
                return this.getComparator().compare(s1, s2) * (sortDirection == 128 ? 1 : -1);
            }
            return super.compare(viewer, e1, e2);
        }

        private void resolve(InvoiceListContentProvider.InvoiceEntry entry) {
            while (!entry.isResolved()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    };

    InvoiceListView(Settings rnStellerSettings) {
        this.rnStellerSettings = rnStellerSettings;
    }

    public InvoiceListView() {
        Mandant currMandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        this.rnStellerSettings = CoreHub.getUserSetting((Kontakt)currMandant.getRechnungssteller());
    }

    public void refresh(Map<Object, Object> filterParameters) {
        if (this.invoiceListContentProvider != null) {
            if (filterParameters.containsKey(IPatient.class)) {
                IPatient patient = (IPatient)filterParameters.get(IPatient.class);
                this.invoiceListHeaderComposite.setSelectedPatientId(Patient.load((String)patient.getId()));
            }
            if (this.tableViewerInvoiceList != null && !this.tableViewerInvoiceList.getTable().isDisposed() && this.tableViewerInvoiceList.getComparator() != null) {
                this.tableViewerInvoiceList.setComparator(null);
                this.setSortOrder(this.tableViewerInvoiceList.getTable().getColumn(3), 128);
            }
            this.invoiceListContentProvider.reload();
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.invoiceListHeaderComposite = new InvoiceListHeaderComposite(parent, 0, this);
        Composite compositeInvoiceList = new Composite(parent, 0);
        compositeInvoiceList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_compositeInvoiceList = new TableColumnLayout();
        compositeInvoiceList.setLayout((Layout)tcl_compositeInvoiceList);
        this.tableViewerInvoiceList = new TableViewer(compositeInvoiceList, 268503042);
        this.tableViewerInvoiceList.addSelectionChangedListener(selection -> {
            StructuredSelection ss = (StructuredSelection)selection.getSelection();
            if (!ss.isEmpty()) {
                InvoiceListContentProvider.InvoiceEntry firstElement = (InvoiceListContentProvider.InvoiceEntry)ss.getFirstElement();
                Rechnung load = Rechnung.load((String)firstElement.getInvoiceId());
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)load);
                Fall f = load.getFall();
                if (f != null) {
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)f.getPatient());
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)f);
                }
            }
        });
        Table tableInvoiceList = this.tableViewerInvoiceList.getTable();
        tableInvoiceList.setHeaderVisible(true);
        tableInvoiceList.setLinesVisible(false);
        this.tableViewerInvoiceList.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    InvoiceListView.this.refresh();
                }
            }
        });
        TableViewerColumn tvcInvoiceNo = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnInvoiceNo = tvcInvoiceNo.getColumn();
        tblclmnInvoiceNo.setData((Object)"InvoiceNo");
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnInvoiceNo, (ColumnLayoutData)new ColumnPixelData(50, true, true));
        tblclmnInvoiceNo.setText(Messages.InvoiceListView_tblclmnInvoiceNo_text);
        tvcInvoiceNo.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    return ((InvoiceListContentProvider.InvoiceEntry)element).getInvoiceNumber();
                }
                return super.getText(element);
            }
        });
        tblclmnInvoiceNo.addSelectionListener((SelectionListener)this.sortAdapter);
        TableViewerColumn tvcInvoiceState = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnInvoiceState = tvcInvoiceState.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnInvoiceState, (ColumnLayoutData)new ColumnPixelData(90, true, true));
        tblclmnInvoiceState.setText(Messages.Core_Invoicestate);
        tvcInvoiceState.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    return ((InvoiceListContentProvider.InvoiceEntry)element).getInvoiceState().getLocaleText();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn tvcInvoiceStateDateSince = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnInvoiceStateDateSince = tvcInvoiceStateDateSince.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnInvoiceStateDateSince, (ColumnLayoutData)new ColumnPixelData(50, true, true));
        tblclmnInvoiceStateDateSince.setText(Messages.Core_Date_Since);
        tvcInvoiceStateDateSince.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    return String.valueOf(((InvoiceListContentProvider.InvoiceEntry)element).getInvoiceStateSinceDays()) + "d";
                }
                return super.getText(element);
            }
        });
        tblclmnInvoiceStateDateSince.setData((Object)"StatusDatum");
        tblclmnInvoiceStateDateSince.addSelectionListener((SelectionListener)this.sortAdapter);
        TableViewerColumn tvcPatient = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnPatient = tvcPatient.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnPatient, (ColumnLayoutData)new ColumnWeightData(10, 100, true));
        tblclmnPatient.setText(Messages.Core_Patient);
        tblclmnPatient.setData((Object)"Bezeichnung1");
        tvcPatient.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    return ((InvoiceListContentProvider.InvoiceEntry)element).getPatientName();
                }
                return super.getText(element);
            }
        });
        tblclmnPatient.addSelectionListener((SelectionListener)this.sortAdapter);
        TableViewerColumn tvcBillingSystem = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnLaw = tvcBillingSystem.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnLaw, (ColumnLayoutData)new ColumnPixelData(50, true, true));
        tblclmnLaw.setText(Messages.Core_Law_Name);
        tvcBillingSystem.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    return ((InvoiceListContentProvider.InvoiceEntry)element).getBillingSystem();
                }
                return super.getText(element);
            }
        });
        tblclmnLaw.addSelectionListener((SelectionListener)this.sortViewerAdapter);
        TableViewerColumn tvcPayerType = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnType = tvcPayerType.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnType, (ColumnLayoutData)new ColumnPixelData(50, true, true));
        tblclmnType.setText(Messages.Core_Kind);
        tvcPayerType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    return ((InvoiceListContentProvider.InvoiceEntry)element).getPayerType();
                }
                return super.getText(element);
            }
        });
        tblclmnType.addSelectionListener((SelectionListener)this.sortViewerAdapter);
        TableViewerColumn tvcReceiver = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnReceiver = tvcReceiver.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnReceiver, (ColumnLayoutData)new ColumnPixelData(150, true, true));
        tblclmnReceiver.setText(Messages.InvoiceListView_tblclmnReceiver_text);
        tvcReceiver.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    String receiverLabel = ((InvoiceListContentProvider.InvoiceEntry)element).getReceiverLabel();
                    if (((InvoiceListContentProvider.InvoiceEntry)element).isResolved()) {
                        return receiverLabel != null ? receiverLabel : Messages.ContactNotAvailable;
                    }
                    return null;
                }
                return super.getText(element);
            }

            public Color getBackground(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    String receiverLabel = ((InvoiceListContentProvider.InvoiceEntry)element).getReceiverLabel();
                    if (((InvoiceListContentProvider.InvoiceEntry)element).isResolved()) {
                        return receiverLabel != null ? null : UiDesk.getColor("rot");
                    }
                    return null;
                }
                return super.getBackground(element);
            }
        });
        tblclmnReceiver.addSelectionListener((SelectionListener)this.sortViewerAdapter);
        TableViewerColumn tvcTreatmentPeriod = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnTreatmentperiod = tvcTreatmentPeriod.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnTreatmentperiod, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnTreatmentperiod.setText(Messages.InvoiceListView_tblclmnTreatmentperiod_text);
        tblclmnTreatmentperiod.setData((Object)"RnDatumVon");
        tvcTreatmentPeriod.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    return ((InvoiceListContentProvider.InvoiceEntry)element).getTreatmentPeriod();
                }
                return super.getText(element);
            }
        });
        tblclmnTreatmentperiod.addSelectionListener((SelectionListener)this.sortAdapter);
        TableViewerColumn tvcOpenAmount = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnOpenAmount = tvcOpenAmount.getColumn();
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnOpenAmount, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        tblclmnOpenAmount.setText(Messages.Invoice_Amount_Unpaid);
        tblclmnOpenAmount.setData((Object)"openAmount");
        tvcOpenAmount.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    int openAmount = ((InvoiceListContentProvider.InvoiceEntry)element).getOpenAmount();
                    return new Money(openAmount).getAmountAsString();
                }
                return super.getText(element);
            }
        });
        tblclmnOpenAmount.addSelectionListener((SelectionListener)this.sortAdapter);
        TableViewerColumn tvcTotalAmount = new TableViewerColumn(this.tableViewerInvoiceList, 0);
        TableColumn tblclmnTotalAmount = tvcTotalAmount.getColumn();
        tblclmnTotalAmount.setData((Object)"InvoiceTotal");
        tcl_compositeInvoiceList.setColumnData((Widget)tblclmnTotalAmount, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        tblclmnTotalAmount.setText(Messages.Core_Invoice_total_amount);
        tvcTotalAmount.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InvoiceListContentProvider.InvoiceEntry) {
                    int totalAmountInCents = ((InvoiceListContentProvider.InvoiceEntry)element).getTotalAmount();
                    return new Money(totalAmountInCents).getAmountAsString();
                }
                return super.getText(element);
            }
        });
        tblclmnTotalAmount.addSelectionListener((SelectionListener)this.sortAdapter);
        this.invoiceListBottomComposite = new InvoiceListBottomComposite(parent, 0, this.rnStellerSettings);
        this.invoiceListContentProvider = new InvoiceListContentProvider(this.tableViewerInvoiceList, this.invoiceListHeaderComposite, this.invoiceListBottomComposite);
        this.tableViewerInvoiceList.setContentProvider((IContentProvider)this.invoiceListContentProvider);
        InvoiceActions invoiceActions = new InvoiceActions((StructuredViewer)this.tableViewerInvoiceList, this.getViewSite());
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.reloadViewAction);
        tbm.add((IAction)invoiceActions.mahnWizardAction);
        tbm.add((IAction)invoiceActions.exportListAction);
        tbm.add((IAction)this.invoiceListContentProvider.rnFilterAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)invoiceActions.rnExportAction);
        IMenuManager viewMenuManager = this.getViewSite().getActionBars().getMenuManager();
        viewMenuManager.add((IAction)invoiceActions.printListeAction);
        viewMenuManager.add((IAction)invoiceActions.addAccountExcessAction);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)invoiceActions.rnExportAction);
        menuManager.add((IAction)invoiceActions.addPaymentAction);
        menuManager.add((IAction)invoiceActions.addExpenseAction);
        menuManager.add((IAction)invoiceActions.increaseLevelAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)invoiceActions.changeStatusAction);
        menuManager.add((IAction)invoiceActions.stornoAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)invoiceActions.deleteAction);
        menuManager.add((IAction)invoiceActions.reactivateAction);
        menuManager.addMenuListener(mats -> {
            List selectedElements = ((StructuredSelection)this.tableViewerInvoiceList.getSelection()).toList();
            boolean allDefective = selectedElements.stream().allMatch(f -> InvoiceState.DEFECTIVE == f.getInvoiceState());
            invoiceActions.deleteAction.setEnabled(allDefective);
            invoiceActions.reactivateAction.setEnabled(allDefective);
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.tableViewerInvoiceList.getTable());
        tableInvoiceList.setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewerInvoiceList);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewerInvoiceList);
        this.setSortOrder(tblclmnPatient, 128);
        this.refresh();
    }

    private void setSortOrder(TableColumn selectedColumn, int sortDirection) {
        this.tableViewerInvoiceList.getTable().setSortColumn(selectedColumn);
        this.tableViewerInvoiceList.getTable().setSortDirection(sortDirection);
        this.invoiceListContentProvider.setSortOrderAndDirection(selectedColumn.getData(), sortDirection);
    }

    public void setFocus() {
        this.tableViewerInvoiceList.getTable().setFocus();
    }

    public InvoiceListContentProvider getInvoiceListContentProvider() {
        return this.invoiceListContentProvider;
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

