/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.admin.ACE;
import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.inputs.PrefAccessDenied;
import ch.elexis.core.ui.util.BooleanNotConverter;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Query;
import ch.elexis.data.Role;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RolesToAccessRightsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IValueChangeListener {
    private DataBindingContext m_bindingContext;
    private WritableValue wv = new WritableValue(null, Role.class);
    private Text txti18n;
    private TreeViewer treeViewer;
    private Text txtRoleName;
    private MenuItem mntmNewRole;
    private TableViewer tableViewerRoles;
    private MenuItem mntmRemoveRole;

    public RolesToAccessRightsPreferencePage() {
        this.setTitle("Rollen und Rechte");
        this.noDefaultAndApplyButton();
    }

    public Control createContents(Composite parent) {
        if (!CoreHub.acl.request(AccessControlDefaults.ACL_USERS)) {
            return new PrefAccessDenied(parent);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite compositeRoles = new Composite((Composite)sashForm, 0);
        GridLayout gl_compositeRoles = new GridLayout(1, false);
        gl_compositeRoles.verticalSpacing = 2;
        gl_compositeRoles.marginWidth = 0;
        gl_compositeRoles.marginHeight = 0;
        compositeRoles.setLayout((Layout)gl_compositeRoles);
        this.tableViewerRoles = new TableViewer(compositeRoles, 2048);
        Table tableRoles = this.tableViewerRoles.getTable();
        tableRoles.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Menu menu = new Menu((Control)tableRoles);
        tableRoles.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                super.menuShown(e);
                Role r = (Role)RolesToAccessRightsPreferencePage.this.wv.getValue();
                RolesToAccessRightsPreferencePage.this.mntmRemoveRole.setEnabled(!r.isSystemRole());
            }
        });
        this.mntmNewRole = new MenuItem(menu, 0);
        this.mntmNewRole.setText("Rolle hinzuf\u00fcgen");
        this.mntmNewRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Role newRole = new Role(false);
                RolesToAccessRightsPreferencePage.this.updateRolesList();
                RolesToAccessRightsPreferencePage.this.tableViewerRoles.setSelection((ISelection)new StructuredSelection((Object)newRole));
            }
        });
        this.mntmRemoveRole = new MenuItem(menu, 0);
        this.mntmRemoveRole.setText("Rolle l\u00f6schen");
        this.mntmRemoveRole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Role r = (Role)RolesToAccessRightsPreferencePage.this.wv.getValue();
                r.delete();
                RolesToAccessRightsPreferencePage.this.updateRolesList();
            }
        });
        Composite composite = new Composite(compositeRoles, 0);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginWidth = 0;
        gl_composite.horizontalSpacing = 0;
        gl_composite.verticalSpacing = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.txtRoleName = new Text(composite, 2048);
        this.txtRoleName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRoleName.setMessage("Bezeichnung");
        Link linkChangeRoleName = new Link(composite, 0);
        linkChangeRoleName.setText("<a>\u00e4ndern</a>");
        linkChangeRoleName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newRoleName = RolesToAccessRightsPreferencePage.this.txtRoleName.getText();
                if (Role.verifyRoleNameNotTaken((String)newRoleName)) {
                    RolesToAccessRightsPreferencePage.this.setErrorMessage(null);
                    Role r = (Role)RolesToAccessRightsPreferencePage.this.wv.getValue();
                    Role changedRole = r.setRoleName(newRoleName);
                    RolesToAccessRightsPreferencePage.this.updateRolesList();
                    RolesToAccessRightsPreferencePage.this.tableViewerRoles.setSelection((ISelection)new StructuredSelection((Object)changedRole));
                } else {
                    RolesToAccessRightsPreferencePage.this.setErrorMessage("Rollenname bereits vergeben.");
                }
            }
        });
        this.txti18n = new Text(compositeRoles, 2048);
        this.txti18n.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txti18n.setMessage("Lokale Bezeichnung");
        this.txti18n.setBounds(0, 0, 64, 19);
        this.tableViewerRoles.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewerRoles.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                Role r = (Role)element;
                if (r.isSystemRole()) {
                    return Images.IMG_LOCK_CLOSED.getImage();
                }
                return Images.IMG_EMPTY_TRANSPARENT.getImage();
            }
        });
        this.tableViewerRoles.addSelectionChangedListener(e -> {
            StructuredSelection ss = (StructuredSelection)e.getSelection();
            this.wv.setValue(ss == null ? null : ss.getFirstElement());
        });
        this.treeViewer = new TreeViewer((Composite)sashForm, 65536);
        final Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new ACETreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ACE a = (ACE)cell.getElement();
                cell.setText(a.getLocalizedName());
            }
        });
        this.treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ACE t1 = (ACE)e1;
                ACE t2 = (ACE)e2;
                return t1.getLocalizedName().compareToIgnoreCase(t2.getLocalizedName());
            }
        });
        TreeViewerColumn tvc_right = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn tc_right = tvc_right.getColumn();
        tc_right.setWidth(-1);
        tc_right.setWidth(280);
        tc_right.setText("Recht");
        tvc_right.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ACE a = (ACE)cell.getElement();
                cell.setText(a.getLocalizedName());
            }
        });
        final CheckboxCellEditor cbce = new CheckboxCellEditor();
        CellLabelProvider clp = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                TreeColumn tc = tree.getColumn(cell.getColumnIndex());
                Role role = (Role)tc.getData("role");
                ACE ace = (ACE)cell.getElement();
                int val = RolesToAccessRightsPreferencePage.this.determineChildAndSelfStates(role, ace);
                switch (val) {
                    case 3: {
                        if (ace.getChildren(true).size() > 1) {
                            cell.setText("A");
                            cell.setForeground(UiDesk.getColor("blau"));
                            break;
                        }
                        cell.setText("x");
                        cell.setForeground(UiDesk.getColor("schwarz"));
                        break;
                    }
                    case 2: {
                        cell.setText("...");
                        cell.setForeground(UiDesk.getColor("hellgrau"));
                        break;
                    }
                    case 1: {
                        cell.setText("x");
                        cell.setForeground(UiDesk.getColor("schwarz"));
                        break;
                    }
                    default: {
                        cell.setText("");
                        cell.setForeground(UiDesk.getColor("schwarz"));
                    }
                }
            }
        };
        Query qbe = new Query(Role.class);
        List roles = qbe.execute();
        for (Role role : roles) {
            TreeViewerColumn tvc = new TreeViewerColumn(this.treeViewer, 0x1000000);
            tvc.getViewer().setData("role", (Object)role);
            final TreeColumn tc = tvc.getColumn();
            tc.setData("role", (Object)role);
            tc.setWidth(20);
            tc.setText(String.valueOf(role.getLabel().charAt(0)));
            String translation = role.getTranslatedLabel();
            if (translation != null && translation.length() > 0) {
                tc.setToolTipText(translation);
            } else {
                tc.setToolTipText(role.getLabel());
            }
            tvc.setLabelProvider(clp);
            EditingSupport es = new EditingSupport(tvc.getViewer()){

                protected void setValue(final Object element, Object value) {
                    BusyIndicator.showWhile((Display)UiDesk.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Role role = (Role)tc.getData("role");
                            ACE ace = (ACE)element;
                            if (ace != null) {
                                boolean hasChildren = !ace.getChildren(false).isEmpty();
                                boolean selfChecked = CoreHub.acl.request(role, ace);
                                if (selfChecked) {
                                    CoreHub.acl.revoke(role, ace);
                                } else {
                                    CoreHub.acl.grant(role, ace);
                                }
                                if (hasChildren) {
                                    boolean checked = CoreHub.acl.request(role, ace);
                                    List aces = ace.getChildren(true);
                                    for (ACE permission : aces) {
                                        if (checked) {
                                            CoreHub.acl.grant(role, permission);
                                        } else {
                                            CoreHub.acl.revoke(role, permission);
                                        }
                                        this.getViewer().update((Object)permission, null);
                                    }
                                }
                                this.getViewer().update(element, null);
                                int maxDepth = 100;
                                ACE parent = ace.getParent();
                                while (parent != null && --maxDepth > 0) {
                                    this.getViewer().refresh((Object)parent);
                                    parent = parent.getParent();
                                }
                            }
                        }
                    });
                }

                protected Object getValue(Object element) {
                    return true;
                }

                protected CellEditor getCellEditor(Object element) {
                    return cbce;
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            };
            tvc.setEditingSupport(es);
        }
        sashForm.setWeights(new int[]{3, 7});
        Composite compositeBottom = new Composite(container, 0);
        compositeBottom.setLayout((Layout)new GridLayout(2, false));
        compositeBottom.setLayoutData((Object)new GridData(131072, 4, true, false, 1, 1));
        Group g = new Group(compositeBottom, 0);
        g.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        g.setLayout((Layout)new GridLayout(1, false));
        new Label((Composite)g, 0).setText("A  Alle Kindelemente sind ausgew\u00e4hlt.");
        new Label((Composite)g, 0).setText("...  Zumindest ein Kindelement ist ausgew\u00e4hlt.");
        new Label((Composite)g, 0).setText("x  Das Element ist ausgew\u00e4hlt.");
        Link linkResetDefaults = new Link(compositeBottom, 0);
        linkResetDefaults.setLayoutData((Object)new GridData(128, 4, true, false, 1, 1));
        linkResetDefaults.setText("<a>Standard-Rechte wiederherstellen</a>");
        linkResetDefaults.setBounds(0, 0, 43, 15);
        linkResetDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ret = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"Standard-Rechte wiederherstellen", (String)"Sind Sie sicher?");
                if (ret) {
                    ACE.initializeACEDefaults((boolean)true);
                    RolesToAccessRightsPreferencePage.this.refreshViewer();
                }
            }
        });
        this.m_bindingContext = this.initDataBindings();
        this.wv.addValueChangeListener((IValueChangeListener)this);
        this.treeViewer.setInput((Object)ACE.getAllDefinedRootACElements());
        this.tableViewerRoles.setInput((Object)roles);
        return container;
    }

    private void updateRolesList() {
        Query qbe = new Query(Role.class);
        this.tableViewerRoles.setInput((Object)qbe.execute());
    }

    public void init(IWorkbench workbench) {
    }

    public void handleValueChange(ValueChangeEvent event) {
        Role r = (Role)this.wv.getValue();
        this.txtRoleName.setText(r == null ? "" : r.getRoleName());
    }

    private void refreshViewer() {
        this.treeViewer.refresh();
    }

    private boolean isGrayed(ACE ace, Role role) {
        if (role == null || ace == null) {
            return false;
        }
        int state = this.determineChildAndSelfStates(role, ace);
        return state == 1 || state == 2;
    }

    private boolean isChecked(ACE ace, Role r) {
        if (r == null || ace == null) {
            return false;
        }
        int state = this.determineChildAndSelfStates(r, ace);
        return state > 0;
    }

    private int determineChildAndSelfStates(@NonNull Role r, @NonNull ACE ace) {
        if (CoreHub.acl.request(r, ace.getParent())) {
            return 1;
        }
        List chain = ace.getChildren(true);
        List chainRights = chain.stream().map(ace2 -> CoreHub.acl.request(r, ace2)).collect(Collectors.toList());
        long trues = chainRights.stream().filter(p -> p).count();
        if (trues == 0L) {
            return 0;
        }
        if (trues == (long)chainRights.size()) {
            return 3;
        }
        return 2;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxti18nObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txti18n);
        IObservableValue wvTranslatedLabelObserveDetailValue = PojoProperties.value(Role.class, (String)"translatedLabel", String.class).observeDetail((IObservableValue)this.wv);
        bindingContext.bindValue((IObservableValue)observeTextTxti18nObserveWidget, wvTranslatedLabelObserveDetailValue, null, null);
        ISWTObservableValue observeEnabledTxtRoleNameObserveWidget = WidgetProperties.enabled().observe((Widget)this.txtRoleName);
        IObservableValue wvSystemRoleObserveDetailValue = PojoProperties.value(Role.class, (String)"systemRole", Boolean.class).observeDetail((IObservableValue)this.wv);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNotConverter());
        bindingContext.bindValue((IObservableValue)observeEnabledTxtRoleNameObserveWidget, wvSystemRoleObserveDetailValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), strategy);
        return bindingContext;
    }

    private class ACETreeContentProvider
    implements ITreeContentProvider {
        private ACETreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            ACE a = (ACE)parentElement;
            return ACE.getAllDefinedACElements().stream().filter(p -> p.getParent().equals(a)).toArray();
        }

        public Object getParent(Object element) {
            ACE a = (ACE)element;
            ACE parent = a.getParent();
            if (ACE.ACE_ROOT.equals(parent)) {
                return null;
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            ACE a = (ACE)element;
            return (double)ACE.getAllDefinedACElements().stream().filter(p -> p.getParent().equals(a)).count() > 0.0;
        }
    }
}

