/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class NoPoUtil {
    private static PersistentObjectFactory poFactory = new PersistentObjectFactory();

    public static PersistentObject loadAsPersistentObject(Identifiable identifiable) {
        if (identifiable != null) {
            PersistentObject ret;
            Optional storeToString = StoreToStringServiceHolder.get().storeToString(identifiable);
            if (storeToString.isPresent() && (ret = poFactory.createFromString((String)storeToString.get())) != null) {
                return ret;
            }
            throw new IllegalStateException("Could not load [" + identifiable + "] [" + storeToString.orElse("?") + "] as PersistentObject");
        }
        return null;
    }

    public static <T> List<T> loadAsPersistentObject(List<Identifiable> identifiables, Class<T> type) {
        if (identifiables != null && !identifiables.isEmpty()) {
            ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>();
            for (Identifiable identifiable : identifiables) {
                ret.add(NoPoUtil.loadAsPersistentObject(identifiable));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public static <T> T[] loadAsPersistentObject(Identifiable[] identifiables, Class<T> type) {
        if (identifiables != null && identifiables.length > 0) {
            Object[] ret = (Object[])Array.newInstance(type, identifiables.length);
            int i = 0;
            while (i < identifiables.length) {
                ret[i] = NoPoUtil.loadAsPersistentObject(identifiables[i]);
                ++i;
            }
            return ret;
        }
        return (Object[])Array.newInstance(type, 0);
    }

    public static <T> List<T> loadAsIdentifiable(List<? extends PersistentObject> persistentObjects, Class<T> type) {
        if (persistentObjects != null && !persistentObjects.isEmpty()) {
            ArrayList ret = new ArrayList();
            for (PersistentObject persistentObject : persistentObjects) {
                NoPoUtil.loadAsIdentifiable(persistentObject, type).ifPresent(identifiable -> ret.add(identifiable));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public static <T> Optional<T> loadAsIdentifiable(PersistentObject persistentObject, Class<T> type) {
        if (persistentObject != null) {
            Optional loaded = CoreModelServiceHolder.get().load(persistentObject.getId(), type);
            if (loaded.isPresent()) {
                return loaded;
            }
            loaded = StoreToStringServiceHolder.get().loadFromString(persistentObject.storeToString());
            if (loaded.isPresent()) {
                return loaded;
            }
        }
        return Optional.empty();
    }

    public static void refreshIdentifiable(PersistentObject persistentObject) {
        Optional loaded = StoreToStringServiceHolder.get().loadFromString(persistentObject.storeToString());
        loaded.ifPresent(i -> CoreModelServiceHolder.get().refresh(i, true));
    }

    public static String getElexisDateSearchString(String value) {
        StringBuilder sb = null;
        String ret = value.replaceAll("%", "");
        String filler = "%%%%%%%%";
        if (ret.matches("[0-9]{3,}")) {
            sb = new StringBuilder(ret);
            sb.append("%%%%%%%%");
            ret = sb.substring(0, 8);
        } else {
            int dotCount = StringUtils.countMatches((CharSequence)ret, (CharSequence)".");
            String[] parts = ret.split("\\.");
            StringJoiner sj = new StringJoiner("");
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.length() == 1 && Character.isDigit(string.charAt(0))) {
                    sj.add("0" + string);
                } else {
                    sj.add(string);
                }
                ++n2;
            }
            sb = new StringBuilder(sj.toString());
            int lengthNoDots = sb.length();
            sb.append("%%%%%%%%");
            ret = dotCount == 1 && lengthNoDots == 6 ? String.valueOf(sb.substring(2, 6)) + sb.substring(0, 2) + sb.substring(6, 8) : String.valueOf(sb.substring(4, 8)) + sb.substring(2, 4) + sb.substring(0, 2);
        }
        return ret;
    }
}

