/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.application.listeners;

import ch.elexis.core.ui.UiDesk;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=info/elexis/notification/*"})
public class OsgiMessageEventListener
implements EventHandler {
    public void handleEvent(Event event) {
        final String topic = event.getTopic().substring("info/elexis/notification/".length());
        final String title = (String)event.getProperty("title");
        final String message = (String)event.getProperty("message");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                switch (topic) {
                    case "error": {
                        MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)title, (String)message);
                        break;
                    }
                    case "warn": {
                        MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)title, (String)message);
                        break;
                    }
                    case "info": {
                        MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)title, (String)message);
                        break;
                    }
                    default: {
                        LoggerFactory.getLogger(this.getClass()).error("invalid topic [" + topic + "] for message: " + title + "/" + message);
                    }
                }
            }
        });
    }
}

