/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenartikel;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.eigenartikel.EigenartikelComposite;
import ch.elexis.core.ui.eigenartikel.EigenartikelProductComposite;
import ch.elexis.core.ui.eigenartikel.Messages;
import ch.elexis.core.ui.eigenartikel.acl.ACLContributor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.views.IDetailDisplay;
import java.text.MessageFormat;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewSite;

public class EigenartikelDetailDisplay
implements IDetailDisplay {
    private IViewSite site;
    private EigenartikelProductComposite epc;
    private EigenartikelComposite ec;
    private IArticle selectedObject;
    private IArticle currentLock;
    private StackLayout layout;
    private Composite container;
    private Composite compProduct;
    private Composite compArticle;
    private RestrictedAction createAction = new RestrictedAction(ACLContributor.EIGENARTIKEL_MODIFY, ch.elexis.core.ui.views.artikel.Messages.Core_New_ellipsis){
        {
            this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            this.setToolTipText(ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_createProductToolTipText);
        }

        public void doRun() {
            IArticle ea = (IArticle)CoreModelServiceHolder.get().create(IArticle.class);
            ea.setTyp(ArticleTyp.EIGENARTIKEL);
            ea.setName("Neues Produkt");
            CoreModelServiceHolder.get().save((Identifiable)ea);
            ContextServiceHolder.get().postEvent("info/elexis/model/reload", IArticle.class);
            EigenartikelDetailDisplay.this.selection(ea);
        }
    };
    private RestrictedAction toggleLockAction = new RestrictedAction(ACLContributor.EIGENARTIKEL_MODIFY, "lock", 2){
        {
            this.setImageDescriptor(Images.IMG_LOCK_CLOSED.getImageDescriptor());
        }

        public void setChecked(boolean checked) {
            if (checked) {
                this.setImageDescriptor(Images.IMG_LOCK_OPEN.getImageDescriptor());
            } else {
                this.setImageDescriptor(Images.IMG_LOCK_CLOSED.getImageDescriptor());
            }
            super.setChecked(checked);
        }

        public void doRun() {
            if (EigenartikelDetailDisplay.this.selectedObject != null) {
                if (LocalLockServiceHolder.get().isLocked((Object)EigenartikelDetailDisplay.this.selectedObject)) {
                    LocalLockServiceHolder.get().releaseLock((Object)EigenartikelDetailDisplay.this.selectedObject);
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", IArticle.class);
                    EigenartikelDetailDisplay.this.currentLock = null;
                } else {
                    LockResponse lr = LocalLockServiceHolder.get().acquireLock((Object)EigenartikelDetailDisplay.this.selectedObject);
                    if (lr.isOk()) {
                        EigenartikelDetailDisplay.this.currentLock = EigenartikelDetailDisplay.this.selectedObject;
                    } else {
                        LockResponseHelper.showInfo((LockResponse)lr, (Object)EigenartikelDetailDisplay.this.selectedObject, null);
                    }
                }
            }
            this.setChecked(LocalLockServiceHolder.get().isLocked((Object)EigenartikelDetailDisplay.this.currentLock));
        }
    };
    private RestrictedAction deleteAction = new LockRequestingRestrictedAction<IArticle>(ACLContributor.EIGENARTIKEL_MODIFY, ch.elexis.core.ui.views.artikel.Messages.Core_Delete){
        {
            this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            this.setToolTipText(ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_deleteProductToolTipText);
        }

        public IArticle getTargetedObject() {
            java.util.Optional selected = ContextServiceHolder.get().getRootContext().getNamed("ch.elexis.core.ui.eigenartikel.selection");
            return selected.orElse(null);
        }

        public void doRun(IArticle act) {
            if (MessageDialog.openConfirm((Shell)EigenartikelDetailDisplay.this.site.getShell(), (String)ch.elexis.core.ui.views.artikel.Messages.Core_Confirm_delete, (String)MessageFormat.format(ch.elexis.core.ui.views.artikel.Messages.Core_Want_to_delete_0, act.getName()))) {
                CoreModelServiceHolder.get().delete((Deleteable)act);
                if (EigenartikelDetailDisplay.this.epc != null) {
                    EigenartikelDetailDisplay.this.epc.setProductEigenartikel(null);
                }
            }
            ContextServiceHolder.get().postEvent("info/elexis/model/reload", IArticle.class);
        }
    };

    @Inject
    @Optional
    public void lockAquired(@UIEventTopic(value="info/elexis/locking/aquired") IArticle typedArticle) {
        if (this.epc != null && !this.epc.isDisposed() && typedArticle.getId().equals(this.selectedObject.getId())) {
            this.epc.setUnlocked(true);
        }
    }

    @Inject
    @Optional
    public void lockReleased(@UIEventTopic(value="info/elexis/locking/released") IArticle typedArticle) {
        if (this.epc != null && !this.epc.isDisposed() && typedArticle.getId().equals(this.selectedObject.getId())) {
            this.epc.setUnlocked(false);
        }
    }

    @Inject
    public void selection(@Optional @Named(value="ch.elexis.core.ui.eigenartikel.selection") @Named(value="ch.elexis.core.ui.eigenartikel.selection") IArticle typedArticle) {
        if (this.epc != null && !this.epc.isDisposed()) {
            this.display(typedArticle);
        }
    }

    public Composite createDisplay(Composite parent, IViewSite site) {
        this.site = site;
        this.container = new Composite(parent, 0);
        this.layout = new StackLayout();
        this.container.setLayout((Layout)this.layout);
        this.compProduct = new Composite(this.container, 0);
        this.compProduct.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(this.compProduct, 0x820800);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ToolBarManager manager = new ToolBarManager(toolBar);
        manager.add((IAction)this.createAction);
        if (ElexisServerServiceHolder.get().getConnectionStatus() != IElexisServerService.ConnectionStatus.STANDALONE) {
            manager.add((IAction)this.toggleLockAction);
        }
        manager.add((IAction)this.deleteAction);
        manager.update(true);
        toolBar.pack();
        this.epc = new EigenartikelProductComposite(this.compProduct, 0);
        this.epc.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.epc.setUnlocked(ElexisServerServiceHolder.get().getConnectionStatus() == IElexisServerService.ConnectionStatus.STANDALONE);
        this.compArticle = new Composite(this.container, 0);
        this.compArticle.setLayout((Layout)new GridLayout(1, false));
        this.ec = new EigenartikelComposite(this.compArticle, 0, false, null);
        this.ec.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.ec.setUnlocked(ElexisServerServiceHolder.get().getConnectionStatus() == IElexisServerService.ConnectionStatus.STANDALONE);
        this.layout.topControl = this.compProduct;
        this.container.layout();
        return this.container;
    }

    public Class<?> getElementClass() {
        return IArticle.class;
    }

    public void display(Object obj) {
        this.toggleLockAction.reflectRight();
        this.createAction.reflectRight();
        this.deleteAction.reflectRight();
        if (obj instanceof IArticle) {
            this.selectedObject = (IArticle)obj;
            if (this.currentLock != null) {
                LocalLockServiceHolder.get().releaseLock((Object)this.currentLock);
                this.toggleLockAction.setChecked(false);
                this.currentLock = null;
            }
            IArticle article = (IArticle)obj;
            this.toggleLockAction.setEnabled(article.isProduct());
            if (article.isProduct()) {
                this.layout.topControl = this.compProduct;
                this.epc.setProductEigenartikel(article);
            } else {
                this.layout.topControl = this.compArticle;
                this.ec.setEigenartikel(article);
            }
        } else {
            this.selectedObject = null;
            this.toggleLockAction.setEnabled(false);
            this.epc.setProductEigenartikel(null);
            this.ec.setEigenartikel(null);
            this.layout.topControl = this.compProduct;
        }
        this.container.layout();
    }

    public String getTitle() {
        return Messages.EigenartikelDisplay_displayTitle;
    }
}

