/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.ui.composites.ICompositeSaveable;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CompositeGroup
extends Composite
implements ICompositeSaveable {
    private IFinding iFinding;
    private Label lbl;
    private List<ICompositeSaveable> childReferences = new ArrayList<ICompositeSaveable>();
    private List<ICompositeSaveable> childComponents = new ArrayList<ICompositeSaveable>();
    private String txt;
    private List<Action> toolbarActions = new ArrayList<Action>();
    private IObservation.ObservationType observationType;

    public CompositeGroup(Composite parent, IFinding iFinding, boolean showTitle, boolean showBorder, int marginWidth, int marginTop, int depthIndex) {
        super(parent, showBorder || depthIndex == 0 ? 2048 : 0);
        this.iFinding = iFinding;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = marginWidth;
        gridLayout.marginTop = marginTop;
        gridLayout.marginBottom = 10;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        if (iFinding instanceof IObservation) {
            this.observationType = ((IObservation)iFinding).getObservationType();
        }
        if (depthIndex == 0) {
            this.setBackground(UiDesk.getColor((String)"weiss"));
            Composite titleComposite = new Composite((Composite)this, 0);
            titleComposite.setLayout((Layout)SWTHelper.createGridLayout((boolean)true, (int)1));
            titleComposite.setLayoutData((Object)new GridData(4, 1024, true, false));
            this.setToolbarActions(FindingsUiUtil.createToolbarMainComponent(titleComposite, (IObservation)iFinding, 1));
        } else {
            Optional coding;
            this.txt = iFinding instanceof IObservation ? ((coding = ModelUtil.getCodeBySystem((List)((IObservation)iFinding).getCoding(), (CodingSystem)CodingSystem.ELEXIS_LOCAL_CODESYSTEM)).isPresent() ? ((ICoding)coding.get()).getDisplay() : "") : (String)iFinding.getText().orElse(null);
            if (showTitle && this.txt != null) {
                GridData gdLbl = new GridData(0x1000000, 1024, true, false);
                this.lbl = new Label((Composite)this, 0);
                FontData fontData = this.lbl.getFont().getFontData()[0];
                if (depthIndex == 1) {
                    gdLbl.horizontalIndent = -40;
                    gridLayout.marginRight = 10;
                    gridLayout.marginLeft = 10;
                    this.lbl.setFont(UiDesk.getFont((String)fontData.getName(), (int)(fontData.getHeight() + 3), (int)1));
                } else if (depthIndex > 1) {
                    gridLayout.marginTop = 15;
                    gridLayout.marginBottom = 0;
                    gdLbl.horizontalIndent = -40;
                    this.lbl.setFont(UiDesk.getFont((String)fontData.getName(), (int)(fontData.getHeight() + 1), (int)1));
                }
                this.lbl.setText(this.txt);
                this.lbl.setLayoutData((Object)gdLbl);
            }
        }
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    public String getFieldTextValue() {
        return null;
    }

    @Override
    public List<ICompositeSaveable> getChildComponents() {
        return this.childComponents;
    }

    @Override
    public List<ICompositeSaveable> getChildReferences() {
        return this.childReferences;
    }

    @Override
    public IFinding saveContents(LocalDateTime localDateTime) {
        if (this.iFinding.getId() == null) {
            this.iFinding = FindingsServiceComponent.getService().create(this.iFinding.getClass());
        }
        return FindingsUiUtil.saveObservation((IObservation)this.iFinding, this, localDateTime);
    }

    @Override
    public void hideLabel(boolean all) {
        if (this.lbl != null) {
            this.lbl.setText("");
        }
    }

    @Override
    public void setToolbarActions(List<Action> toolbarActions) {
        this.toolbarActions = toolbarActions;
    }

    @Override
    public List<Action> getToolbarActions() {
        return this.toolbarActions;
    }

    @Override
    public String getTitle() {
        return this.lbl != null ? this.lbl.getText() : this.txt;
    }

    @Override
    public IFinding getFinding() {
        return this.iFinding;
    }

    @Override
    public ObservationComponent getObservationComponent() {
        return null;
    }

    @Override
    public IObservation.ObservationType getObservationType() {
        return this.observationType;
    }
}

