/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.builder;

import java.util.Map;
import org.springframework.batch.item.xml.StaxEventItemWriter;
import org.springframework.batch.item.xml.StaxWriterCallback;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;

public class StaxEventItemWriterBuilder<T> {
    private Resource resource;
    private Marshaller marshaller;
    private StaxWriterCallback headerCallback;
    private StaxWriterCallback footerCallback;
    private boolean transactional = true;
    private boolean forceSync = false;
    private boolean shouldDeleteIfEmpty = false;
    private String encoding = "UTF-8";
    private String version = "1.0";
    private Boolean standalone = StaxEventItemWriter.DEFAULT_STANDALONE_DOCUMENT;
    private String rootTagName = "root";
    private Map<String, String> rootElementAttributes;
    private boolean overwriteOutput = true;
    private boolean saveState = true;
    private String name;

    public StaxEventItemWriterBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public StaxEventItemWriterBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public StaxEventItemWriterBuilder<T> marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public StaxEventItemWriterBuilder<T> headerCallback(StaxWriterCallback headerCallback) {
        this.headerCallback = headerCallback;
        return this;
    }

    public StaxEventItemWriterBuilder<T> footerCallback(StaxWriterCallback footerCallback) {
        this.footerCallback = footerCallback;
        return this;
    }

    public StaxEventItemWriterBuilder<T> transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public StaxEventItemWriterBuilder<T> forceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    public StaxEventItemWriterBuilder<T> shouldDeleteIfEmpty(boolean shouldDelete) {
        this.shouldDeleteIfEmpty = shouldDelete;
        return this;
    }

    public StaxEventItemWriterBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public StaxEventItemWriterBuilder<T> version(String version) {
        this.version = version;
        return this;
    }

    public StaxEventItemWriterBuilder<T> standalone(Boolean standalone) {
        this.standalone = standalone;
        return this;
    }

    public StaxEventItemWriterBuilder<T> rootTagName(String rootTagName) {
        this.rootTagName = rootTagName;
        return this;
    }

    public StaxEventItemWriterBuilder<T> rootElementAttributes(Map<String, String> rootElementAttributes) {
        this.rootElementAttributes = rootElementAttributes;
        return this;
    }

    public StaxEventItemWriterBuilder<T> overwriteOutput(boolean overwriteOutput) {
        this.overwriteOutput = overwriteOutput;
        return this;
    }

    public StaxEventItemWriterBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public StaxEventItemWriter<T> build() {
        Assert.notNull((Object)this.marshaller, "A marshaller is required");
        if (this.saveState) {
            Assert.notNull((Object)this.name, "A name is required");
        }
        StaxEventItemWriter writer = new StaxEventItemWriter();
        writer.setEncoding(this.encoding);
        writer.setFooterCallback(this.footerCallback);
        writer.setForceSync(this.forceSync);
        writer.setHeaderCallback(this.headerCallback);
        writer.setMarshaller(this.marshaller);
        writer.setOverwriteOutput(this.overwriteOutput);
        writer.setResource(this.resource);
        writer.setRootElementAttributes(this.rootElementAttributes);
        writer.setRootTagName(this.rootTagName);
        writer.setSaveState(this.saveState);
        writer.setShouldDeleteIfEmpty(this.shouldDeleteIfEmpty);
        writer.setTransactional(this.transactional);
        writer.setVersion(this.version);
        writer.setName(this.name);
        writer.setStandalone(this.standalone);
        return writer;
    }
}

