/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.kafka.builder;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.TopicPartition;
import org.springframework.batch.item.kafka.KafkaItemReader;
import org.springframework.util.Assert;

public class KafkaItemReaderBuilder<K, V> {
    private Properties consumerProperties;
    private String topic;
    private List<Integer> partitions = new ArrayList<Integer>();
    private Map<TopicPartition, Long> partitionOffsets;
    private Duration pollTimeout = Duration.ofSeconds(30L);
    private boolean saveState = true;
    private String name;

    public KafkaItemReaderBuilder<K, V> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> name(String name) {
        this.name = name;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> consumerProperties(Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> partitions(Integer ... partitions) {
        return this.partitions(Arrays.asList(partitions));
    }

    public KafkaItemReaderBuilder<K, V> partitions(List<Integer> partitions) {
        this.partitions = partitions;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> partitionOffsets(Map<TopicPartition, Long> partitionOffsets) {
        this.partitionOffsets = partitionOffsets;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> topic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> pollTimeout(Duration pollTimeout) {
        this.pollTimeout = pollTimeout;
        return this;
    }

    public KafkaItemReader<K, V> build() {
        if (this.saveState) {
            Assert.hasText(this.name, "A name is required when saveState is set to true");
        }
        Assert.notNull((Object)this.consumerProperties, "Consumer properties must not be null");
        Assert.isTrue(this.consumerProperties.containsKey("bootstrap.servers"), "bootstrap.servers property must be provided");
        Assert.isTrue(this.consumerProperties.containsKey("group.id"), "group.id property must be provided");
        Assert.isTrue(this.consumerProperties.containsKey("key.deserializer"), "key.deserializer property must be provided");
        Assert.isTrue(this.consumerProperties.containsKey("value.deserializer"), "value.deserializer property must be provided");
        Assert.hasLength(this.topic, "Topic name must not be null or empty");
        Assert.notNull((Object)this.pollTimeout, "pollTimeout must not be null");
        Assert.isTrue(!this.pollTimeout.isZero(), "pollTimeout must not be zero");
        Assert.isTrue(!this.pollTimeout.isNegative(), "pollTimeout must not be negative");
        Assert.isTrue(!this.partitions.isEmpty(), "At least one partition must be provided");
        KafkaItemReader reader = new KafkaItemReader(this.consumerProperties, this.topic, this.partitions);
        reader.setPollTimeout(this.pollTimeout);
        reader.setSaveState(this.saveState);
        reader.setName(this.name);
        reader.setPartitionOffsets(this.partitionOffsets);
        return reader;
    }
}

