/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import java.util.Comparator;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RangeArrayPropertyEditor
extends PropertyEditorSupport {
    private boolean forceDisjointRanges = false;

    public void setForceDisjointRanges(boolean forceDisjointRanges) {
        this.forceDisjointRanges = forceDisjointRanges;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String[] strRanges = text.split(",");
        Range[] ranges = new Range[strRanges.length];
        for (int i2 = 0; i2 < strRanges.length; ++i2) {
            int min2;
            String[] range = strRanges[i2].split("-");
            if (range.length == 1 && StringUtils.hasText(range[0])) {
                min2 = Integer.parseInt(range[0].trim());
                ranges[i2] = new Range(min2);
                continue;
            }
            if (range.length == 2 && StringUtils.hasText(range[0]) && StringUtils.hasText(range[1])) {
                min2 = Integer.parseInt(range[0].trim());
                int max = Integer.parseInt(range[1].trim());
                ranges[i2] = new Range(min2, max);
                continue;
            }
            throw new IllegalArgumentException("Range[" + i2 + "]: range (" + strRanges[i2] + ") is invalid");
        }
        this.setMaxValues(ranges);
        this.setValue(ranges);
    }

    @Override
    public String getAsText() {
        Range[] ranges = (Range[])this.getValue();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(ranges[i2]);
        }
        return sb.toString();
    }

    private void setMaxValues(final Range[] ranges) {
        int i2;
        Integer[] c = new Integer[ranges.length];
        for (i2 = 0; i2 < c.length; ++i2) {
            c[i2] = i2;
        }
        Arrays.sort(c, new Comparator<Integer>(){

            @Override
            public int compare(Integer r1, Integer r2) {
                return ranges[r1].getMin() - ranges[r2].getMin();
            }
        });
        for (i2 = 0; i2 < c.length - 1; ++i2) {
            if (ranges[c[i2]].hasMaxValue()) continue;
            ranges[c[i2].intValue()] = new Range(ranges[c[i2]].getMin(), ranges[c[i2 + 1]].getMin() - 1);
        }
        if (this.forceDisjointRanges) {
            this.verifyRanges(ranges);
        }
    }

    private void verifyRanges(Range[] ranges) {
        for (int i2 = 1; i2 < ranges.length; ++i2) {
            Assert.isTrue(ranges[i2 - 1].getMax() < ranges[i2].getMin(), "Ranges must be disjoint. Range[" + (i2 - 1) + "]: (" + ranges[i2 - 1] + ") Range[" + i2 + "]: (" + ranges[i2] + ")");
        }
    }
}

