/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.file.transform.AbstractLineTokenizer;
import org.springframework.batch.item.file.transform.IncorrectLineLengthException;
import org.springframework.batch.item.file.transform.Range;

public class FixedLengthTokenizer
extends AbstractLineTokenizer {
    private Range[] ranges;
    private int maxRange = 0;
    boolean open = false;

    public void setColumns(Range ... ranges) {
        this.ranges = Arrays.asList(ranges).toArray(new Range[ranges.length]);
        this.calculateMaxRange(ranges);
    }

    private void calculateMaxRange(Range[] ranges) {
        if (ranges == null || ranges.length == 0) {
            this.maxRange = 0;
            return;
        }
        this.open = false;
        this.maxRange = ranges[0].getMin();
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            int upperBound;
            if (ranges[i2].hasMaxValue()) {
                upperBound = ranges[i2].getMax();
            } else {
                upperBound = ranges[i2].getMin();
                if (upperBound > this.maxRange) {
                    this.open = true;
                }
            }
            if (upperBound <= this.maxRange) continue;
            this.maxRange = upperBound;
        }
    }

    @Override
    protected List<String> doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>(this.ranges.length);
        int lineLength = line.length();
        if (lineLength < this.maxRange && this.isStrict()) {
            throw new IncorrectLineLengthException("Line is shorter than max range " + this.maxRange, this.maxRange, lineLength, line);
        }
        if (!this.open && lineLength > this.maxRange && this.isStrict()) {
            throw new IncorrectLineLengthException("Line is longer than max range " + this.maxRange, this.maxRange, lineLength, line);
        }
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            int startPos = this.ranges[i2].getMin() - 1;
            int endPos = this.ranges[i2].getMax();
            String token = lineLength >= endPos ? line.substring(startPos, endPos) : (lineLength >= startPos ? line.substring(startPos) : "");
            tokens.add(token);
        }
        return tokens;
    }
}

