/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.PassThroughFieldExtractor;
import org.springframework.util.Assert;

public abstract class ExtractorLineAggregator<T>
implements LineAggregator<T> {
    private FieldExtractor<T> fieldExtractor = new PassThroughFieldExtractor();

    public void setFieldExtractor(FieldExtractor<T> fieldExtractor) {
        this.fieldExtractor = fieldExtractor;
    }

    @Override
    public String aggregate(T item) {
        Assert.notNull(item, "Item is required");
        Object[] fields = this.fieldExtractor.extract(item);
        Object[] args2 = new Object[fields.length];
        for (int i2 = 0; i2 < fields.length; ++i2) {
            args2[i2] = fields[i2] == null ? "" : fields[i2];
        }
        return this.doAggregate(args2);
    }

    protected abstract String doAggregate(Object[] var1);
}

