/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.mapping;

import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultLineMapper<T>
implements LineMapper<T>,
InitializingBean {
    private LineTokenizer tokenizer;
    private FieldSetMapper<T> fieldSetMapper;

    @Override
    public T mapLine(String line, int lineNumber) throws Exception {
        return this.fieldSetMapper.mapFieldSet(this.tokenizer.tokenize(line));
    }

    public void setLineTokenizer(LineTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void setFieldSetMapper(FieldSetMapper<T> fieldSetMapper) {
        this.fieldSetMapper = fieldSetMapper;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.tokenizer, "The LineTokenizer must be set");
        Assert.notNull(this.fieldSetMapper, "The FieldSetMapper must be set");
    }
}

