/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.HashMap;
import java.util.List;

public class JdbcParameterUtils {
    public static int countParameterPlaceholders(String sql, List<String> namedParameterHolder) {
        if (sql == null) {
            return 0;
        }
        boolean withinQuotes = false;
        HashMap<String, StringBuilder> namedParameters = new HashMap<String, StringBuilder>();
        int currentQuote = 45;
        int parameterCount = 0;
        for (int i2 = 0; i2 < sql.length(); ++i2) {
            if (withinQuotes) {
                if (sql.charAt(i2) != currentQuote) continue;
                withinQuotes = false;
                currentQuote = 45;
                continue;
            }
            if (sql.charAt(i2) == '\"' || sql.charAt(i2) == '\'') {
                withinQuotes = true;
                currentQuote = sql.charAt(i2);
                continue;
            }
            if (sql.charAt(i2) == ':' || sql.charAt(i2) == '&') {
                int j;
                StringBuilder parameter = new StringBuilder();
                for (j = i2 + 1; j < sql.length() && JdbcParameterUtils.parameterNameContinues(sql, j); ++j) {
                    parameter.append(sql.charAt(j));
                }
                if (j - i2 <= 1 || namedParameters.containsKey(parameter.toString())) continue;
                ++parameterCount;
                namedParameters.put(parameter.toString(), parameter);
                i2 = j - 1;
                continue;
            }
            if (sql.charAt(i2) != '?') continue;
            ++parameterCount;
        }
        if (namedParameterHolder != null) {
            namedParameterHolder.addAll(namedParameters.keySet());
        }
        return parameterCount;
    }

    private static boolean parameterNameContinues(String statement, int pos) {
        char character = statement.charAt(pos);
        return character != ' ' && character != ',' && character != ')' && character != '\"' && character != '\'' && character != '|' && character != ';' && character != '\n' && character != '\r';
    }
}

