/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MongoItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final String ID_KEY = "_id";
    private MongoOperations template;
    private final Object bufferKey = new Object();
    private String collection;
    private boolean delete = false;

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    protected MongoOperations getTemplate() {
        return this.template;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (!this.transactionActive()) {
            this.doWrite(items);
            return;
        }
        List<T> bufferedItems = this.getCurrentBuffer();
        bufferedItems.addAll(items);
    }

    protected void doWrite(List<? extends T> items) {
        if (!CollectionUtils.isEmpty(items)) {
            if (this.delete) {
                this.delete(items);
            } else {
                this.saveOrUpdate(items);
            }
        }
    }

    private void delete(List<? extends T> items) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, items.get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        for (T item : items) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            Object objectId = document.get((Object)ID_KEY);
            if (objectId == null) continue;
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)ID_KEY).is(objectId));
            bulkOperations.remove(query);
        }
        bulkOperations.execute();
    }

    private void saveOrUpdate(List<? extends T> items) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, items.get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        FindAndReplaceOptions upsert = new FindAndReplaceOptions().upsert();
        for (T item : items) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            Object objectId = document.get((Object)ID_KEY) != null ? document.get((Object)ID_KEY) : new ObjectId();
            Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)ID_KEY).is(objectId));
            bulkOperations.replaceOne(query, (Object)document, upsert);
        }
        bulkOperations.execute();
    }

    private BulkOperations initBulkOperations(BulkOperations.BulkMode bulkMode, Object item) {
        BulkOperations bulkOperations = StringUtils.hasText(this.collection) ? this.template.bulkOps(bulkMode, this.collection) : this.template.bulkOps(bulkMode, ClassUtils.getUserClass(item));
        return bulkOperations;
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    private List<T> getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource(this.bufferKey)) {
            TransactionSynchronizationManager.bindResource(this.bufferKey, new ArrayList());
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCommit(boolean readOnly) {
                    List items = (List)TransactionSynchronizationManager.getResource(MongoItemWriter.this.bufferKey);
                    if (!CollectionUtils.isEmpty(items) && !readOnly) {
                        MongoItemWriter.this.doWrite(items);
                    }
                }

                @Override
                public void afterCompletion(int status) {
                    if (TransactionSynchronizationManager.hasResource(MongoItemWriter.this.bufferKey)) {
                        TransactionSynchronizationManager.unbindResource(MongoItemWriter.this.bufferKey);
                    }
                }
            });
        }
        return (List)TransactionSynchronizationManager.getResource(this.bufferKey);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.template != null, "A MongoOperations implementation is required.");
    }
}

